/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.client.ChatDraw;
import IM.client.DrawPanel;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

class DrawControls
extends JPanel
implements MouseListener,
MouseMotionListener,
ItemListener {
    DrawPanel target;
    int offset = 4;
    ChatDraw CD;

    public DrawControls(DrawPanel target, ChatDraw cd) {
        this.target = target;
        this.CD = cd;
        this.setPreferredSize(new Dimension(230, 32));
        this.setLayout(new BorderLayout());
        Border border = BorderFactory.createLineBorder(new Color(0, 87, 128));
        target.setForeground(Color.red);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        this.add((Component)p1, "East");
        Choice shapes = new Choice();
        shapes.addItemListener(this);
        shapes.addItem("\u76f4\u7ebf");
        shapes.addItem("\u624b\u7ed8");
        shapes.select(1);
        target.setDrawMode(1);
        shapes.setBackground(Color.lightGray);
        shapes.setVisible(false);
        p1.add(shapes);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.GRAY);
        g.drawLine(0, 0, this.getWidth(), 0);
        this.ccc(g);
    }

    private void ccc(Graphics g) {
        int k = 0;
        int l = 0;
        int i1 = 0;
        while (i1 < 6) {
            int j1 = 0;
            while (j1 < 6) {
                int k1 = 0;
                while (k1 < 6) {
                    g.setColor(new Color(i1 * 51, j1 * 51, k1 * 51));
                    g.fillRect(this.offset + l * 4, 4 + k * 4, 4, 4);
                    if (l > 34) {
                        ++k;
                        l = 0;
                    } else {
                        ++l;
                    }
                    ++k1;
                }
                ++j1;
            }
            ++i1;
        }
        this.setColor(g, this.target.getForeground(), true);
    }

    public void setColor(Graphics gg, Color c, boolean preview) {
        Graphics g = gg;
        if (gg == null) {
            g = this.getGraphics();
        }
        if (!preview) {
            this.target.setForeground(c);
        }
        g.setColor(c);
        g.fillRect(this.offset + 150, 10, 15, 15);
        if (gg == null) {
            g.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof Checkbox) {
            this.target.setForeground(((Component)e.getSource()).getForeground());
        } else if (e.getSource() instanceof Choice) {
            String choice = (String)e.getItem();
            if (choice.equals("\u76f4\u7ebf")) {
                this.target.setDrawMode(0);
            } else if (choice.equals("\u624b\u7ed8")) {
                this.target.setDrawMode(1);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        Color c = this.getColorUnderMouse(e.getX(), e.getY());
        if (c != null) {
            this.setColor(null, c, false);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        Color c = this.getColorUnderMouse(e.getX(), e.getY());
        if (c != null) {
            this.setColor(null, c, true);
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(0));
            this.setColor(null, this.target.getForeground(), true);
        }
    }

    Color getColorUnderMouse(int x, int y) {
        int k = 0;
        int l = 0;
        int i1 = 0;
        while (i1 < 6) {
            int j1 = 0;
            while (j1 < 6) {
                int k1 = 0;
                while (k1 < 6) {
                    Rectangle rc = new Rectangle(this.offset + l * 4, 4 + k * 4, 4, 4);
                    if (rc.contains(x, y)) {
                        return new Color(i1 * 51, j1 * 51, k1 * 51);
                    }
                    if (l > 34) {
                        ++k;
                        l = 0;
                    } else {
                        ++l;
                    }
                    ++k1;
                }
                ++j1;
            }
            ++i1;
        }
        return null;
    }
}

