/*
 * Decompiled with CFR 0.152.
 */
package jun.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jun.layout.PS;
import jun.layout.SizeDefine;

public class ZFormLayout
implements LayoutManager2 {
    private HashMap constraintMap = new HashMap();
    private ArrayList columnDefine = new ArrayList();
    private ArrayList rowDefine = new ArrayList();

    public ZFormLayout(int rowCount, int columnCount) {
        SizeDefine sd;
        int i = 0;
        while (i < rowCount) {
            sd = new SizeDefine();
            this.rowDefine.add(sd);
            ++i;
        }
        i = 0;
        while (i < columnCount) {
            sd = new SizeDefine();
            this.columnDefine.add(sd);
            ++i;
        }
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public Dimension maximumLayoutSize(Container target) {
        return null;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(200, 200);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(200, 200);
    }

    public void SetColumnSize(int index, int type, int size) {
        if (index < 0 || index >= this.columnDefine.size()) {
            return;
        }
        SizeDefine sd = (SizeDefine)this.columnDefine.get(index);
        sd.SetSize(type, size);
    }

    public int GetColumnSize(int index) {
        if (index < 0 || index >= this.columnDefine.size()) {
            return 0;
        }
        SizeDefine sd = (SizeDefine)this.columnDefine.get(index);
        return sd.m_Size;
    }

    public void SetRowSize(int index, int type, int size) {
        if (index < 0 || index >= this.rowDefine.size()) {
            return;
        }
        SizeDefine sd = (SizeDefine)this.rowDefine.get(index);
        sd.SetSize(type, size);
    }

    public int GetRowSize(int index) {
        if (index < 0 || index >= this.rowDefine.size()) {
            return 0;
        }
        SizeDefine sd = (SizeDefine)this.rowDefine.get(index);
        return sd.m_Size;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            throw new NullPointerException("Constraints must not be null.");
        }
        if (constraints instanceof String) {
            this.setConstraints(comp, new PS((String)constraints));
            return;
        }
        if (constraints instanceof PS) {
            this.setConstraints(comp, (PS)constraints);
            return;
        }
        throw new IllegalArgumentException("Illegal constraint type " + constraints.getClass());
    }

    public void setConstraints(Component comp, PS ps) {
        this.constraintMap.put(comp, ps);
    }

    public void removeLayoutComponent(Component comp) {
        this.constraintMap.remove(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension size = parent.getSize();
            int totalWidth = size.width;
            int totalHeight = size.height;
            int RowCount = this.rowDefine.size();
            int ColumnCount = this.columnDefine.size();
            this.ReCalculateSize(this.rowDefine, totalHeight);
            this.ReCalculateSize(this.columnDefine, totalWidth);
            Iterator it = this.constraintMap.keySet().iterator();
            while (it.hasNext()) {
                Component comp = (Component)it.next();
                PS ps = (PS)this.constraintMap.get(comp);
                this.SetComponentBounds(comp, ps);
            }
        }
    }

    public void ReCalculateSize(ArrayList define, int totalSize) {
        SizeDefine sd;
        int sumPercent = 0;
        int sumSize = 0;
        int i = 0;
        while (i < define.size()) {
            sd = (SizeDefine)define.get(i);
            if (sd.m_Type == SizeDefine.Stock) {
                sumPercent += sd.m_Percent;
            } else {
                sumSize += sd.m_Size;
            }
            ++i;
        }
        i = 0;
        while (i < define.size()) {
            sd = (SizeDefine)define.get(i);
            if (sd.m_Type == SizeDefine.Stock) {
                sd.m_Size = Math.max(0, totalSize - sumSize) * sd.m_Percent / Math.max(1, sumPercent);
            }
            ++i;
        }
    }

    public void SetComponentBounds(Component comp, PS ps) {
        int startRow = ps.StartRow;
        int endRow = ps.EndRow;
        int startCol = ps.StartCol;
        int endCol = ps.EndCol;
        if (endRow == 0) {
            endRow = startRow;
        }
        if (endCol == 0) {
            endCol = startCol;
        }
        if (endRow == -1) {
            endRow = this.rowDefine.size() - 1;
        }
        if (endCol == -1) {
            endCol = this.columnDefine.size() - 1;
        }
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int i = 0;
        while (i < startCol) {
            x += ((SizeDefine)this.columnDefine.get((int)i)).m_Size;
            ++i;
        }
        i = startCol;
        while (i <= endCol) {
            w += ((SizeDefine)this.columnDefine.get((int)i)).m_Size;
            ++i;
        }
        i = 0;
        while (i < startRow) {
            y += ((SizeDefine)this.rowDefine.get((int)i)).m_Size;
            ++i;
        }
        i = startRow;
        while (i <= endRow) {
            h += ((SizeDefine)this.rowDefine.get((int)i)).m_Size;
            ++i;
        }
        int margin = SizeDefine.Margin;
        if (comp instanceof JPanel && ((JPanel)comp).getLayout() instanceof ZFormLayout) {
            margin = 0;
        }
        comp.setBounds(x += margin, y += margin, w -= 2 * margin, h -= 2 * margin);
    }

    public void DrawGridLine(Graphics parentGraphics, Dimension parentSize) {
        Graphics g = parentGraphics;
        int totalWidth = parentSize.width;
        int totalHeight = parentSize.height;
        int n = 0;
        int i = 0;
        while (i < this.rowDefine.size()) {
            g.drawLine(0, n += ((SizeDefine)this.rowDefine.get((int)i)).m_Size, totalWidth, n);
            ++i;
        }
        i = 0;
        while (i < this.columnDefine.size()) {
            g.drawLine(n += ((SizeDefine)this.columnDefine.get((int)i)).m_Size, 0, n, totalHeight);
            ++i;
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException("\u672c\u65b9\u6cd5\u4e0d\u88ab\u652f\u6301\u3002\u8bf7\u4f7f\u7528 #addLayoutComponent(Component, Object) .");
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        ZFormLayout zfl = new ZFormLayout(5, 5);
        zfl.SetColumnSize(1, SizeDefine.Fixed, 100);
        zfl.SetColumnSize(2, SizeDefine.Stock, 2);
        zfl.SetColumnSize(3, SizeDefine.Stock, 1);
        zfl.SetRowSize(2, SizeDefine.Stock, 1);
        JPanel jp = new JPanel(zfl);
        jp.add((Component)new JButton("a"), new PS(1, 1));
        jp.add((Component)new JButton("b"), new PS(2, 2));
        jp.add((Component)new JButton("c"), new PS(3, 3));
        jp.add((Component)new JButton("d"), new PS(4, 4));
        jf.setContentPane(jp);
        jf.setDefaultCloseOperation(3);
        jf.setBounds(100, 100, 200, 200);
        jf.setVisible(true);
    }
}

