/*
 * Decompiled with CFR 0.152.
 */
package jun.control.numberedit;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import javax.swing.JTextField;

public class EditNumeric
extends JTextField
implements FocusListener,
KeyListener {
    private double m_dblCurrentValue = 0.0;
    private boolean m_ShowComma = true;
    private int m_DecimalCount = 4;
    private char m_DecimalSeparator;
    private char m_GroupingSeparator;
    private boolean m_AutoSelect = true;

    public EditNumeric(int decimalCount, boolean showComma) {
        this.m_DecimalCount = decimalCount;
        this.m_ShowComma = showComma;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        this.m_DecimalSeparator = dfs.getDecimalSeparator();
        this.m_GroupingSeparator = dfs.getGroupingSeparator();
        this.setHorizontalAlignment(4);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public double GetValue() {
        String s = this.getText();
        DecimalFormat df = new DecimalFormat(this.GetPattern());
        df.setGroupingSize(3);
        try {
            return df.parse(s).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public void SetValue(double dblValue) {
        String t = this.toString(dblValue);
        this.setText(t);
    }

    public void SetValue(Double d) {
        if (d == null) {
            this.SetValue(0.0);
        } else {
            this.SetValue((double)d);
        }
    }

    public String GetPattern() {
        return EditNumeric.GetPattern(this.m_DecimalCount, this.m_DecimalSeparator, this.m_ShowComma, this.m_GroupingSeparator);
    }

    public static String GetPattern(int DecimalCount, char DecimalSeparator, boolean ShowComma, char GroupingSeparator) {
        String pattern;
        if (DecimalCount == 0) {
            pattern = "###,###,###,###,###,###,##0";
        } else {
            String t = "00000000000000000000";
            t = t.substring(0, DecimalCount);
            pattern = "###,###,###,###,###,###,##0." + t;
        }
        if (DecimalSeparator != '.') {
            pattern.replaceAll(".", String.valueOf(DecimalSeparator));
        }
        if (!ShowComma) {
            pattern.replaceAll(",", "");
        }
        if (ShowComma && GroupingSeparator != ',') {
            pattern.replaceAll(",", String.valueOf(GroupingSeparator));
        }
        return pattern;
    }

    static double Round(double num, int i) {
        if (num >= 0.0) {
            return Math.floor(num * Math.pow(10.0, i) + 0.5) / Math.pow(10.0, i);
        }
        return Math.ceil(num * Math.pow(10.0, i) - 0.5) / Math.pow(10.0, i);
    }

    String toString(double dblValue) {
        String pattern = this.GetPattern();
        return EditNumeric.toString(dblValue, pattern, this.m_DecimalCount);
    }

    public static String toString(double dblValue, String pattern) {
        int n = pattern.length();
        int p = pattern.indexOf(".");
        if (p < 0) {
            p = n;
        }
        int DecimalCount = n - p;
        DecimalFormat df = new DecimalFormat(pattern);
        df.setGroupingSize(3);
        return df.format(EditNumeric.Round(dblValue, DecimalCount));
    }

    public static String toString(double dblValue, String pattern, int DecimalCount) {
        DecimalFormat df = new DecimalFormat(pattern);
        df.setGroupingSize(3);
        return df.format(EditNumeric.Round(dblValue, DecimalCount));
    }

    int CaretFarAwayDot() {
        int p = this.getCaretPosition();
        int n = this.getText().length();
        if (this.m_DecimalCount == 0) {
            return n - p;
        }
        return n - p - this.m_DecimalCount - 1;
    }

    int DotPos() {
        int n = this.getText().length();
        if (this.m_DecimalCount == 0) {
            return n;
        }
        return n - this.m_DecimalCount - 1;
    }

    public void SetShowComma(boolean b) {
        this.m_ShowComma = b;
    }

    public boolean GetShowComma() {
        return this.m_ShowComma;
    }

    public int GetDecimalCount() {
        return this.m_DecimalCount;
    }

    public void SetDecimalCount(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 20) {
            n = 20;
        }
        this.m_DecimalCount = n;
    }

    private void ProcessBackSpace() {
        this.ReplaceSel();
        int cp = this.getCaretPosition();
        if (cp == 0) {
            return;
        }
        String t = this.getText();
        if (t.charAt(0) == '-' && cp == 1) {
            return;
        }
        int cfad = this.CaretFarAwayDot();
        char c = t.charAt(cp - 1);
        if (c == this.m_DecimalSeparator || c == this.m_GroupingSeparator) {
            this.setCaretPosition(cp - 1);
            return;
        }
        String s = String.valueOf(t.substring(0, cp - 1)) + t.substring(cp);
        s = s.replaceAll(String.valueOf(this.m_GroupingSeparator), "");
        double d = 0.0;
        try {
            d = Double.parseDouble(s);
        }
        catch (Exception e) {
            d = 0.0;
        }
        this.SetValue(d);
        if (cfad >= 0) {
            this.setCaretPosition(Math.max(this.DotPos() - cfad, 0));
        } else {
            this.setCaretPosition(Math.max(this.DotPos() - cfad - 1, 0));
        }
    }

    private void ProcessDelete() {
        this.ReplaceSel();
        int cp = this.getCaretPosition();
        String t = this.getText();
        if (cp == t.length()) {
            return;
        }
        char c = t.charAt(cp);
        if (c == this.m_GroupingSeparator || c == '-') {
            this.setCaretPosition(cp + 2);
        } else {
            this.setCaretPosition(cp + 1);
        }
        this.ProcessBackSpace();
    }

    private void ProcessNumber(char pch) {
        String s;
        this.ReplaceSel();
        int cp = this.getCaretPosition();
        String t = this.getText();
        int cfad = 0;
        if (cp == t.length()) {
            s = String.valueOf(t) + String.valueOf(pch);
        } else {
            cfad = this.CaretFarAwayDot();
            char c = t.charAt(cp);
            if (c == '-') {
                ++cp;
            }
            s = String.valueOf(t.substring(0, cp)) + String.valueOf(pch) + t.substring(cp);
        }
        s = s.replaceAll(String.valueOf(this.m_GroupingSeparator), "");
        double d = Double.parseDouble(s);
        this.SetValue(d);
        if (cfad >= 0) {
            this.setCaretPosition(Math.max(this.DotPos() - cfad, 0));
        } else {
            this.setCaretPosition(Math.max(this.DotPos() - cfad + 1, 0));
        }
        if (d == 0.0 && t.charAt(0) == '-') {
            cp = this.getCaretPosition();
            this.setText("-" + this.getText());
            this.setCaretPosition(cp + 1);
        }
    }

    private void ReplaceSel() {
        this.replaceSelection("");
        if (this.getText().indexOf(46) < 0) {
            this.SetValue(this.GetValue());
            this.setCaretPosition(this.DotPos());
        }
    }

    private void ProcessDot() {
        this.ReplaceSel();
        if (this.m_DecimalCount == 0) {
            return;
        }
        this.setCaretPosition(this.DotPos() + 1);
    }

    private void ProcessMINUS() {
        this.ReplaceSel();
        double d = this.GetValue();
        int cp = this.getCaretPosition();
        String t = this.getText();
        int n = t.charAt(0) == '-' ? -1 : 1;
        this.SetValue(-d);
        this.setCaretPosition(cp += n);
        if (d == 0.0 && t.charAt(0) != '-') {
            this.setText("-" + this.getText());
            this.setCaretPosition(cp + 1);
        }
    }

    private void ProcessPLUS() {
        this.ReplaceSel();
        double d = this.GetValue();
        if (d >= 0.0) {
            return;
        }
        this.ProcessMINUS();
    }

    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
        char c = e.getKeyChar();
        if (c >= '0' && c <= '9') {
            this.ProcessNumber(c);
            e.consume();
        }
        if (c == '.') {
            this.ProcessDot();
        }
        if (c == '-') {
            this.ProcessMINUS();
        }
        if (c == '+') {
            this.ProcessPLUS();
        }
        switch (e.getKeyCode()) {
            case 8: {
                this.ProcessBackSpace();
                e.consume();
                break;
            }
            case 127: {
                this.ProcessDelete();
                e.consume();
                break;
            }
            case 38: 
            case 40: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 27: {
                break;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
        int n = this.getText().length();
        if (this.m_DecimalCount == 0 && this.GetValue() == 0.0) {
            this.setText("");
            return;
        }
        if (this.m_DecimalCount == 0) {
            this.setCaretPosition(n);
        } else {
            this.setCaretPosition(Math.max(n - this.m_DecimalCount - 1, 0));
        }
        if (this.m_AutoSelect) {
            this.setSelectionStart(0);
            this.setSelectionEnd(n);
        }
    }

    public void focusLost(FocusEvent e) {
    }
}

