/*
 * Decompiled with CFR 0.152.
 */
package flow;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class Tools {
    public static final int Auto = 999;
    public static final int Left = 0;
    public static final int Right = 1;
    public static final int Center = 2;
    public static final int Top = 0;
    public static final int Bottom = 1;

    public static void clip(Graphics2D g, Shape shape) {
        g.clip(shape);
    }

    public static void setClip(Graphics2D g, Shape shape) {
        g.setClip(shape);
    }

    public static Font GetFont(String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline) {
        String key = String.valueOf(FontName) + String.valueOf(FontSize) + String.valueOf(FontBold) + String.valueOf(FontItalic) + String.valueOf(FontUnderline);
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (FontBold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (FontItalic) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        Font font = new Font(map);
        return font;
    }

    public static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign) {
        Tools.DrawString(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, null, false);
    }

    public static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, Color highLightColor, boolean clip) {
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        if (s.length() == 0) {
            return;
        }
        g.setColor(textcolor);
        Shape oc = g.getClip();
        if (clip) {
            Tools.clip(g, rc);
        }
        Font font = Tools.GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(s, font, frc);
        float drawPosY = rc.y;
        switch (vAlign) {
            case 1: {
                drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                break;
            }
            case 2: {
                drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                break;
            }
            default: {
                drawPosY += layout.getAscent();
            }
        }
        float drawPosX = rc.x;
        switch (hAlign) {
            case 1: {
                drawPosX = (float)(rc.x + rc.width) - layout.getAdvance();
                break;
            }
            case 2: {
                drawPosX = (float)rc.x + ((float)rc.width - layout.getAdvance()) / 2.0f;
                break;
            }
            default: {
                drawPosX = rc.x;
            }
        }
        if (highLightColor != null) {
            g.setColor(highLightColor);
            layout.draw(g, drawPosX - 1.0f, drawPosY - 1.0f);
            layout.draw(g, drawPosX + 1.0f, drawPosY - 1.0f);
            layout.draw(g, drawPosX - 1.0f, drawPosY + 1.0f);
            layout.draw(g, drawPosX + 1.0f, drawPosY + 1.0f);
        }
        g.setColor(textcolor);
        layout.draw(g, drawPosX, drawPosY);
        if (clip) {
            Tools.setClip(g, oc);
        }
    }

    public static void initAllFontSon9() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        Font f1 = new Font("SimSun", 0, 12);
        Font f2 = new Font("SimSun", 1, 12);
        Tools.initFontDefaults(table, f1, f2, f1, f1, f1, f1, f1);
    }

    public static void initFontDefaults(UIDefaults table, Object controlFont, Object controlBoldFont, Object fixedControlFont, Object menuFont, Object messageFont, Object toolTipFont, Object windowFont) {
        Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "Spinner.font", fixedControlFont, "TextArea.font", fixedControlFont, "TitledBorder.font", controlBoldFont, "ToolTip.font", toolTipFont};
        table.putDefaults(defaults);
        if (menuFont != null) {
            Object[] menuDefaults = new Object[]{"CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
            table.putDefaults(menuDefaults);
        }
    }

    public static Applet ContainedByApplet(Component op) {
        Component ct = op;
        while (ct != null) {
            if (ct instanceof Applet) {
                return (Applet)ct;
            }
            ct = ct.getParent();
        }
        return null;
    }

    public static Image GetImageFromURL(Component Wnd, String imgURL) {
        Applet ContainedByApplet = Tools.ContainedByApplet(Wnd);
        Image img = null;
        URL url = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            url = Wnd.getClass().getClassLoader().getResource(imgURL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        img = ContainedByApplet != null ? ContainedByApplet.getImage(url) : tk.getImage(url);
        return img;
    }

    public static Object GetObjectFromServlet(URL url) {
        Object ret = null;
        try {
            URLConnection urlcon = url.openConnection();
            urlcon.connect();
            GZIPInputStream gs = new GZIPInputStream(new BufferedInputStream(urlcon.getInputStream()));
            ObjectInputStream p = new ObjectInputStream(gs);
            ret = p.readObject();
            p.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return ret;
    }

    public static void ShowInfo(Component parentComponent, String info) {
        JOptionPane.showMessageDialog(parentComponent, info, "\u63d0\u793a", 2);
    }

    public static byte[] readBytesFromFile(String fileName) {
        byte[] bytes = new byte[]{};
        try {
            File file = new File(fileName);
            if (file == null || !file.exists()) {
                return bytes;
            }
            FileInputStream fis = new FileInputStream(file);
            DataInputStream dis = new DataInputStream(fis);
            bytes = new byte[(int)file.length()];
            dis.readFully(bytes);
            dis.close();
        }
        catch (IOException ie) {
            bytes = new byte[]{};
        }
        return bytes;
    }

    public static void MoveToScreenCenter(Component jf) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        jf.setLocation((d.width - jf.getWidth()) / 2, (d.height - jf.getHeight()) / 2);
    }

    public static String replaceAll(String source, String replaceWhat, String replaceTo) {
        int p = -1;
        while ((p = source.indexOf(replaceWhat)) >= 0) {
            source = String.valueOf(source.substring(0, p)) + replaceTo + source.substring(p + replaceWhat.length());
        }
        return source;
    }
}

