/*
 * Decompiled with CFR 0.152.
 */
package flow;

import EDU.auburn.VGJ.algorithm.GraphAlgorithm;
import EDU.auburn.VGJ.graph.Edge;
import EDU.auburn.VGJ.graph.GMLlexer;
import EDU.auburn.VGJ.graph.GMLobject;
import EDU.auburn.VGJ.graph.Graph;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.graph.Set;
import EDU.auburn.VGJ.gui.GraphCanvas;
import EDU.auburn.VGJ.gui.GraphCanvasActionListener;
import appletrpc.RPC;
import appletrpc.RPCParameter;
import flow.AppletFlow;
import flow.Escape;
import flow.Tools;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import netscape.javascript.JSObject;

public class MainFrame
extends JPanel
implements GraphCanvasActionListener,
ComponentListener {
    public static String jvmVer = System.getProperties().getProperty("java.vm.version");
    public static boolean jvm16 = Double.valueOf(jvmVer.substring(0, 3)) >= 1.6;
    private static Border SelectedBorder = BorderFactory.createLineBorder(new Color(255, 120, 120), 1);
    public Graph graph_ = null;
    public GraphCanvas graphCanvas_;
    JScrollPane viewingPanel_;
    HashMap NodeLabel2ID = new HashMap();
    HashMap UserNameMap = new HashMap();
    Border NormalBorder;
    Node currentNode;
    Edge currentEdge;
    AppletFlow appletFlow;
    boolean loaded = false;

    public MainFrame(AppletFlow af) {
        Tools.initAllFontSon9();
        this.appletFlow = af;
        this.addComponentListener(this);
        this.graph_ = new Graph(true);
        this.setLayout(new BorderLayout());
        this.graphCanvas_ = new GraphCanvas(this.graph_, this);
        this.graphCanvas_.AddGraphCanvasActionListener(this);
        this.viewingPanel_ = new JScrollPane(this.graphCanvas_);
        this.add((Component)this.viewingPanel_, "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Rectangle rc = MainFrame.this.getBounds();
                if (!MainFrame.this.loaded) {
                    MainFrame.this.LoadFlow();
                    MainFrame.this.loaded = true;
                }
            }
        });
        this.graphCanvas_.setMouseMode(4);
        this.componentResized(null);
        try {
            JSObject win = JSObject.getWindow((Applet)this.appletFlow);
            win.call("setAppletLoadOk", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void print(Graphics g) {
        g.setColor(Color.WHITE);
        Rectangle rc = this.getBounds();
        g.fillRect(0, 0, rc.width, rc.height);
        super.print(g);
    }

    public void LoadFlow() {
        RPCParameter p = new RPCParameter();
        p.put("id", this.appletFlow.FlowID);
        p = RPC.Call(String.valueOf(this.appletFlow.HomeURL) + "servlet/wiseoa.flow.appletrpc.FlowManager", "GetFlowDefine", p);
        try {
            if (!p.Success) {
                throw new Exception(p.ErrorText);
            }
            byte[] data = p.get("define", "").getBytes();
            this.LoadFlow(data);
            this.graph_.setID(this.appletFlow.FlowID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String LoadFlow(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            GMLlexer lexer = new GMLlexer(stream);
            GMLobject GMLfile_ = new GMLobject(lexer, null);
            GMLobject gmlgraph = GMLfile_.getGMLSubObject("graph", 3, false);
            if (gmlgraph == null) {
                GMLfile_ = null;
                return "\u4e0d\u662f\u5408\u6cd5\u7684\u5b9a\u4e49.";
            }
            Graph newgraph = null;
            newgraph = new Graph(gmlgraph);
            this.graph_.copy(newgraph);
            return "";
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            return string;
        }
        finally {
            this.graphCanvas_.unselectItems();
            this.moveToVisible();
            this.RebuildNodeLabel2ID();
            this.RebuildUserNameMap();
            this.rebuildNodeNo();
        }
    }

    public void moveToVisible() {
        Rectangle rc = this.getBounds();
        Rectangle rc2 = this.graphCanvas_.computeBounds();
        int x = rc.x = (2000 - rc.width) / 2;
        int y = Math.max(0, rc2.y - 20);
        this.viewingPanel_.getHorizontalScrollBar().setValue(x);
        this.viewingPanel_.getVerticalScrollBar().setValue(y);
        this.repaint();
    }

    public void overturn() {
        this.graphCanvas_.overturn();
    }

    public void moveToCenter() {
        this.graphCanvas_.moveToCenter();
        this.moveToVisible();
    }

    public String getDefine() {
        this.AutoSetShape();
        GMLobject GMLfile_ = null;
        GMLfile_ = new GMLobject(null, 5);
        GMLfile_.addObjectToEnd(new GMLobject("graph", 3));
        GMLobject gmlgraph = GMLfile_.getGMLSubObject("graph", 3, false);
        this.graph_.setGMLvalues(gmlgraph);
        gmlgraph.prune();
        String define = GMLfile_.toString(0);
        return define;
    }

    public void setInnerGuidSaveAsGuid() {
        Node node = this.graph_.firstNode();
        while (node != null) {
            node.setInnerGuid(node.getGuid());
            node = this.graph_.nextNode(node);
        }
    }

    public void Save() {
        try {
            this.AutoSetShape();
            this.rebuildNodeNo();
            RPCParameter p = new RPCParameter();
            p.put("id", this.appletFlow.FlowID);
            p.put("valid", this.Validate());
            GMLobject GMLfile_ = null;
            GMLfile_ = new GMLobject(null, 5);
            GMLfile_.addObjectToEnd(new GMLobject("graph", 3));
            GMLobject gmlgraph = GMLfile_.getGMLSubObject("graph", 3, false);
            this.graph_.setID(this.appletFlow.FlowID);
            this.graph_.setGMLvalues(gmlgraph);
            gmlgraph.prune();
            String define = GMLfile_.toString(0);
            p.put("define", define);
            p.put("img", this.graphCanvas_.ExportToImage());
            p = RPC.Call(String.valueOf(this.appletFlow.HomeURL) + "servlet/wiseoa.flow.appletrpc.FlowManager", "SetFlowDefine", p);
            if (p.Success) {
                boolean needResetInnerGuid = p.get("needResetInnerGuid", false);
                if (needResetInnerGuid) {
                    System.out.println("\u672c\u6d41\u7a0b\u662f\u5bfc\u5165\u7684\u6d41\u7a0b\uff0c\u5e76\u4e14\u662f\u7b2c\u4e00\u6b21\u4fdd\u5b58\uff0c\u5728\u514b\u9686\u6743\u9650\u8bbe\u7f6e\u540e\uff0c\u590d\u4f4dinnerguid\uff0c\u5e76\u91cd\u65b0\u4fdd\u5b58\u3002");
                    this.setInnerGuidSaveAsGuid();
                    this.Save();
                    return;
                }
            } else {
                throw new Exception(p.ErrorText);
            }
            Tools.ShowInfo(this.appletFlow.mainFrame, "\u4fdd\u5b58\u6210\u529f\u3002\n\u5982\u679c\u9700\u8981\u6062\u590d\u4e4b\u524d\u7684\u5b9a\u4e49\uff0c\u53ef\u4ee5\u5728 oa_flow_history\u4e2d\u67e5\u627e\u3002");
        }
        catch (Exception ex) {
            Tools.ShowInfo(this, ex.getMessage());
        }
    }

    public void loadFile(String filename) {
        GMLobject GMLfile_ = null;
        try {
            File fname = new File(filename);
            int size = (int)fname.length();
            int bytes_read = 0;
            FileInputStream infile = new FileInputStream(fname);
            byte[] data = new byte[size];
            while (bytes_read < size) {
                bytes_read += infile.read(data, bytes_read, size - bytes_read);
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            GMLlexer lexer = new GMLlexer(stream);
            try {
                GMLfile_ = new GMLobject(lexer, null);
                GMLobject gmlgraph = GMLfile_.getGMLSubObject("graph", 3, false);
                if (gmlgraph == null) {
                    GMLfile_ = null;
                    Tools.ShowInfo(this, "File does not contain a graph.");
                    return;
                }
                Graph newgraph = null;
                newgraph = new Graph(gmlgraph);
                this.graph_.copy(newgraph);
                this.graphCanvas_.update(true);
            }
            catch (Exception error) {
                Tools.ShowInfo(this, error.getMessage());
                return;
            }
        }
        catch (FileNotFoundException ex) {
            Tools.ShowInfo(this, "Error loading file  \"" + filename + "\".");
        }
        catch (IOException ex) {
            Tools.ShowInfo(this, ex.getMessage());
        }
    }

    public void applyAlgorithm_(GraphAlgorithm alg) {
        this.AutoSetShape();
        if (this.graph_.numberOfNodes() < 1) {
            Tools.ShowInfo(this, "\u6ca1\u6709\u5b9a\u4e49\uff0c\u65e0\u6cd5\u5e03\u5c40.");
        } else {
            this.graph_.removeGroups();
            this.graph_.pack();
            this.graphCanvas_.setWireframe(true);
            String msg = alg.compute(this.graph_, this.graphCanvas_);
            this.graphCanvas_.setWireframe(false);
            if (msg != null) {
                Tools.ShowInfo(this, msg);
            }
            this.graphCanvas_.update(true);
        }
    }

    public void AfterAddEdge(Edge edge) {
    }

    public void AfterAddNode(Node node) {
        this.RebuildNodeLabel2ID();
        this.RebuildUserNameMap();
    }

    public void eventMousePressed(MouseEvent e) {
        if (e.getButton() == 3 && !this.appletFlow.useredForImport) {
            this.ShowMenu(e.getPoint());
        }
    }

    public void ShowMenu(Point p) {
        JPopupMenu ret = new JPopupMenu("popup");
        Border border = BorderFactory.createLineBorder(new Color(88, 88, 103));
        ret.setBorder(border);
        this.addMenuItem(ret, " \u5c5e \u6027 \u8bbe \u7f6e", "flow/res/property.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.appletFlow.showProperty();
            }
        });
        this.addMenuItem(ret, " \u5207\u6362\u5230\u9009\u62e9\u72b6\u6001", "flow/res/select.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.appletFlow.setActionSelect();
            }
        });
        this.addMenuItem(ret, " \u5207\u6362\u5230\u6b65\u9aa4\u5de5\u5177", "flow/res/addnode.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.appletFlow.setActionCreateNode();
            }
        });
        this.addMenuItem(ret, " \u5207\u6362\u5230\u52a8\u4f5c\u5de5\u5177", "flow/res/addedge.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.appletFlow.setActionCreateEdge();
            }
        });
        this.addMenuItem(ret, " \u5168 \u9009 ", "flow/res/menublack.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.graphCanvas_.selectAll();
            }
        });
        ret.addSeparator();
        this.addMenuItem(ret, " \u5220 \u9664 ", "flow/res/erase.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.graphCanvas_.deleteSelected(true);
            }
        });
        ret.addSeparator();
        this.addMenuItem(ret, " \u5c45 \u4e2d ", "flow/res/movecenter.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.appletFlow.moveToCenter();
            }
        });
        this.addMenuItem(ret, " \u65e0\u95ed\u73af\u5e03\u5c40", "flow/res/cgd.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.appletFlow.autoLayoutCGD();
            }
        });
        this.addMenuItem(ret, " \u6811\u72b6\u5e03\u5c40", "flow/res/treedown.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.appletFlow.autoLayoutTreeDown();
            }
        });
        ret.addSeparator();
        this.addMenuItem(ret, " \u5bfc \u51fa ", "flow/res/menublack.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.appletFlow.Export();
            }
        });
        this.addMenuItem(ret, " \u5bfc \u5165 ", "flow/res/menublack.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.appletFlow.Import();
            }
        });
        this.addMenuItem(ret, " \u4fdd \u5b58 ", "flow/res/disk2.gif", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.Save();
            }
        });
        ret.show(this.graphCanvas_, p.x, p.y);
    }

    private void addMenuItem(JPopupMenu menu, String label, String img, ActionListener action) {
        JMenuItem m = new JMenuItem(label, new ImageIcon(Tools.GetImageFromURL(this, img)));
        Insets ins = new Insets(0, -17, 0, 0);
        if (!jvm16) {
            m.setMargin(ins);
        }
        Dimension dim = m.getPreferredSize();
        dim.height = 19;
        m.setPreferredSize(dim);
        m.setBackground(Color.white);
        menu.add(m);
        m.addActionListener(action);
    }

    public void GraphKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 83 && e.isControlDown()) {
            this.Save();
        }
    }

    public void AfterDeleteEdge(Edge edge) {
    }

    public void AfterDeleteNode(Node node) {
        this.RebuildNodeLabel2ID();
        this.RebuildUserNameMap();
    }

    public boolean DeleteEdgePermit(Edge edge) {
        return true;
    }

    public boolean DeleteNodePermit(Node node) {
        if (node.isRoot() && this.RootNodeCount() == 1) {
            Tools.ShowInfo(this, "[\u5f00\u59cb]\u4e0d\u5141\u8bb8\u5220\u9664");
            return false;
        }
        int result = JOptionPane.showConfirmDialog(this, "\u786e\u4fe1\u8981\u5220\u9664\u9009\u4e2d\u7684\u5bf9\u8c61\u5417");
        return result == 0;
    }

    public void EdgeClicked(Edge edge, int quadrant, int clickCount) {
        try {
            JSObject win = JSObject.getWindow((Applet)this.appletFlow);
            win.call("loadEdgeProperty", edge, new Integer(quadrant), new Integer(clickCount));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void NodeClicked(Node node, int quadrant, int clickCount) {
        try {
            JSObject win = JSObject.getWindow((Applet)this.appletFlow);
            win.call("loadNodeProperty", node, new Integer(quadrant), new Integer(clickCount));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void BlankClicked(int quadrant) {
        try {
            JSObject win = JSObject.getWindow((Applet)this.appletFlow);
            win.call("blankClicked", new Integer(quadrant));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String NodeLabel2IDHTML() {
        String tagName = "othernode";
        StringBuffer sb = new StringBuffer(1024);
        sb.append("<span class='selectspan' ><select class='flatselect'  id='" + tagName + "'   name='" + tagName + "'    style='font-size:12px' >");
        Iterator it = this.NodeLabel2ID.keySet().iterator();
        while (it.hasNext()) {
            String s = it.next().toString();
            String label = (String)this.NodeLabel2ID.get(s);
            label = label.replaceAll("[\\\\n]", "");
            label = label.replaceAll("[\\n]", "");
            label = label.replaceAll(" ", "");
            sb.append("<option value='" + s + "'  value2='" + label + "'   >" + label + "</option>");
        }
        sb.append("</select></span>");
        return sb.toString();
    }

    public String getNodeNo2IdHTML() {
        this.rebuildNodeNo();
        StringBuffer sb = new StringBuffer();
        sb.append("<select>");
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (!tmpnode.isRoot() && !tmpnode.isLeaf()) {
                String label = String.valueOf(tmpnode.getNodeNo());
                sb.append("<option value=\"").append(tmpnode.getGuid()).append("\">").append(label).append("</optional>");
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        sb.append("</select>");
        return sb.toString();
    }

    public void RebuildNodeLabel2ID() {
        this.NodeLabel2ID.clear();
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            String nodeLabel = tmpnode.getLabel();
            String guid = tmpnode.getGuid();
            this.NodeLabel2ID.put(guid, nodeLabel);
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        try {
            JSObject win = JSObject.getWindow((Applet)this.appletFlow);
            win.call("loadNodeList", this.NodeLabel2IDHTML(), this.getNodeNo2IdHTML());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void RebuildUserNameMap() {
        this.UserNameMap.clear();
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            String name = tmpnode.getExecutor();
            StringTokenizer stk = new StringTokenizer(name, " ");
            while (stk.hasMoreTokens()) {
                String t = stk.nextToken().trim();
                if (t.equals("")) continue;
                this.UserNameMap.put(t, t);
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
    }

    public void AutoSetShape() {
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (this.graph_.parents(tmpnode.getIndex()).isEmpty()) {
                tmpnode.setShape(2);
                tmpnode.setRoot(true);
                tmpnode.setBackgroundColor(new Color(255, 230, 180));
            } else if (this.graph_.children(tmpnode.getIndex()).isEmpty()) {
                tmpnode.setShape(2);
                tmpnode.setBackgroundColor(new Color(255, 230, 180));
                tmpnode.setLeaf(true);
            } else {
                Set p = this.graph_.parents(tmpnode.getIndex());
                if (p.numberOfElements() == 1 && this.graph_.nodeFromIndex(p.first()).isRoot()) {
                    tmpnode.setShape(1);
                    tmpnode.setBackgroundColor(new Color(14674390));
                } else {
                    tmpnode.setShape(0);
                    tmpnode.setBackgroundColor(Node.DefaultBackgroundColor);
                }
                tmpnode.setRoot(false);
                tmpnode.setLeaf(false);
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
    }

    public int RootNodeCount() {
        int numroots = 0;
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (this.graph_.parents(tmpnode.getIndex()).isEmpty()) {
                ++numroots;
                tmpnode.setRoot(true);
            } else {
                tmpnode.setRoot(false);
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        return numroots;
    }

    public int LeafNodeCount() {
        int numroots = 0;
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (this.graph_.children(tmpnode.getIndex()).isEmpty()) {
                ++numroots;
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        return numroots;
    }

    public boolean AllNodesHaveExecutor() {
        return true;
    }

    private boolean Validate() {
        if (this.RootNodeCount() > 1) {
            Tools.ShowInfo(this, "\u4e0d\u662f\u6240\u6709\u6b65\u9aa4\u90fd\u80fd\u4ece[\u63d0\u4ea4]\u6d41\u8f6c\u5230\uff0c\u672c\u5de5\u4f5c\u6d41\u5c06\u4e0d\u5141\u8bb8\u6267\u884c\u3002");
            return false;
        }
        if (this.LeafNodeCount() > 1) {
            Tools.ShowInfo(this, "\u672c\u6d41\u7a0b\u4e0d\u6b62\u4e00\u4e2a\u7ec8\u6b62\u6b65\u9aa4\uff0c\u672c\u5de5\u4f5c\u6d41\u5c06\u4e0d\u5141\u8bb8\u6267\u884c\u3002");
            return false;
        }
        if (!this.AllNodesHaveExecutor()) {
            Tools.ShowInfo(this, "\u672c\u6d41\u7a0b\u4e0d\u662f\u6240\u6709\u6b65\u9aa4\u90fd\u6307\u5b9a\u4e86\u6267\u884c\u4eba\uff0c\u672c\u5de5\u4f5c\u6d41\u5c06\u4e0d\u5141\u8bb8\u6267\u884c\u3002");
            return false;
        }
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (tmpnode.isRoot()) {
                if (tmpnode.isLeaf()) {
                    Tools.ShowInfo(this, "\u4e0d\u5141\u8bb8\u6709\u6b65\u9aa4\u6307\u5411\u5f00\u59cb\u3002");
                    return false;
                }
                if (tmpnode.numberOfChildren() != 1) {
                    Tools.ShowInfo(this, "\u5f00\u59cb\u8282\u70b9\u53ea\u80fd\u6307\u5411\u4e00\u4e2a\u6b65\u9aa4\uff0c\u5426\u5219\u65e0\u6cd5\u786e\u5b9a\u54ea\u4e2a\u662f\u6700\u5f00\u59cb\u7684\u6b65\u9aa4\u3002");
                    return false;
                }
                Node firstChild = this.graph_.getNodeFromIndex(tmpnode.getChildren().first());
                firstChild.setExecutor(Escape.escape("<@>yes</@>"));
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            tmpnode.isLeaf();
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        return true;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.moveToVisible();
    }

    public void componentShown(ComponentEvent e) {
    }

    public String getNodeLabel2ID() {
        StringBuffer sb = new StringBuffer();
        sb.append("<select>");
        for (String key : this.NodeLabel2ID.keySet()) {
            String label = (String)this.NodeLabel2ID.get(key);
            label = label.replaceAll("\\\\n", "");
            label = label.replaceAll("\\n", "");
            label = label.replaceAll(" ", "");
            sb.append("<option value=\"").append(key).append("\">").append(label).append("</optional>");
        }
        sb.append("</select>");
        return sb.toString();
    }

    public void rebuildNodeNo() {
        this.clearNodeNo();
        Node root = null;
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (tmpnode.isRoot()) {
                root = tmpnode;
                break;
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        if (root == null) {
            return;
        }
        root.setNodeNo(0);
        this.setNodeNo(root, 1);
    }

    public void clearNodeNo() {
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            tmpnode.setNodeNo(0);
            tmpnode = this.graph_.nextNode(tmpnode);
        }
    }

    private int setNodeNo(Node node, int no) {
        Node c;
        ArrayList<Node> skipList = new ArrayList<Node>();
        int child = node.firstChild();
        while (child != -1) {
            c = this.graph_.getNodeFromIndex(child);
            if (c.getNodeNo() > 0 && !c.isLeaf()) {
                skipList.add(c);
            } else {
                this.swapWithLeaf(no);
                c.setNodeNo(no);
                if (!c.isLeaf()) {
                    ++no;
                }
            }
            child = node.nextChild();
        }
        child = node.firstChild();
        while (child != -1) {
            c = this.graph_.getNodeFromIndex(child);
            if (!skipList.contains(c)) {
                no = this.setNodeNo(c, no);
            }
            child = node.nextChild();
        }
        skipList.clear();
        return no;
    }

    private void swapWithLeaf(int no) {
        Node node = this.graph_.firstNode();
        while (node != null) {
            int n = node.getNodeNo();
            if (n == no) {
                node.setNodeNo(no + 1);
                break;
            }
            node = this.graph_.nextNode(node);
        }
    }
}

