/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.graph;

import java.util.NoSuchElementException;

public class Set
implements Cloneable {
    static final int BITS = 6;
    static final int MASK = 63;
    private long[] bits_ = new long[1];
    private int nextPosition_ = 0;

    public Set() {
    }

    public Set(int element) {
        this.includeElement(element);
    }

    private void grow_(int len) {
        long[] newbits = new long[len];
        System.arraycopy(this.bits_, 0, newbits, 0, this.bits_.length);
        this.bits_ = newbits;
    }

    public int searchNext(int n) {
        long bit;
        int val;
        int bytepos;
        int i = bytepos = n >> 6;
        while (i < this.bits_.length && this.bits_[i] == 0L) {
            ++i;
        }
        if (i == this.bits_.length) {
            return -1;
        }
        long byteval = this.bits_[i];
        if (i == bytepos) {
            val = n;
            bit = 1L << (val & 0x3F);
            while ((bit & byteval) == 0L && bit != Long.MIN_VALUE) {
                bit <<= 1;
                ++val;
            }
            if ((bit & byteval) != 0L) {
                return val;
            }
            ++i;
            while (i < this.bits_.length && this.bits_[i] == 0L) {
                ++i;
            }
            if (i == this.bits_.length) {
                return -1;
            }
            byteval = this.bits_[i];
        }
        val = i << 6;
        bit = 1L;
        while ((bit & byteval) == 0L && bit != Long.MIN_VALUE) {
            bit <<= 1;
            ++val;
        }
        if ((bit & byteval) == 0L) {
            return -1;
        }
        return val;
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.bits_.length) {
            if (this.bits_[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int first() {
        this.nextPosition_ = this.searchNext(0) + 1;
        return this.nextPosition_ - 1;
    }

    public int next() {
        this.nextPosition_ = this.searchNext(this.nextPosition_) + 1;
        return this.nextPosition_ - 1;
    }

    public boolean isElement(int n) {
        int bytepos = n >> 6;
        if (bytepos >= this.bits_.length) {
            return false;
        }
        return (this.bits_[bytepos] & 1L << (n & 0x3F)) != 0L;
    }

    public void includeElement(int n) {
        int bytepos = n >> 6;
        if (bytepos >= this.bits_.length) {
            this.grow_(bytepos + 1);
        }
        int n2 = bytepos;
        this.bits_[n2] = this.bits_[n2] | 1L << (n & 0x3F);
    }

    public void removeElement(int n) throws NoSuchElementException {
        int bytepos = n >> 6;
        if (bytepos >= this.bits_.length) {
            return;
        }
        int n2 = bytepos;
        this.bits_[n2] = this.bits_[n2] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean isSubset(Set s) {
        int i;
        int minsize = Math.min(this.bits_.length, s.bits_.length);
        if (minsize < s.bits_.length) {
            i = minsize;
            while (i < s.bits_.length) {
                if (s.bits_[i] != 0L) {
                    return false;
                }
                ++i;
            }
        }
        i = 0;
        while (i < minsize) {
            if ((s.bits_[i] & this.bits_[i]) != s.bits_[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void intersect(Set s) {
        int minsize = Math.min(this.bits_.length, s.bits_.length);
        int i = 0;
        while (i < minsize) {
            int n = i;
            this.bits_[n] = this.bits_[n] & s.bits_[i];
            ++i;
        }
        if (this.bits_.length > s.bits_.length) {
            i = s.bits_.length;
            while (i < this.bits_.length) {
                this.bits_[i] = 0L;
                ++i;
            }
        }
    }

    public void union(Set s) {
        if (s.bits_.length > this.bits_.length) {
            this.grow_(s.bits_.length);
        }
        int i = 0;
        while (i < s.bits_.length) {
            int n = i;
            this.bits_[n] = this.bits_[n] | s.bits_[i];
            ++i;
        }
    }

    public void difference(Set s) {
        if (s.bits_.length > this.bits_.length) {
            this.grow_(s.bits_.length);
        }
        int i = 0;
        while (i < s.bits_.length) {
            this.bits_[i] = (this.bits_[i] | s.bits_[i]) ^ s.bits_[i];
            ++i;
        }
    }

    public Object clone() {
        Set set = new Set();
        set.bits_ = new long[this.bits_.length];
        System.arraycopy(this.bits_, 0, set.bits_, 0, this.bits_.length);
        return set;
    }

    public boolean equals(Set s) {
        int i;
        int minsize = Math.min(this.bits_.length, s.bits_.length);
        if (minsize < s.bits_.length) {
            i = minsize;
            while (i < s.bits_.length) {
                if (s.bits_[i] != 0L) {
                    return false;
                }
                ++i;
            }
        }
        if (minsize < this.bits_.length) {
            i = minsize;
            while (i < s.bits_.length) {
                if (this.bits_[i] != 0L) {
                    return false;
                }
                ++i;
            }
        }
        i = 0;
        while (i < minsize) {
            if (s.bits_[i] != this.bits_[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String to_string = "(";
        boolean first_element = true;
        int i = this.first();
        while (i != -1) {
            if (first_element) {
                first_element = false;
            } else {
                to_string = String.valueOf(to_string) + ", ";
            }
            to_string = String.valueOf(to_string) + i;
            i = this.next();
        }
        to_string = String.valueOf(to_string) + ")";
        return to_string;
    }

    public String toShortString() {
        String to_string = "(";
        boolean first_element = true;
        int i = this.first();
        while (i != -1) {
            if (first_element) {
                first_element = false;
            } else {
                to_string = String.valueOf(to_string) + ", ";
            }
            to_string = String.valueOf(to_string) + i;
            if (this.isElement(i + 1) && this.isElement(i + 2)) {
                to_string = String.valueOf(to_string) + "-";
                while (this.isElement(i + 1)) {
                    i = this.next();
                }
                to_string = String.valueOf(to_string) + i;
            }
            i = this.next();
        }
        to_string = String.valueOf(to_string) + ")";
        return to_string;
    }

    public int numberOfElements() {
        int num = 0;
        int i = this.first();
        while (i != -1) {
            i = this.next();
            ++num;
        }
        return num;
    }

    public void fill(int n) {
        int bytepos;
        if ((bytepos = --n >> 6) >= this.bits_.length) {
            this.grow_(bytepos + 1);
        }
        int i = 0;
        while (i < this.bits_.length - 1) {
            this.bits_[i] = -1L;
            ++i;
        }
        long bit = 1L;
        while (bit <= 1L << (n & 0x3F)) {
            int n2 = i;
            this.bits_[n2] = this.bits_[n2] | bit;
            bit <<= 1;
        }
    }

    public void indexedUnion(Set[] set_list, Set index) {
        int i = index.first();
        while (i != -1) {
            this.union(set_list[i]);
            i = index.next();
        }
    }

    public boolean intersects(Set set) {
        int len = Math.min(this.bits_.length, set.bits_.length);
        int i = 0;
        while (i < len) {
            if ((this.bits_[i] & set.bits_[i]) != 0L) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

