/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.graph;

import EDU.auburn.VGJ.graph.GMLlexer;
import EDU.auburn.VGJ.graph.GMLobject;
import EDU.auburn.VGJ.graph.Set;
import EDU.auburn.VGJ.graph.Tool;
import EDU.auburn.VGJ.util.DDimension;
import EDU.auburn.VGJ.util.DDimension3;
import EDU.auburn.VGJ.util.DPoint;
import EDU.auburn.VGJ.util.DPoint3;
import flow.Escape;
import flow.Tools;
import flow.ZDataParser;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import jun.db.impl.DataStoreFactory;

public class Node
implements Cloneable,
ImageObserver {
    private Set adjacencies_;
    protected double x_;
    protected double y_;
    protected double z_;
    protected DPoint3 oldpos_ = null;
    protected DPoint3 grouppos_ = null;
    protected DDimension3 oldbox_ = null;
    protected DDimension3 groupbox_ = null;
    private double movingZ_;
    protected double width_;
    protected double height_;
    protected double depth_;
    private int shape_;
    private String[] label_;
    private int labelPosition_;
    private String imageLocation_;
    private String imageType_;
    private Image image_;
    private double temp_;
    private static boolean defaultLabel_ = true;
    protected boolean isDummy_;
    protected int index_;
    private boolean selected_;
    private boolean multiSubmitPermit_;
    private boolean canViewAllAnswer;
    protected int id_;
    protected boolean haveId_;
    private static Toolkit toolkit_ = null;
    private static URL context_ = null;
    private boolean imageChange_;
    protected int groupNodeId_;
    protected Node groupNode_;
    protected boolean isGroup_ = false;
    protected boolean groupActive_ = false;
    protected boolean inActiveGroup_ = false;
    public static Color DefaultBackgroundColor = new Color(245, 242, 255);
    public static Color DefaultBorderColor = new Color(124, 84, 0);
    public static Color DefaultTextColor = Color.BLACK;
    private Color BackgroundColor = DefaultBackgroundColor;
    private Color BorderColor = DefaultBorderColor;
    private Color TextColor = DefaultTextColor;
    private String guid;
    private String innerGuid;
    private String thirdConfig = "";
    private boolean isRoot_ = false;
    private boolean isLeaf_ = false;
    private boolean isSubFlow = false;
    private int subFlowID = 0;
    private String subFlowCallType = "call";
    private String colCopyRelation = "";
    private String tag = "";
    private String tag2 = "";
    private String comment = "";
    private String executor_ = "";
    private int needDays = 0;
    private boolean sendMsgNeeded = true;
    private boolean sendOutlineMail = false;
    private boolean autoReceive = true;
    private boolean autoReceive2 = true;
    private boolean silenceMode = true;
    private boolean canUntread = true;
    private boolean canFreeSubmit = true;
    private boolean clearautofill = true;
    private boolean canTakeOver = false;
    private boolean canMultiProcess = false;
    private boolean canMultiSession = false;
    private int multiProcessOne = 0;
    private boolean scriptRunOnServer = false;
    private boolean excludeScriptRunOnServer = false;
    private int autoReceiveAfterDays = 9999;
    private String permitCommitScript = "";
    private String PG = "";
    private boolean permitOver = false;
    private boolean mustFFPY = false;
    private String socket1 = "";
    private String socketTip1 = "";
    private int nodeNo = 0;
    public String code = "";
    public boolean disablebenchsubmit = false;
    private int ver = 2;
    public Object data;
    public static final int OVAL = 0;
    public static final int RECTANGLE = 1;
    public static final int ROUNDRECTANGLE = 2;
    public static final int BELOW = 0;
    public static final int IN = 1;
    public static final int CENTER = 2;
    public static final String[] shapeNames;
    private static char[] hexchars_;
    public static Node defaults;

    static {
        String[] stringArray = new String[4];
        stringArray[0] = "Oval";
        stringArray[1] = "Rectangle";
        stringArray[2] = "RoundRectangle";
        shapeNames = stringArray;
        hexchars_ = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        defaults = new Node(1);
    }

    public int searchNextChild(int n) {
        return this.adjacencies_.searchNext(n);
    }

    private Node(int unused) {
        this.x_ = -1000.0;
        this.y_ = -1000.0;
        this.z_ = -1000.0;
        this.temp_ = 0.0;
        this.width_ = 1.0;
        this.height_ = 1.0;
        this.depth_ = 0.0;
        this.shape_ = 0;
        this.label_ = new String[0];
        this.labelPosition_ = 1;
        this.imageLocation_ = new String("");
        this.imageType_ = new String("");
        this.image_ = null;
        this.isDummy_ = false;
        this.selected_ = false;
        this.multiSubmitPermit_ = false;
        this.canViewAllAnswer = true;
        this.haveId_ = false;
        this.isGroup_ = false;
        this.inActiveGroup_ = false;
        this.innerGuid = this.guid = DataStoreFactory.newGUID();
    }

    public Node() {
        this.index_ = -1;
        this.copyAttributes(defaults);
        this.adjacencies_ = new Set();
        this.innerGuid = this.guid = DataStoreFactory.newGUID();
    }

    public Node(boolean dummy) {
        this.index_ = -1;
        this.copyAttributes(defaults);
        this.adjacencies_ = new Set();
        this.isDummy_ = dummy;
        if (dummy) {
            this.height_ = 0.0;
            this.width_ = 0.0;
        }
        this.innerGuid = this.guid = DataStoreFactory.newGUID();
    }

    public Node(GMLobject gml) {
        String label_position;
        Double temp;
        String shape;
        Integer id;
        String label;
        Integer tmpint;
        boolean gotw = false;
        boolean goth = false;
        this.index_ = -1;
        this.copyAttributes(defaults);
        this.adjacencies_ = new Set();
        GMLobject graphics = gml.getGMLSubObject("graphics", 3, false);
        if (graphics != null) {
            String image_loc;
            Double tmp;
            tmpint = (Integer)gml.getValue("ver", 0);
            int v = tmpint != null ? tmpint : 0;
            GMLobject center = graphics.getGMLSubObject("center", 3, false);
            if (center != null) {
                tmp = (Double)center.getValue("x", 1);
                if (tmp != null) {
                    this.x_ = tmp;
                }
                if ((tmp = (Double)center.getValue("y", 1)) != null) {
                    this.y_ = tmp;
                }
                if ((tmp = (Double)center.getValue("z", 1)) != null) {
                    this.z_ = tmp;
                }
                if (v == 0) {
                    this.x_ += 1000.0;
                    this.y_ = 1000.0 - this.y_;
                }
            }
            if ((tmp = (Double)graphics.getValue("width", 1)) != null) {
                this.width_ = tmp;
                gotw = true;
            }
            if ((tmp = (Double)graphics.getValue("height", 1)) != null) {
                this.height_ = tmp;
                goth = true;
            }
            if ((tmp = (Double)graphics.getValue("depth", 1)) != null) {
                this.depth_ = tmp;
            }
            if ((image_loc = (String)graphics.getValue("Image.Location", 2)) != null) {
                this.imageLocation_ = image_loc;
                String image_type = (String)graphics.getValue("Image.Type", 2);
                this.imageType_ = image_type != null ? image_type : "URL";
            }
        }
        if ((label = (String)gml.getValue("label", 2)) != null) {
            this.setLabel(label);
        }
        if ((this.tag = (String)gml.getValue("tag", 2)) == null) {
            this.tag = "";
        }
        if ((this.tag2 = (String)gml.getValue("tag2", 2)) == null) {
            this.tag2 = "";
        }
        if ((this.code = (String)gml.getValue("code", 2)) == null) {
            this.code = "";
        }
        if ((this.permitCommitScript = (String)gml.getValue("permitcommitscript", 2)) == null) {
            this.permitCommitScript = "";
        }
        if ((this.comment = (String)gml.getValue("comment", 2)) == null) {
            this.comment = "";
        }
        if ((this.executor_ = (String)gml.getValue("executor", 2)) == null) {
            this.executor_ = "";
        }
        if ((this.PG = (String)gml.getValue("paigong", 2)) == null) {
            this.PG = "";
        }
        if ((this.socket1 = (String)gml.getValue("socket1", 2)) == null) {
            this.socket1 = "";
        }
        if ((this.socketTip1 = (String)gml.getValue("sockettip1", 2)) == null) {
            this.socketTip1 = "";
        }
        if ((this.guid = (String)gml.getValue("guid", 2)) == null) {
            this.guid = DataStoreFactory.newGUID();
        }
        if ((this.innerGuid = (String)gml.getValue("innerguid", 2)) == null) {
            this.innerGuid = this.guid;
        }
        if ((this.thirdConfig = (String)gml.getValue("thirdconfig", 2)) == null) {
            this.thirdConfig = "";
        }
        if ((id = (Integer)gml.getValue("id", 0)) != null) {
            this.haveId_ = true;
            this.id_ = id;
        }
        if ((shape = (String)gml.getValue("vgj.shape", 2)) != null) {
            int i = 0;
            while (shapeNames[i] != null) {
                if (shape.equalsIgnoreCase(shapeNames[i])) {
                    this.shape_ = i;
                }
                ++i;
            }
        }
        if ((tmpint = (Integer)gml.getValue("vgj.group", 0)) != null) {
            this.groupNodeId_ = tmpint;
            this.groupNode_ = this;
        }
        if ((temp = (Double)gml.getValue("vgj.Temperature", 1)) != null) {
            this.temp_ = temp;
        }
        if ((label_position = (String)gml.getValue("vgj.labelPosition", 2)) != null) {
            if (label_position.length() > 0) {
                if (label_position.charAt(0) == 'i' || label_position.charAt(0) == 'I') {
                    this.labelPosition_ = 1;
                } else if (label_position.charAt(0) == 'c' || label_position.charAt(0) == 'C') {
                    this.labelPosition_ = 2;
                }
            } else {
                this.labelPosition_ = 0;
            }
        }
        this.setImage(null, !gotw, !goth);
        try {
            this.BackgroundColor = Color.decode(gml.getValue("backgroundcolor", 2).toString());
        }
        catch (Exception e) {
            this.BackgroundColor = DefaultBackgroundColor;
        }
        try {
            this.BorderColor = Color.decode(gml.getValue("bordercolor", 2).toString());
        }
        catch (Exception e) {
            this.BorderColor = DefaultBorderColor;
        }
        try {
            this.TextColor = Color.decode(gml.getValue("textcolor", 2).toString());
        }
        catch (Exception e) {
            this.TextColor = DefaultTextColor;
        }
        Integer ti = (Integer)gml.getValue("isroot", 0);
        this.isRoot_ = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("isleaf", 0);
        this.isLeaf_ = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("issubflow", 0);
        this.isSubFlow = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("subflowid", 0);
        this.subFlowID = ti != null ? ti : 0;
        ti = (Integer)gml.getValue("needdays", 0);
        this.needDays = ti != null ? ti : 1;
        ti = (Integer)gml.getValue("sendmsgneeded", 0);
        this.sendMsgNeeded = ti != null ? ti == 1 : true;
        ti = (Integer)gml.getValue("sendOutlineMail", 0);
        this.sendOutlineMail = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("takeover", 0);
        this.canTakeOver = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("multiprocess", 0);
        this.canMultiProcess = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("multisession", 0);
        this.canMultiSession = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("multiprocessone", 0);
        this.multiProcessOne = ti != null ? ti : 0;
        ti = (Integer)gml.getValue("nodeno", 0);
        this.nodeNo = ti != null ? ti : 0;
        ti = (Integer)gml.getValue("autoreceive", 0);
        this.autoReceive = ti != null ? ti == 1 : true;
        ti = (Integer)gml.getValue("canUntread", 0);
        this.canUntread = ti != null ? ti == 1 : true;
        ti = (Integer)gml.getValue("canFreeSubmit", 0);
        this.canFreeSubmit = ti != null ? ti == 1 : true;
        ti = (Integer)gml.getValue("autoreceive2", 0);
        this.autoReceive2 = ti != null ? ti == 1 : true;
        ti = (Integer)gml.getValue("silenceMode", 0);
        this.silenceMode = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("clearautofill", 0);
        this.clearautofill = ti != null ? ti == 1 : true;
        ti = (Integer)gml.getValue("permitover", 0);
        this.permitOver = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("mustffpy", 0);
        this.mustFFPY = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("disablebenchsubmit", 0);
        this.disablebenchsubmit = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("scriptrunonserver", 0);
        this.scriptRunOnServer = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("excludescriptrunonserver", 0);
        this.excludeScriptRunOnServer = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("autoReceiveAfterDays", 0);
        this.autoReceiveAfterDays = ti != null ? Math.abs(ti) : 9999;
        this.colCopyRelation = (String)gml.getValue("colCopyRelation", 2);
        if (this.colCopyRelation == null) {
            this.colCopyRelation = "";
        }
        if ((this.subFlowCallType = (String)gml.getValue("subFlowCallType", 2)) == null) {
            this.subFlowCallType = "call";
        }
        this.selected_ = false;
        ti = (Integer)gml.getValue("multisubmitpermit", 0);
        this.multiSubmitPermit_ = ti != null ? ti == 1 : false;
        ti = (Integer)gml.getValue("canViewAllAnswer", 0);
        this.canViewAllAnswer = ti != null ? ti == 1 : true;
    }

    public void setGMLvalues(GMLobject gml) {
        gml.setValue("ver", 0, new Integer(this.ver));
        if (this.temp_ == 0.0) {
            gml.setValue("vgj.Temperature", 1, null);
        } else {
            gml.setValue("vgj.Temperature", 1, new Double(this.temp_));
        }
        gml.setValue("vgj.shape", 2, shapeNames[this.shape_]);
        if (this.inGroup()) {
            gml.setValue("vgj.group", 0, new Integer(this.groupNode_.getId()));
        }
        if (this.labelPosition_ == 1) {
            gml.setValue("vgj.labelPosition", 2, "in");
        } else if (this.labelPosition_ == 2) {
            gml.setValue("vgj.labelPosition", 2, "center");
        } else {
            gml.setValue("vgj.labelPosition", 2, "below");
        }
        gml.setValue("graphics.depth", 1, new Double(this.depth_));
        gml.setValue("graphics.height", 1, new Double(this.height_));
        gml.setValue("graphics.width", 1, new Double(this.width_));
        gml.setValue("graphics.center.z", 1, new Double(this.z_));
        gml.setValue("graphics.center.y", 1, new Double(this.y_));
        gml.setValue("graphics.center.x", 1, new Double(this.x_));
        gml.setValue("graphics.Image.Location", 2, this.imageLocation_);
        gml.setValue("graphics.Image.Type", 2, this.imageType_);
        gml.setValue("label", 2, this.getLabel());
        gml.setValue("guid", 2, this.guid);
        gml.setValue("innerguid", 2, this.innerGuid);
        gml.setValue("thirdconfig", 2, this.thirdConfig);
        gml.setValue("tag", 2, this.tag);
        gml.setValue("tag2", 2, this.tag2);
        gml.setValue("code", 2, this.code);
        gml.setValue("comment", 2, this.comment);
        gml.setValue("executor", 2, this.executor_);
        gml.setValue("paigong", 2, this.PG);
        gml.setValue("socket1", 2, this.socket1);
        gml.setValue("sockettip1", 2, this.socketTip1);
        gml.setValue("id", 0, new Integer(this.id_));
        gml.setValue("backgroundcolor", 2, GMLlexer.Color2Hex(this.BackgroundColor));
        gml.setValue("bordercolor", 2, GMLlexer.Color2Hex(this.BorderColor));
        gml.setValue("textcolor", 2, GMLlexer.Color2Hex(this.TextColor));
        gml.setValue("isroot", 0, new Integer(this.isRoot_ ? 1 : 0));
        gml.setValue("isleaf", 0, new Integer(this.isLeaf_ ? 1 : 0));
        gml.setValue("issubflow", 0, new Integer(this.isSubFlow ? 1 : 0));
        gml.setValue("subflowid", 0, new Integer(this.subFlowID));
        gml.setValue("needdays", 0, new Integer(this.needDays));
        gml.setValue("sendmsgneeded", 0, new Integer(this.sendMsgNeeded ? 1 : 0));
        gml.setValue("sendOutlineMail", 0, new Integer(this.sendOutlineMail ? 1 : 0));
        gml.setValue("takeover", 0, new Integer(this.canTakeOver ? 1 : 0));
        gml.setValue("multiprocess", 0, new Integer(this.canMultiProcess ? 1 : 0));
        gml.setValue("multisession", 0, new Integer(this.canMultiSession ? 1 : 0));
        gml.setValue("multiprocessone", 0, new Integer(this.multiProcessOne));
        gml.setValue("nodeno", 0, new Integer(this.nodeNo));
        gml.setValue("autoreceive", 0, new Integer(this.autoReceive ? 1 : 0));
        gml.setValue("autoreceive2", 0, new Integer(this.autoReceive2 ? 1 : 0));
        gml.setValue("silenceMode", 0, new Integer(this.silenceMode ? 1 : 0));
        gml.setValue("multisubmitpermit", 0, new Integer(this.multiSubmitPermit_ ? 1 : 0));
        gml.setValue("canViewAllAnswer", 0, new Integer(this.canViewAllAnswer ? 1 : 0));
        gml.setValue("clearautofill", 0, new Integer(this.clearautofill ? 1 : 0));
        gml.setValue("canUntread", 0, new Integer(this.canUntread ? 1 : 0));
        gml.setValue("canFreeSubmit", 0, new Integer(this.canFreeSubmit ? 1 : 0));
        gml.setValue("permitover", 0, new Integer(this.permitOver ? 1 : 0));
        gml.setValue("mustffpy", 0, new Integer(this.mustFFPY ? 1 : 0));
        gml.setValue("disablebenchsubmit", 0, new Integer(this.disablebenchsubmit ? 1 : 0));
        gml.setValue("scriptrunonserver", 0, new Integer(this.scriptRunOnServer ? 1 : 0));
        gml.setValue("excludescriptrunonserver", 0, new Integer(this.excludeScriptRunOnServer ? 1 : 0));
        gml.setValue("permitcommitscript", 2, this.permitCommitScript);
        gml.setValue("autoReceiveAfterDays", 0, new Integer(this.autoReceiveAfterDays));
        gml.setValue("colCopyRelation", 2, this.colCopyRelation);
        gml.setValue("subFlowCallType", 2, this.subFlowCallType);
    }

    public void setId(int id) {
        this.haveId_ = true;
        this.id_ = id;
    }

    public Integer getIdObject() {
        if (!this.haveId_) {
            return null;
        }
        return new Integer(this.id_);
    }

    public int getId() {
        return this.id_;
    }

    public void setPosition(double new_x, double new_y) {
        this.x_ = new_x;
        this.y_ = new_y;
    }

    public void setPosition(DPoint new_position) {
        this.x_ = new_position.x;
        this.y_ = new_position.y;
    }

    public void setPosition(double new_x, double new_y, double new_z) {
        this.x_ = new_x;
        this.y_ = new_y;
        this.z_ = new_z;
    }

    public void setPosition(DPoint3 new_position) {
        this.x_ = new_position.x;
        this.y_ = new_position.y;
        this.z_ = new_position.z;
    }

    public DPoint getPosition() {
        DPoint position = new DPoint(this.x_, this.y_);
        return position;
    }

    public DPoint3 getPosition3() {
        if (this.inActiveGroup_) {
            return this.groupNode_.getPosition3();
        }
        DPoint3 position = new DPoint3(this.x_, this.y_, this.z_);
        return position;
    }

    public void setBoundingBox(double new_width, double new_height) {
        this.width_ = new_width;
        this.height_ = new_height;
    }

    public void setBoundingBox(DDimension new_bbox) {
        this.width_ = new_bbox.width;
        this.height_ = new_bbox.height;
    }

    public DDimension getBoundingBox() {
        DDimension bbox = new DDimension(this.width_, this.height_);
        return bbox;
    }

    public void setBoundingBox(double new_width, double new_height, double new_depth) {
        this.width_ = new_width;
        this.height_ = new_height;
        this.depth_ = new_depth;
    }

    public void setBoundingBox(DDimension3 new_bbox) {
        this.width_ = new_bbox.width;
        this.height_ = new_bbox.height;
        this.depth_ = new_bbox.depth;
    }

    public DDimension3 getBoundingBox3() {
        DDimension3 bbox = new DDimension3(this.width_, this.height_, this.depth_);
        return bbox;
    }

    public void setShape(int shape) {
        this.shape_ = shape;
    }

    public int getShape() {
        return this.shape_;
    }

    public void setTemp(double temp) {
        this.temp_ = temp;
    }

    public double getTemp() {
        return this.temp_;
    }

    public void setLabel(String label) {
        String t;
        if (label == null) {
            label = "";
        }
        int n = 0;
        StringTokenizer stk = new StringTokenizer(label, "\\n");
        while (stk.hasMoreTokens()) {
            t = stk.nextToken();
            if (t.equals("")) continue;
            ++n;
        }
        this.label_ = new String[n];
        if (n == 0) {
            return;
        }
        n = 0;
        stk = new StringTokenizer(label, "\\n");
        while (stk.hasMoreTokens()) {
            t = stk.nextToken();
            if (t.equals("")) continue;
            this.label_[n] = t;
            ++n;
        }
    }

    public String getLabel() {
        if (this.label_.length > 0) {
            int len = 0;
            int i = 0;
            while (i < this.label_.length) {
                len += this.label_[i].length() + 2;
                ++i;
            }
            StringBuffer result = new StringBuffer(len);
            i = 0;
            while (i < this.label_.length) {
                result.append(this.label_[i]);
                if (i < this.label_.length - 1) {
                    result.append("\\n");
                }
                ++i;
            }
            return new String(result);
        }
        return new String("\u6b65\u9aa4" + String.valueOf(this.id_));
    }

    public static void setDefaultLabel(boolean use_default) {
        defaultLabel_ = use_default;
    }

    public static boolean getDefaultLabel() {
        return defaultLabel_;
    }

    public void setSelected(boolean selected) {
        this.selected_ = selected;
    }

    public boolean getSelected() {
        return this.selected_;
    }

    public void setMultiSubmitPermit(boolean m) {
        this.multiSubmitPermit_ = m;
    }

    public boolean isMultiSubmitPermit() {
        return this.multiSubmitPermit_;
    }

    public int getNeedDays() {
        return this.needDays;
    }

    public void setNeedDays(int n) {
        this.needDays = n;
    }

    public void setChild(int child) {
        this.adjacencies_.includeElement(child);
    }

    public void clearChild(int child) {
        this.adjacencies_.removeElement(child);
    }

    public Set getChildren() {
        return (Set)this.adjacencies_.clone();
    }

    public int firstChild() {
        return this.adjacencies_.first();
    }

    public int nextChild() {
        return this.adjacencies_.next();
    }

    public int getIndex() {
        return this.index_;
    }

    public boolean hasChild(int child) {
        return this.adjacencies_.isElement(child);
    }

    public boolean hasChild(Node child) {
        return this.adjacencies_.isElement(child.index_);
    }

    public int numberOfChildren() {
        return this.adjacencies_.numberOfElements();
    }

    public void copyAttributes(Node node_to_copy) {
        this.x_ = node_to_copy.x_;
        this.y_ = node_to_copy.y_;
        this.z_ = node_to_copy.z_;
        this.width_ = node_to_copy.width_;
        this.height_ = node_to_copy.height_;
        this.depth_ = node_to_copy.depth_;
        this.shape_ = node_to_copy.shape_;
        this.temp_ = node_to_copy.temp_;
        this.isDummy_ = node_to_copy.isDummy_;
        int rows = node_to_copy.label_.length;
        this.label_ = new String[rows];
        int i = 0;
        while (i < rows) {
            this.label_[i] = new String(node_to_copy.label_[i]);
            ++i;
        }
        this.labelPosition_ = node_to_copy.labelPosition_;
        this.selected_ = node_to_copy.selected_;
        this.multiSubmitPermit_ = node_to_copy.multiSubmitPermit_;
        this.canViewAllAnswer = node_to_copy.canViewAllAnswer;
        this.imageType_ = new String(node_to_copy.imageType_);
        this.imageLocation_ = new String(node_to_copy.imageLocation_);
        this.setImage(null, false, false);
    }

    public Object clone() throws CloneNotSupportedException {
        Node copy = (Node)super.clone();
        copy.adjacencies_ = (Set)this.adjacencies_.clone();
        return copy;
    }

    public void draw(Component comp, Graphics graphics, int quality, boolean drawNodeNo) {
        AlphaComposite ac;
        if (this.isGroup_ && !this.groupActive_ || this.inActiveGroup_) {
            return;
        }
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.imageChange_ = false;
        boolean errflag = false;
        Image image = this.image_;
        if (quality == 0) {
            image = null;
        }
        this.scaleBounds_(graphics);
        double w = this.width_;
        double h = this.height_;
        if (w < 1.0) {
            w = 1.0;
        }
        if (h < 1.0) {
            h = 1.0;
        }
        DPoint3 position = new DPoint3(this.x_, this.y_, this.z_);
        int x = (int)position.x;
        int y = (int)position.y;
        graphics.setColor(Color.black);
        if (image != null) {
            MediaTracker mt = new MediaTracker(comp);
            mt.addImage(this.image_, 0, (int)w, (int)h);
            boolean stat = false;
            try {
                stat = mt.waitForID(0, 1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stat && !mt.isErrorID(0)) {
                if (this.imageChange_) {
                    w = this.width_;
                    h = this.height_;
                    if (w < 1.0) {
                        w = 1.0;
                    }
                    if (h < 1.0) {
                        h = 1.0;
                    }
                    mt.addImage(this.image_, 1, (int)w, (int)h);
                    try {
                        stat = mt.waitForID(1, 1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (stat) {
                    graphics.drawImage(this.image_, (int)((double)x - w / 2.0), (int)((double)y - h / 2.0), (int)w, (int)h, null);
                } else {
                    errflag = true;
                }
            } else {
                errflag = true;
            }
            if (errflag) {
                String type = "URL";
                if (this.imageType_.equalsIgnoreCase("file")) {
                    type = "file";
                }
                String error = mt.isErrorID(0) ? "Error loading or scaling " + type + " \"" + this.imageLocation_ + "\"." : "Timeout loading image - try a refresh.";
                FontMetrics fm = graphics.getFontMetrics();
                double lx = (double)x - (double)fm.stringWidth(error) / 2.0;
                graphics.drawString(error, (int)lx, (int)((double)y + h / 2.0));
            }
        } else if (this.shape_ == 0) {
            int i = 0;
            while (i < 4) {
                graphics.setColor(new Color(245 - i * 25, 245 - i * 25, 245 - i * 25));
                graphics.fillOval((int)((double)x - w / 2.0) + 4 - i, (int)((double)y - h / 2.0) + 4 - i, (int)w, (int)h);
                ++i;
            }
            graphics.setColor(this.BackgroundColor);
            graphics.fillOval((int)((double)x - w / 2.0), (int)((double)y - h / 2.0), (int)w, (int)h);
            graphics.setColor(this.BorderColor);
            if (this.isCanMultiProcess()) {
                Stroke oldStroke = ((Graphics2D)graphics).getStroke();
                ((Graphics2D)graphics).setStroke(new BasicStroke(3.0f, 2, 2));
                graphics.drawOval((int)((double)x - w / 2.0), (int)((double)y - h / 2.0), (int)w, (int)h);
                ((Graphics2D)graphics).setStroke(oldStroke);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Tools.DrawString((Graphics2D)graphics, new Rectangle((int)(position.x + w / 2.0), (int)(position.y - h / 2.0), (int)w, (int)h), this.multiProcessOne == 1 ? "[\u5de5\u4f5c\u6c60]" : "[\u4f1a\u7b7e]", 0, null, Color.red, "\u65b0\u5b8b\u4f53", 9, false, false, false, 0, 0);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else if (this.isCanMultiSession()) {
                Stroke oldStroke = ((Graphics2D)graphics).getStroke();
                ((Graphics2D)graphics).setStroke(new BasicStroke(3.0f, 1, 1, 8.0f, new float[]{8.0f}, 0.0f));
                graphics.drawOval((int)((double)x - w / 2.0), (int)((double)y - h / 2.0), (int)w, (int)h);
                ((Graphics2D)graphics).setStroke(oldStroke);
            } else {
                graphics.drawOval((int)((double)x - w / 2.0), (int)((double)y - h / 2.0), (int)w, (int)h);
            }
            if ((this.isSubFlow || this.isGroup_) && w > 6.0 && h > 6.0) {
                graphics.drawOval((int)((double)x - w / 2.0 + 3.0), (int)((double)y - h / 2.0 + 3.0), (int)w - 6, (int)h - 6);
            }
        } else if (this.shape_ == 1) {
            int i = 0;
            while (i < 4) {
                graphics.setColor(new Color(245 - i * 25, 245 - i * 25, 245 - i * 25));
                graphics.fillRect((int)((double)x - w / 2.0) + 4 - i, (int)((double)y - h / 2.0) + 4 - i, (int)w, (int)h);
                ++i;
            }
            graphics.setColor(this.BackgroundColor);
            graphics.fillRect((int)((double)x - w / 2.0), (int)((double)y - h / 2.0), (int)w, (int)h);
            graphics.setColor(this.BorderColor);
            graphics.drawRect((int)((double)x - w / 2.0), (int)((double)y - h / 2.0), (int)w, (int)h);
            if (this.isGroup_ && w > 6.0 && h > 6.0) {
                graphics.drawRect((int)((double)x - w / 2.0 + 3.0), (int)((double)y - h / 2.0 + 3.0), (int)w - 6, (int)h - 6);
            }
        } else if (this.shape_ == 2) {
            int i = 0;
            while (i < 4) {
                graphics.setColor(new Color(245 - i * 25, 245 - i * 25, 245 - i * 25));
                graphics.fillRoundRect((int)((double)x - w / 2.0) + 4 - i, (int)((double)y - h / 2.0) + 4 - i, (int)w, (int)h, 15, 15);
                ++i;
            }
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(this.BackgroundColor);
            graphics.fillRoundRect((int)((double)x - w / 2.0), (int)((double)y - h / 2.0), (int)w, (int)h, 9, 9);
            graphics.setColor(this.BorderColor);
            graphics.drawRoundRect((int)((double)x - w / 2.0), (int)((double)y - h / 2.0), (int)w, (int)h, 9, 9);
            if (this.isGroup_ && w > 6.0 && h > 6.0) {
                graphics.drawRect((int)((double)x - w / 2.0 + 3.0), (int)((double)y - h / 2.0 + 3.0), (int)w - 6, (int)h - 6);
            }
        }
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        String s = this.getExecutor();
        ZDataParser zdp = new ZDataParser(Escape.unescape(s));
        this.TextColor = !zdp.get("@@@\u4e8c\u6b21\u5f00\u53d1", "no").equals("no") ? Color.BLUE : DefaultTextColor;
        if ((defaultLabel_ || this.label_.length > 0) && quality > 0) {
            double ly;
            FontMetrics fm = graphics.getFontMetrics();
            graphics.setColor(this.TextColor);
            double widest = 0.0;
            if (this.label_.length > 0) {
                int i = 0;
                while (i < this.label_.length) {
                    if ((double)fm.stringWidth(this.label_[i]) > widest) {
                        widest = fm.stringWidth(this.label_[i]);
                    }
                    ++i;
                }
            } else {
                widest = fm.stringWidth(new String("\u6b65\u9aa4" + this.id_));
            }
            double lx = (double)x - widest / 2.0;
            if (this.labelPosition_ != 0) {
                ly = this.label_.length > 0 ? (double)y - (double)(fm.getHeight() * (this.label_.length - 2)) / 2.0 : (double)y + (double)fm.getHeight() / 2.0;
                ly -= (double)fm.getDescent();
            } else {
                ly = (double)y + h / 2.0 + (double)fm.getAscent() + 1.0;
            }
            if (this.label_.length == 0) {
                graphics.drawString(new String("\u6b65\u9aa4" + this.id_), (int)lx, (int)ly);
            } else {
                int i = 0;
                while (i < this.label_.length) {
                    graphics.drawString(this.label_[i], (int)lx, (int)ly);
                    ly += (double)fm.getHeight();
                    ++i;
                }
            }
        }
        if (this.isCanMultiSession()) {
            Image img = Tool.GetImageFromURL("Edu/auburn/VGJ/graph/morepeople.gif");
            graphics.drawImage(img, x, y, null);
        }
        if (!this.isRoot_ && drawNodeNo) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ac = AlphaComposite.getInstance(3, 0.75f);
            ((Graphics2D)graphics).setComposite(ac);
            Tools.DrawString((Graphics2D)graphics, new Rectangle((int)(position.x - w / 2.0), (int)(position.y - h / 2.0), (int)w, (int)h), String.valueOf(this.nodeNo), 0, null, this.isLeaf() ? Color.green : Color.red, "arial", 40, true, false, false, 2, 2);
            ac = AlphaComposite.getInstance(3, 1.0f);
            ((Graphics2D)graphics).setComposite(ac);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (!this.getCode().equals("")) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ac = AlphaComposite.getInstance(3, 0.5f);
            ((Graphics2D)graphics).setComposite(ac);
            Tools.DrawString((Graphics2D)graphics, new Rectangle((int)(position.x - w / 2.0), (int)(position.y - h / 2.0), (int)w, (int)h), this.getCode(), 0, null, Color.green, "arial", 20, true, false, false, 2, 2);
            ac = AlphaComposite.getInstance(3, 1.0f);
            ((Graphics2D)graphics).setComposite(ac);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.getTag().length() > 30) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Tools.DrawString((Graphics2D)graphics, new Rectangle((int)(position.x - w / 2.0), (int)(position.y - h - 5.0), (int)w, (int)h), "[\u6709\u9001\u8fbe\u6761\u4ef6]", 0, null, Color.red, "\u65b0\u5b8b\u4f53", 9, false, false, false, 2, 2);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.getPermitCommitScript().length() > 0) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Tools.DrawString((Graphics2D)graphics, new Rectangle((int)(position.x - w / 2.0), (int)(position.y + 5.0), (int)w, (int)h), "[\u6709\u9012\u4ea4\u6761\u4ef6]", 0, null, Color.red, "\u65b0\u5b8b\u4f53", 9, false, false, false, 2, 2);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (!this.selected_) {
            return;
        }
        graphics.setColor(Color.red);
        DPoint tr = new DPoint(position.x + this.width_ / 2.0 + 1.0, position.y - this.height_ / 2.0 - 1.0);
        DPoint bl = new DPoint(position.x - this.width_ / 2.0 - 1.0, position.y + this.height_ / 2.0 + 1.0);
        graphics.drawRect((int)position.x - 4, (int)position.y - 1, 8, 2);
        graphics.drawRect((int)position.x - 1, (int)position.y - 4, 2, 8);
        graphics.drawRect((int)tr.x - 2, (int)tr.y - 2, 4, 4);
        graphics.drawRect((int)position.x - 3, (int)bl.y - 1, 6, 2);
        graphics.drawRect((int)bl.x - 1, (int)position.y - 3, 2, 6);
        graphics.setColor(Color.white);
        graphics.drawLine((int)position.x - 3, (int)position.y, (int)position.x + 3, (int)position.y);
        graphics.drawLine((int)position.x, (int)position.y - 3, (int)position.x, (int)position.y + 3);
        graphics.drawRect((int)tr.x - 1, (int)tr.y - 1, 2, 2);
        graphics.drawLine((int)position.x - 2, (int)bl.y, (int)position.x + 2, (int)bl.y);
        graphics.drawLine((int)bl.x, (int)position.y - 2, (int)bl.x, (int)position.y + 2);
    }

    public DPoint3 intersectWithLineTo(DPoint3 to, boolean inplane, int quality) {
        if (this.inActiveGroup_) {
            return this.groupNode_.intersectWithLineTo(to, inplane, quality);
        }
        if (this.isDummy_) {
            return new DPoint3(this.x_, this.y_, this.z_);
        }
        if (this.width_ == 0.0 || this.height_ == 0.0) {
            return new DPoint3(this.x_, this.y_, this.z_);
        }
        if (!inplane || this.z_ != to.z) {
            double mindim = Math.min(this.width_, this.height_) / 2.0;
            double dist = Math.sqrt((to.x - this.x_) * (to.x - this.x_) + (to.y - this.y_) * (to.y - this.y_) + (to.z - this.z_) * (to.z - this.z_));
            if (dist <= mindim) {
                return new DPoint3(this.x_, this.y_, this.z_);
            }
            double ratio = mindim / dist;
            return new DPoint3(this.x_ + (to.x - this.x_) * ratio, this.y_ + (to.y - this.y_) * ratio, this.z_ + (to.z - this.z_) * ratio);
        }
        double dx = to.x - this.x_;
        double dy = to.y - this.y_;
        if (dx * dx / (this.width_ * this.width_) + dy * dy / (this.height_ * this.height_) <= 0.25) {
            return new DPoint3(this.x_, this.y_, this.z_);
        }
        if (this.image_ != null && quality > 1) {
            int ht = this.image_.getHeight(null);
            int wd = this.image_.getWidth(null);
            int[] pixels = Node.getImagePixels(this.image_, wd, ht);
            if (pixels != null) {
                int ypix;
                double yint;
                double xint;
                double t = 0.0;
                double wmul = to.x < this.x_ ? 1 : -1;
                double hmul = to.y < this.y_ ? 1 : -1;
                double pixelw = this.width_ / (double)wd;
                double pixelh = this.height_ / (double)ht;
                double xorg = this.x_ - this.width_ / 2.0;
                double yorg = this.y_ - this.height_ / 2.0;
                double tx = 0.0;
                double ty = 0.0;
                dx = -dx;
                dy = -dy;
                boolean first = true;
                tx = 0.0;
                int xpix = 0;
                while (xpix < wd) {
                    xint = xorg + ((double)(wmul < 0.0 ? wd : 0) + (double)xpix * wmul) * pixelw;
                    tx = (xint - to.x) / dx;
                    yint = to.y + dy * tx;
                    ypix = -((int)Math.floor((yint - yorg) / pixelh - (double)ht + 1.0));
                    if (ypix >= 0 && ypix < ht) {
                        int xind;
                        int n = xind = wmul < 0.0 ? wd - xpix - 1 : xpix;
                        if ((pixels[ypix * wd + xind] & 0xFF000000) != 0) break;
                    }
                    ++xpix;
                }
                ty = 0.0;
                ypix = 0;
                while (ypix < ht) {
                    yint = yorg + ((double)(hmul > 0.0 ? ht : 0) - (double)(ht - ypix) * hmul) * pixelh;
                    ty = (yint - to.y) / dy;
                    xint = to.x + dx * ty;
                    xpix = (int)Math.floor((xint - xorg) / pixelw);
                    if (xpix >= 0 && xpix < wd) {
                        int yind;
                        int n = yind = hmul > 0.0 ? ht - ypix - 1 : ypix;
                        if ((pixels[yind * wd + xpix] & 0xFF000000) != 0) break;
                    }
                    ++ypix;
                }
                t = -1.0;
                if (ty >= 0.0 && ty < 1.0 && (ty < tx || tx < 0.0)) {
                    t = ty;
                } else if (tx >= 0.0 && tx < 1.0) {
                    t = tx;
                }
                if (t >= 1.0 || t < 0.0) {
                    return new DPoint3(this.x_, this.y_, this.z_);
                }
                xint = to.x + dx * t;
                yint = to.y + dy * t;
                return new DPoint3(xint, yint, this.z_);
            }
            return new DPoint3(this.x_, this.y_, this.z_);
        }
        if (dx == 0.0) {
            if (dy > 0.0) {
                return new DPoint3(this.x_, this.y_ + this.height_ / 2.0, this.z_);
            }
            return new DPoint3(this.x_, this.y_ - this.height_ / 2.0, this.z_);
        }
        double slope = dy / dx;
        if (this.shape_ == 0) {
            double x = this.width_ * this.height_ / (2.0 * Math.sqrt(this.height_ * this.height_ + slope * slope * this.width_ * this.width_));
            if (to.x < this.x_) {
                x = -x;
            }
            double y = slope * x;
            return new DPoint3(this.x_ + x, this.y_ + y, this.z_);
        }
        if (this.shape_ == 1 || this.shape_ == 2) {
            double x = dx > 0.0 ? this.x_ + this.width_ / 2.0 : this.x_ - this.width_ / 2.0;
            double y = to.y - (to.x - x) * slope;
            if (Math.abs(y - this.y_) <= this.height_ / 2.0) {
                return new DPoint3(x, y, this.z_);
            }
            y = dy > 0.0 ? this.y_ + this.height_ / 2.0 : this.y_ - this.height_ / 2.0;
            x = to.x - (to.y - y) / slope;
            return new DPoint3(x, y, this.z_);
        }
        return new DPoint3(this.x_, this.y_, this.z_);
    }

    public void getDrawBounds_(DPoint width, DPoint height) {
        double w = this.width_;
        double h = this.height_;
        if (w < 1.0) {
            w = 1.0;
        }
        if (h < 1.0) {
            h = 1.0;
        }
        DPoint3 position = new DPoint3(this.x_, this.y_, this.z_);
        width.x = position.x - w / 2.0;
        width.y = position.x + w / 2.0;
        height.x = position.y - h / 2.0;
        height.y = position.y + h / 2.0;
    }

    public void saveState() {
        this.oldpos_ = new DPoint3(this.x_, this.y_, this.z_);
        this.oldbox_ = new DDimension3(this.width_, this.height_, this.depth_);
    }

    public void slide(int xoffs, int yoffs) {
        if (this.oldpos_ == null) {
            return;
        }
        DPoint3 tmppos = new DPoint3(this.oldpos_);
        tmppos.x += (double)xoffs;
        tmppos.y += (double)yoffs;
        this.x_ = tmppos.x;
        this.y_ = tmppos.y;
        this.z_ = tmppos.z;
    }

    public void overturn() {
        this.saveState();
        DPoint3 tmppos = new DPoint3(this.oldpos_);
        tmppos.x = 2000.0 - tmppos.x;
        tmppos.y = 2000.0 - tmppos.y;
        this.x_ = tmppos.x;
        this.y_ = tmppos.y;
        this.z_ = tmppos.z;
    }

    public void scale(double scalex, double scaley, double scalez) {
        if (this.oldbox_ == null) {
            return;
        }
        this.width_ = scalex * this.oldbox_.width;
        this.height_ = scaley * this.oldbox_.height;
        this.depth_ = scalez * this.oldbox_.depth;
    }

    public static void setToolkit(Toolkit toolkit) {
        toolkit_ = toolkit;
    }

    public static void setContext(URL context) {
        context_ = context;
    }

    public boolean imageUpdate(Image image, int info, int x, int y, int w, int h) {
        if ((info & 2) != 0) {
            this.height_ = h;
            this.imageChange_ = true;
        }
        if ((info & 1) != 0) {
            this.width_ = w;
            this.imageChange_ = true;
        }
        return true;
    }

    public void setLabelPosition(String label_position) {
        if (label_position == null) {
            label_position = "IN";
        }
        if (label_position.length() <= 0) {
            return;
        }
        this.labelPosition_ = label_position.charAt(0) == 'I' ? 1 : (label_position.charAt(0) == 'C' ? 2 : 0);
    }

    public int getLabelPosition() {
        return this.labelPosition_;
    }

    public void setImageType(String image_type) {
        this.imageType_ = image_type;
    }

    public String getImageType() {
        return this.imageType_;
    }

    public void setImageSource(String image_source) {
        this.imageLocation_ = image_source;
    }

    public String getImageSource() {
        return this.imageLocation_;
    }

    public void setImage(Component comp, boolean set_w, boolean set_h) {
        this.image_ = null;
        if (this.imageLocation_.length() <= 0) {
            return;
        }
        if (toolkit_ == null) {
            toolkit_ = Toolkit.getDefaultToolkit();
        }
        if (toolkit_ != null) {
            if (this.imageType_.equalsIgnoreCase("file")) {
                this.image_ = toolkit_.getImage(this.imageLocation_);
            } else {
                URL src = null;
                try {
                    src = new URL(context_, this.imageLocation_);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (src != null) {
                    this.image_ = toolkit_.getImage(src);
                }
            }
            if (comp != null) {
                MediaTracker mt = new MediaTracker(comp);
                mt.addImage(this.image_, 0);
                boolean stat = false;
                try {
                    stat = mt.waitForID(0, 2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (set_h) {
                this.height_ = -1.0;
                int ht = this.image_.getHeight(this);
                if (ht != -1) {
                    this.height_ = ht;
                }
            }
            if (set_w) {
                this.width_ = -1.0;
                int wd = this.image_.getWidth(this);
                if (wd != -1) {
                    this.width_ = wd;
                }
            }
        }
        if (this.image_ == null) {
            this.imageType_ = new String("");
        }
    }

    public static int[] getImagePixels(Image image, int wd, int ht) {
        boolean stat;
        if (image == null) {
            return null;
        }
        int[] pixels = new int[ht * wd];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, wd, ht, pixels, 0, wd);
        try {
            stat = grabber.grabPixels(2000L);
        }
        catch (InterruptedException e) {
            stat = false;
        }
        if (!stat) {
            return null;
        }
        return pixels;
    }

    public Image getImage() {
        return this.image_;
    }

    public static String imagePS(Image image) {
        StringBuffer result = new StringBuffer(30);
        result.append("   < ");
        int ht = image.getHeight(null);
        int wd = image.getWidth(null);
        int[] pixels = Node.getImagePixels(image, wd, ht);
        if (pixels != null) {
            result.ensureCapacity(ht * wd * 4 + 30);
            int count = 0;
            boolean chr = false;
            int row = 0;
            while (row < ht) {
                int col = 0;
                while (col < wd) {
                    int pixel;
                    if (count % 20 == 0 && count != 0) {
                        result.append("\n     ");
                    }
                    pixel = ((pixel = pixels[count++]) & 0xFF000000) == 0 ? 255 : (int)(0.299 * (double)(pixel >> 16 & 0xFF) + 0.587 * (double)(pixel >> 8 & 0xFF) + 0.114 * (double)(pixel & 0xFF));
                    int cbyte = pixel >> 4 & 0xF;
                    result.append(hexchars_[cbyte]);
                    cbyte = pixel & 0xF;
                    result.append(hexchars_[cbyte]).append(' ');
                    ++col;
                }
                ++row;
            }
        } else {
            result.append("ff");
        }
        result.append(">\n");
        result.append("   ").append(wd).append(" ").append(ht).append("\n");
        return result.toString();
    }

    public boolean inGroup() {
        return this.groupNode_ != null;
    }

    public boolean isGroup() {
        return this.isGroup_;
    }

    public boolean groupActive() {
        return this.groupActive_;
    }

    public boolean isVisible() {
        if (this.inActiveGroup_) {
            return false;
        }
        return !this.isGroup_ || this.groupActive_;
    }

    public Node getVisibleGroupRoot() {
        Node node = this;
        while (node.inActiveGroup_) {
            node = node.groupNode_;
        }
        return node;
    }

    public void setGroup() {
        this.isGroup_ = true;
    }

    private void scaleBounds_(Graphics graphics) {
        if (this.labelPosition_ == 1) {
            double w;
            double h;
            FontMetrics fm = graphics.getFontMetrics();
            if (this.label_.length > 0) {
                h = fm.getHeight() * this.label_.length;
                w = 0.0;
                int i = 0;
                while (i < this.label_.length) {
                    if (this.label_[i].length() != 0 && (double)fm.stringWidth(this.label_[i]) > w) {
                        w = fm.stringWidth(this.label_[i]);
                    }
                    ++i;
                }
            } else {
                h = fm.getHeight();
                w = fm.stringWidth(new String("Node " + this.id_));
            }
            if (this.shape_ == 0) {
                w *= 1.42;
                h *= 1.42;
            }
            this.width_ = w += 6.0;
            this.height_ = h += 6.0;
        }
    }

    public Color getBackgroundColor() {
        return this.BackgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.BackgroundColor = backgroundColor;
    }

    public Color getBorderColor() {
        return this.BorderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.BorderColor = borderColor;
    }

    public Color getTextColor() {
        return this.TextColor;
    }

    public void setTextColor(Color textColor) {
        this.TextColor = textColor;
    }

    public boolean isRoot() {
        return this.isRoot_;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot_ = isRoot;
    }

    public boolean isLeaf() {
        return this.isLeaf_;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf_ = isLeaf;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String s) {
        this.guid = s;
    }

    public String getInnerGuid() {
        return this.innerGuid;
    }

    public void setInnerGuid(String s) {
        this.innerGuid = s;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag_) {
        this.tag = tag_;
        if (this.tag == null) {
            this.tag = "";
        }
    }

    public String getTag2() {
        return this.tag2;
    }

    public void setTag2(String tag2_) {
        this.tag2 = tag2_;
        if (this.tag2 == null) {
            this.tag2 = "";
        }
    }

    public String getComment() {
        return Escape.unescape(this.comment);
    }

    public void setComment(String s) {
        if (s == null) {
            s = "";
        }
        this.comment = Escape.escape(s);
        if (this.comment == null) {
            this.comment = "";
        }
    }

    public String getExecutor() {
        return this.executor_;
    }

    public void setExecutor(String executor) {
        if (executor == null) {
            executor = "";
        }
        this.executor_ = executor;
    }

    public boolean isSendMsgNeeded() {
        return this.sendMsgNeeded;
    }

    public void setSendMsgNeeded(boolean sendMsgNeeded_) {
        this.sendMsgNeeded = sendMsgNeeded_;
    }

    public boolean isSendOutlineMail() {
        return this.sendOutlineMail;
    }

    public void setSendOutlineMail(boolean isSendOutlineMail_) {
        this.sendOutlineMail = isSendOutlineMail_;
    }

    public boolean isAutoReceive() {
        return this.autoReceive;
    }

    public void setAutoReceive(boolean b) {
        this.autoReceive = b;
    }

    public boolean isAutoReceive2() {
        return this.autoReceive2;
    }

    public void setAutoReceive2(boolean b) {
        this.autoReceive2 = b;
    }

    public boolean isSilenceMode() {
        return this.silenceMode;
    }

    public void setSilenceMode(boolean b) {
        this.silenceMode = b;
    }

    public boolean isClearAutoFill() {
        return this.clearautofill;
    }

    public void setClearAutoFill(boolean b) {
        this.clearautofill = b;
    }

    public String getPermitCommitScript() {
        return this.permitCommitScript;
    }

    public void setPermitCommitScript(String permitCommitScript_) {
        if (permitCommitScript_ == null) {
            permitCommitScript_ = "";
        }
        this.permitCommitScript = permitCommitScript_;
    }

    public String getPG() {
        return this.PG;
    }

    public void setPG(String pg) {
        if (pg == null) {
            pg = "";
        }
        this.PG = pg;
    }

    public boolean isSubFlow() {
        return this.isSubFlow;
    }

    public void setSubFlow(boolean b) {
        this.isSubFlow = b;
    }

    public int getSubFlowID() {
        return this.subFlowID;
    }

    public void setSubFlowID(int sfid) {
        this.subFlowID = sfid;
    }

    public int getAutoReceiveAfterDays() {
        return this.autoReceiveAfterDays;
    }

    public void setAutoReceiveAfterDays(int n) {
        this.autoReceiveAfterDays = n;
    }

    public String getColCopyRelation() {
        if (this.colCopyRelation == null) {
            return "";
        }
        return Escape.unescape(this.colCopyRelation);
    }

    public void setColCopyRelation(String colCopyRelation) {
        if (colCopyRelation == null) {
            this.colCopyRelation = "";
            return;
        }
        String t = Escape.escape(colCopyRelation);
        this.colCopyRelation = Escape.escape(colCopyRelation);
    }

    public String getSubFlowCallType() {
        return this.subFlowCallType;
    }

    public void setSubFlowCallType(String ct) {
        if (ct == null) {
            ct = "";
        }
        this.subFlowCallType = ct;
    }

    public String getSocket1() {
        if (this.socket1 == null) {
            return "";
        }
        return Escape.unescape(this.socket1);
    }

    public void setSocket1(String s) {
        if (s == null) {
            this.socket1 = null;
            return;
        }
        if (s.equals("")) {
            s = " ";
        }
        this.socket1 = Escape.escape(s);
    }

    public String getSocketTip1() {
        if (this.socketTip1 == null) {
            return "";
        }
        return Escape.unescape(this.socketTip1);
    }

    public void setSocketTip1(String s) {
        if (s == null) {
            this.socketTip1 = "";
            return;
        }
        if (s.equals("")) {
            s = " ";
        }
        this.socketTip1 = Escape.escape(s);
    }

    public int getNodeNo() {
        return this.nodeNo;
    }

    public void setNodeNo(int n) {
        this.nodeNo = n;
    }

    public boolean isCanTakeOver() {
        return this.canTakeOver;
    }

    public void setCanTakeOver(boolean canTakeOver) {
        this.canTakeOver = canTakeOver;
    }

    public boolean isExcludeScriptRunOnServer() {
        return this.excludeScriptRunOnServer;
    }

    public void setExcludeScriptRunOnServer(boolean excludeScriptRunOnServer) {
        this.excludeScriptRunOnServer = excludeScriptRunOnServer;
    }

    public boolean isScriptRunOnServer() {
        return this.scriptRunOnServer;
    }

    public void setScriptRunOnServer(boolean scriptRunOnServer) {
        this.scriptRunOnServer = scriptRunOnServer;
    }

    public String getThirdConfig() {
        if (this.thirdConfig == null) {
            return "";
        }
        return this.thirdConfig;
    }

    public void setThirdConfig(String thirdConfig) {
        if (thirdConfig == null) {
            thirdConfig = "";
        }
        this.thirdConfig = thirdConfig;
    }

    public boolean isPermitOver() {
        return this.permitOver;
    }

    public void setPermitOver(boolean permitOver) {
        this.permitOver = permitOver;
    }

    public boolean isMustFFPY() {
        return this.mustFFPY;
    }

    public void setMustFFPY(boolean mustFFPY) {
        this.mustFFPY = mustFFPY;
    }

    public boolean isDisableBenchSubmit() {
        return this.disablebenchsubmit;
    }

    public void setDisableBenchSubmit(boolean b) {
        this.disablebenchsubmit = b;
    }

    public boolean isCanMultiProcess() {
        return this.canMultiProcess;
    }

    public void setCanMultiProcess(boolean canMultiProcess) {
        this.canMultiProcess = canMultiProcess;
    }

    public boolean isCanMultiSession() {
        return this.canMultiSession;
    }

    public void setCanMultiSession(boolean canMultiSession) {
        this.canMultiSession = canMultiSession;
    }

    public String getCode() {
        return this.code == null ? "" : this.code;
    }

    public void setCode(String code) {
        this.code = code == null ? "" : code;
    }

    public int getMultiProcessOne() {
        return this.multiProcessOne;
    }

    public void setMultiProcessOne(int multiProcessOne) {
        this.multiProcessOne = multiProcessOne;
    }

    public boolean isCanUntread() {
        return this.canUntread;
    }

    public void setCanUntread(boolean canUntread) {
        this.canUntread = canUntread;
    }

    public boolean isCanFreeSubmit() {
        return this.canFreeSubmit;
    }

    public void setCanFreeSubmit(boolean canFreeSubmit) {
        this.canFreeSubmit = canFreeSubmit;
    }

    public boolean isCanViewAllAnswer() {
        return this.canViewAllAnswer;
    }

    public void setCanViewAllAnswer(boolean canViewAllAnswer) {
        this.canViewAllAnswer = canViewAllAnswer;
    }
}

