/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.graph;

import EDU.auburn.VGJ.graph.Edge;
import EDU.auburn.VGJ.graph.GMLobject;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.graph.NodeList;
import EDU.auburn.VGJ.graph.Set;
import EDU.auburn.VGJ.util.DDimension3;
import EDU.auburn.VGJ.util.DPoint3;
import java.awt.Point;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Graph
implements Cloneable {
    private NodeList nodeList_ = new NodeList();
    private Hashtable idHash_ = new Hashtable();
    private boolean directed_ = false;
    private int lastTopId_ = 0;
    private Hashtable edges_ = new Hashtable();
    private int ID = 0;

    public Graph() {
    }

    public Graph(boolean yesorno) {
        this.directed_ = yesorno;
    }

    public Graph(GMLobject gml) {
        this.directed_ = false;
        Integer tmp = (Integer)gml.getValue("directed", 0);
        if (tmp != null) {
            boolean bl = this.directed_ = tmp != 0;
        }
        if ((tmp = (Integer)gml.getValue("id", 0)) != null) {
            this.ID = tmp;
        }
        GMLobject nodegml = gml.getGMLSubObject("node", 3, false);
        while (nodegml != null) {
            Node node = new Node(nodegml);
            Integer id = node.getIdObject();
            if (id != null) {
                if (!this.idHash_.containsKey(id)) {
                    this.idHash_.put(id, node);
                    this.nodeList_.addNode(node);
                }
            } else {
                this.nodeList_.addNode(node);
            }
            nodegml = gml.getNextGMLSubObject();
        }
        GMLobject edgegml = gml.getGMLSubObject("edge", 3, false);
        while (edgegml != null) {
            Integer source = (Integer)edgegml.getValue("source", 0);
            Integer target = (Integer)edgegml.getValue("target", 0);
            if (source != null && target != null) {
                Node sourcenode = (Node)this.idHash_.get(source);
                Node targetnode = (Node)this.idHash_.get(target);
                if (sourcenode != null && targetnode != null) {
                    this.insertEdge(new Edge(sourcenode, targetnode, edgegml));
                }
            }
            edgegml = gml.getNextGMLSubObject();
        }
        this.validateIds();
        Node tmpnode = this.firstNode();
        while (tmpnode != null) {
            if (tmpnode.inGroup()) {
                tmpnode.groupNode_ = (Node)this.idHash_.get(new Integer(tmpnode.groupNodeId_));
                if (tmpnode.groupNode_ != null) {
                    tmpnode.groupNode_.isGroup_ = true;
                    tmpnode.groupNode_.setChild(tmpnode.getIndex());
                }
            }
            tmpnode = this.nextNode(tmpnode);
        }
    }

    private void validateIds() {
        this.lastTopId_ = 0;
        while (this.idHash_.containsKey(new Integer(this.lastTopId_))) {
            ++this.lastTopId_;
        }
        Node tmpnode = this.firstNode();
        while (tmpnode != null) {
            if (tmpnode.getIdObject() == null) {
                tmpnode.id_ = this.lastTopId_;
                tmpnode.haveId_ = true;
                this.idHash_.put(new Integer(this.lastTopId_), tmpnode);
                do {
                    ++this.lastTopId_;
                } while (this.idHash_.containsKey(new Integer(this.lastTopId_)));
            }
            tmpnode = this.nextNode(tmpnode);
        }
    }

    public void setGMLvalues(GMLobject gml) {
        gml.deleteAll("node", 3);
        Node node = this.nodeList_.firstNode();
        while (node != null) {
            GMLobject nodegml = new GMLobject("node", 3);
            gml.addObjectToEnd(nodegml);
            node.setGMLvalues(nodegml);
            node = this.nodeList_.nextNode(node);
        }
        gml.setValue("directed", 0, new Integer(this.directed_ ? 1 : 0));
        gml.setValue("id", 0, new Integer(this.ID));
        gml.deleteAll("edge", 3);
        Enumeration edges = this.edges_.elements();
        while (edges.hasMoreElements()) {
            Edge edge = (Edge)edges.nextElement();
            if (!this.directed_ && edge.tail().getIndex() > edge.head().getIndex()) continue;
            GMLobject edgegml = new GMLobject("edge", 3);
            gml.addObjectToEnd(edgegml);
            edge.setGMLvalues(edgegml);
        }
    }

    public boolean isDirected() {
        if (this.directed_) {
            return this.directed_;
        }
        return this.directed_;
    }

    public Object clone() {
        try {
            Graph copy = (Graph)super.clone();
            copy.nodeList_ = (NodeList)this.nodeList_.clone();
            copy.idHash_ = new Hashtable();
            copy.edges_ = new Hashtable();
            copy.directed_ = this.directed_;
            copy.lastTopId_ = this.lastTopId_;
            Enumeration edges = this.edges_.elements();
            while (edges.hasMoreElements()) {
                Edge edge = (Edge)edges.nextElement();
                Node tail = copy.nodeList_.nodeFromIndex(edge.tail_.getIndex());
                Node head = copy.nodeList_.nodeFromIndex(edge.head_.getIndex());
                Edge newedge = new Edge(tail, head, edge);
                copy.edges_.put(new Point(tail.index_, head.index_), newedge);
            }
            Node tmpnode = copy.firstNode();
            while (tmpnode != null) {
                copy.idHash_.put(new Integer(tmpnode.getId()), tmpnode);
                tmpnode = copy.nextNode(tmpnode);
            }
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void copy(Graph newgraph) {
        this.ID = newgraph.ID;
        this.directed_ = newgraph.directed_;
        this.nodeList_ = newgraph.nodeList_;
        this.idHash_ = newgraph.idHash_;
        this.edges_ = newgraph.edges_;
        this.lastTopId_ = newgraph.lastTopId_;
    }

    public int insertNode() {
        return this.insertNode(false);
    }

    public int insertNode(boolean dummy) {
        Node node = new Node(dummy);
        this.nodeList_.addNode(node);
        node.haveId_ = true;
        node.id_ = this.lastTopId_;
        this.idHash_.put(new Integer(this.lastTopId_), node);
        do {
            ++this.lastTopId_;
        } while (this.idHash_.containsKey(new Integer(this.lastTopId_)));
        return node.index_;
    }

    public Node getNodeFromIndex(int index) {
        return this.nodeList_.nodeFromIndex(index);
    }

    public Node getNodeFromId(int id) {
        return (Node)this.idHash_.get(new Integer(id));
    }

    public void insertNodeAt(int index) throws IOException {
        IOException e = new IOException("Node " + index + " already exist.");
        if (this.nodeList_.nodeFromIndex(index) == null) {
            Node node = new Node();
            this.nodeList_.addNodeAt(node, index);
            node.haveId_ = true;
            node.id_ = this.lastTopId_;
            this.idHash_.put(new Integer(this.lastTopId_), node);
            do {
                ++this.lastTopId_;
            } while (this.idHash_.containsKey(new Integer(this.lastTopId_)));
        } else {
            throw e;
        }
    }

    public void removeNode(int n) {
        Set pSet = new Set();
        Set cSet = new Set();
        Node remnode = this.nodeList_.nodeFromIndex(n);
        if (remnode.isGroup()) {
            int child_index = remnode.firstChild();
            while (child_index != -1) {
                this.removeNode(child_index);
                child_index = remnode.nextChild();
            }
        } else {
            int child = remnode.firstChild();
            while (child != -1) {
                this.removeEdge(n, child);
                child = remnode.nextChild();
            }
            Node node = this.nodeList_.firstNode();
            while (node != null) {
                if (node.hasChild(n)) {
                    this.removeEdge(node.getIndex(), n);
                }
                node = this.nodeList_.nextNode(node);
            }
        }
        this.nodeList_.removeNodeAt(n);
        Integer id = remnode.getIdObject();
        this.idHash_.remove(id);
        if (id < this.lastTopId_) {
            this.lastTopId_ = id;
        }
        if (remnode.inGroup()) {
            remnode.groupNode_.clearChild(remnode.getIndex());
            if (remnode.groupNode_.firstChild() == -1) {
                this.removeNode(remnode.groupNode_.getIndex());
            }
        }
    }

    public void removeNode(Node nin) {
        this.removeNode(nin.getIndex());
    }

    public Edge insertEdge(int n1, int n2) {
        return this.insertEdge(n1, n2, new DPoint3[0]);
    }

    public Edge insertEdge(int n1, int n2, DPoint3[] points) {
        return this.insertEdge(new Edge(this.nodeList_.nodeFromIndex(n1), this.nodeList_.nodeFromIndex(n2), points, false));
    }

    public Edge insertEdge(int n1, int n2, DPoint3[] points, String label) {
        Edge edge = new Edge(this.nodeList_.nodeFromIndex(n1), this.nodeList_.nodeFromIndex(n2), points, false);
        edge.setLabel(label);
        return this.insertEdge(edge);
    }

    public Edge insertEdge(Edge edge) {
        int n2;
        int n1 = edge.tail().getIndex();
        Point key = new Point(n1, n2 = edge.head().getIndex());
        if (this.edges_.containsKey(key)) {
            System.out.println("edge\u5df2\u7ecf\u5b58\u5728");
            return null;
        }
        if (this.directed_ && edge.head().isRoot()) {
            System.out.println("\u4e0d\u5141\u8bb8\u6307\u5411Root");
            return null;
        }
        this.edges_.remove(key);
        if (!this.directed_) {
            this.edges_.remove(new Point(n2, n1));
        }
        edge.tail().setChild(n2);
        if (!this.directed_) {
            edge.head().setChild(n1);
        }
        this.edges_.put(new Point(n1, n2), edge);
        DPoint3[] points = edge.points();
        if (!this.directed_ && n1 != n2) {
            int length = points.length;
            DPoint3[] reverse_points = new DPoint3[length];
            int i = 0;
            while (i < length) {
                reverse_points[i] = points[length - 1 - i];
                ++i;
            }
            this.edges_.put(new Point(n2, n1), new Edge(edge.head(), edge.tail(), reverse_points, false));
        }
        return edge;
    }

    public DPoint3[] getEdgePathPoints(int n1, int n2) {
        Edge edge = (Edge)this.edges_.get(new Point(n1, n2));
        if (edge == null) {
            return null;
        }
        return edge.points();
    }

    public Edge getEdge(int n1, int n2) {
        return (Edge)this.edges_.get(new Point(n1, n2));
    }

    public void removeEdge(int n1, int n2) {
        Node tempnode = this.nodeList_.nodeFromIndex(n1);
        tempnode.clearChild(n2);
        this.edges_.remove(new Point(n1, n2));
        if (!this.directed_ && n1 != n2) {
            tempnode = this.nodeList_.nodeFromIndex(n2);
            tempnode.clearChild(n1);
            this.edges_.remove(new Point(n2, n1));
        }
    }

    public void removeEdge(Edge edge) {
        this.removeEdge(edge.tail().getIndex(), edge.head().getIndex());
    }

    public Set parents(int n) {
        Set parents = new Set();
        Node node = this.nodeList_.firstNode();
        while (node != null) {
            if (node.hasChild(n)) {
                parents.includeElement(node.index_);
            }
            node = this.nodeList_.nextNode(node);
        }
        return parents;
    }

    public Set children(int n) {
        return this.nodeList_.nodeFromIndex(n).getChildren();
    }

    public int numberOfNodes() {
        return this.nodeList_.count();
    }

    public Node firstNode() {
        return this.nodeList_.firstNode();
    }

    public Node nextNode(Node node) {
        return this.nodeList_.nextNode(node);
    }

    public int getIndexFromNode(Node node) {
        return node.index_;
    }

    public int firstNodeIndex() {
        return this.nodeList_.firstNodeIndex();
    }

    public int nextNodeIndex(int index) {
        return this.nodeList_.nextNodeIndex(index);
    }

    public int firstAvailable() {
        return this.nodeList_.getFirstAvailable();
    }

    public int highestIndex() {
        return this.nodeList_.highestIndex();
    }

    public void setDirected(boolean directed) {
        if (directed == this.directed_) {
            return;
        }
        if (directed) {
            this.directed_ = true;
            this.removeFalseEdges_();
        } else {
            this.fillBackEdges_();
            this.directed_ = false;
        }
    }

    private void fillBackEdges_() {
        Enumeration edges = this.edges_.elements();
        while (edges.hasMoreElements()) {
            DPoint3[] reverse_points;
            Edge edge = (Edge)edges.nextElement();
            if (this.edges_.get(new Point(edge.head().getIndex(), edge.tail().getIndex())) != null) continue;
            int n1 = edge.tail().getIndex();
            int n2 = edge.head().getIndex();
            edge.head().setChild(n1);
            if (n1 > n2) {
                DPoint3[] points = edge.points();
                int length = points.length;
                reverse_points = new DPoint3[length];
                int i = 0;
                while (i < length) {
                    reverse_points[i] = points[length - 1 - i];
                    ++i;
                }
            } else {
                reverse_points = new DPoint3[]{};
            }
            this.edges_.put(new Point(n2, n1), new Edge(edge.head(), edge.tail(), reverse_points, true));
        }
    }

    private void removeFalseEdges_() {
        Enumeration edges = this.edges_.elements();
        while (edges.hasMoreElements()) {
            Edge edge = (Edge)edges.nextElement();
            if (!edge.isDummy()) continue;
            edge.tail().clearChild(edge.head().getIndex());
            this.edges_.remove(new Point(edge.tail().getIndex(), edge.head().getIndex()));
        }
    }

    public void pack() {
        Node tmpnode;
        int n = this.numberOfNodes();
        if (n == this.nodeList_.highestIndex() + 1) {
            return;
        }
        int highest_index = this.nodeList_.highestIndex();
        int[] map = new int[highest_index + 1];
        int node_index = this.nextNodeIndex(n - 1);
        while (node_index != -1) {
            tmpnode = this.getNodeFromIndex(node_index);
            this.nodeList_.addNode(tmpnode);
            map[node_index] = tmpnode.index_;
            this.nodeList_.removeNodeAt(node_index);
            node_index = this.nextNodeIndex(node_index);
        }
        tmpnode = this.firstNode();
        while (tmpnode != null) {
            int child = tmpnode.searchNextChild(n - 1);
            while (child != -1) {
                if (child >= n) {
                    tmpnode.setChild(map[child]);
                    tmpnode.clearChild(child);
                }
                child = tmpnode.searchNextChild(child + 1);
            }
            tmpnode = this.nextNode(tmpnode);
        }
        Enumeration keys = this.edges_.keys();
        while (keys.hasMoreElements()) {
            Point key = (Point)keys.nextElement();
            if (key.x < n && key.y < n) continue;
            if (key.x > highest_index || key.y > highest_index) {
                this.edges_.remove(key);
                continue;
            }
            Edge element = (Edge)this.edges_.get(key);
            this.edges_.remove(key);
            if (key.x >= n) {
                key.x = map[key.x];
            }
            if (key.y >= n) {
                key.y = map[key.y];
            }
            this.edges_.put(key, element);
        }
    }

    public void removeEdgePaths() {
        Enumeration elements = this.edges_.elements();
        while (elements.hasMoreElements()) {
            Edge edge = (Edge)elements.nextElement();
            edge.points_ = new DPoint3[0];
        }
    }

    public void dummysToEdgePaths() {
        Node tmpnode = this.firstNode();
        while (tmpnode != null) {
            if (!tmpnode.isDummy_) {
                int child = tmpnode.firstChild();
                while (child != -1) {
                    Node childnode;
                    Node tmpchild = childnode = this.getNodeFromIndex(child);
                    int numdummies = 0;
                    String label = this.getEdge(tmpnode.index_, child).getLabel();
                    while (tmpchild != null && tmpchild.isDummy_) {
                        ++numdummies;
                        tmpchild = this.getNodeFromIndex(tmpchild.firstChild());
                    }
                    if (numdummies > 0 && tmpchild != null) {
                        DPoint3[] edge_points = new DPoint3[numdummies];
                        tmpchild = childnode;
                        int dummy = 0;
                        while (tmpchild.isDummy_) {
                            edge_points[dummy++] = new DPoint3(tmpchild.getPosition3());
                            tmpchild = this.getNodeFromIndex(tmpchild.firstChild());
                        }
                        this.insertEdge(tmpnode.index_, tmpchild.index_, edge_points, label);
                    }
                    child = tmpnode.nextChild();
                }
            }
            tmpnode = this.nextNode(tmpnode);
        }
        tmpnode = this.firstNode();
        while (tmpnode != null) {
            if (tmpnode.isDummy_) {
                this.removeNode(tmpnode);
            }
            tmpnode = this.nextNode(tmpnode);
        }
    }

    public Enumeration getEdges() {
        return this.edges_.elements();
    }

    public int getNodesCount() {
        return this.nodeList_.count();
    }

    public Node nodeFromIndex(int index) {
        return this.nodeList_.nodeFromIndex(index);
    }

    public void group(Node node, boolean state) {
        if (state && node.groupNode_ != null) {
            node.groupNode_.groupActive_ = true;
            Node groupnode = node.groupNode_;
            this.markGroupChildren_(groupnode, true);
            DPoint3 pos = new DPoint3(0.0, 0.0, 0.0);
            DDimension3 size = new DDimension3(0.0, 0.0, 0.0);
            int n = this.getGroupCoordinates_(groupnode, pos, size);
            pos.x /= (double)n;
            pos.y /= (double)n;
            pos.z /= (double)n;
            size.width = Math.sqrt(size.width);
            size.height = Math.sqrt(size.height);
            size.depth = Math.sqrt(size.depth);
            groupnode.setPosition(pos);
            groupnode.setBoundingBox(size);
            groupnode.grouppos_ = pos;
            groupnode.groupbox_ = size;
        } else if (!state && node.isGroup_) {
            node.groupActive_ = false;
            this.markGroupChildren_(node, false);
            node.setSelected(false);
            double dx = node.x_ - node.grouppos_.x;
            double dy = node.y_ - node.grouppos_.y;
            double dz = node.z_ - node.grouppos_.z;
            double rw = node.width_ / node.groupbox_.width;
            double rh = node.height_ / node.groupbox_.height;
            double rd = node.depth_ / node.groupbox_.depth;
            this.adjustGroupChildren_(node, dx, dy, dz, rw, rh, rd);
        }
    }

    private int getGroupCoordinates_(Node node, DPoint3 pos, DDimension3 size) {
        int count = 0;
        int child_index = node.firstChild();
        while (child_index != -1) {
            Node child = this.getNodeFromIndex(child_index);
            if (child.isGroup() && !child.groupActive()) {
                count += this.getGroupCoordinates_(child, pos, size);
            } else {
                ++count;
                size.width += child.width_ * child.width_;
                size.height += child.height_ * child.height_;
                size.depth += child.depth_ * child.depth_;
                pos.x += child.x_;
                pos.y += child.y_;
                pos.z += child.z_;
            }
            child_index = node.nextChild();
        }
        return count;
    }

    private void adjustGroupChildren_(Node node, double dx, double dy, double dz, double rw, double rh, double rd) {
        int child_index = node.firstChild();
        while (child_index != -1) {
            Node child = this.getNodeFromIndex(child_index);
            if (child.isGroup() && !child.groupActive()) {
                this.adjustGroupChildren_(child, dx, dy, dz, rw, rh, rd);
            } else {
                child.x_ += dx;
                child.y_ += dy;
                child.z_ += dz;
                child.width_ *= rw;
                child.height_ *= rh;
                child.depth_ *= rd;
            }
            child_index = node.nextChild();
        }
    }

    private void markGroupChildren_(Node node, boolean state) {
        int child_index = node.firstChild();
        while (child_index != -1) {
            Node child = this.getNodeFromIndex(child_index);
            child.inActiveGroup_ = state;
            if (child.isGroup_ && (state || !child.groupActive_)) {
                this.markGroupChildren_(child, state);
            }
            child_index = node.nextChild();
        }
    }

    public void killGroup(Node node) {
        if (node.isGroup()) {
            int child_index = node.firstChild();
            while (child_index != -1) {
                node.clearChild(child_index);
                Node child = this.getNodeFromIndex(child_index);
                child.inActiveGroup_ = false;
                child.groupNode_ = null;
                if (child.isGroup() && !child.groupActive_) {
                    this.markGroupChildren_(child, false);
                }
                child_index = node.nextChild();
            }
            this.removeNode(node.getIndex());
        }
    }

    public void setNodeGroup(Node node, Node groupnode) {
        if (node.inGroup()) {
            Node current_group = node.groupNode_;
            current_group.clearChild(node.getIndex());
            if (current_group.firstChild() == -1) {
                this.removeNode(current_group.getIndex());
            }
        }
        node.groupNode_ = groupnode;
        groupnode.setChild(node.getIndex());
    }

    public void removeGroups() {
        int node_index = this.nodeList_.firstNodeIndex();
        while (node_index != -1) {
            this.killGroup(this.getNodeFromIndex(node_index));
            node_index = this.nodeList_.nextNodeIndex(node_index);
        }
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int id) {
        this.ID = id;
    }
}

