/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.graph;

import EDU.auburn.VGJ.graph.GMLlexer;
import EDU.auburn.VGJ.graph.ParseError;
import java.io.IOException;
import java.util.Hashtable;

public class GMLobject {
    public static final int GMLinteger = 0;
    public static final int GMLreal = 1;
    public static final int GMLstring = 2;
    public static final int GMLlist = 3;
    public static final int GMLundefined = 4;
    public static final int GMLfile = 5;
    protected String key_;
    protected Object value_;
    protected GMLobject next_;
    protected int type_;
    private GMLobject searchobj_ = null;
    private String searchkey_ = null;
    private int searchtype_;

    public GMLobject() {
        this.key_ = "undefined";
        this.value_ = null;
        this.next_ = null;
        this.type_ = 4;
    }

    public GMLobject(String key, int type) {
        this.key_ = key;
        this.type_ = type;
        this.value_ = null;
        this.next_ = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public GMLobject(GMLlexer lexer, String key) throws IOException, ParseError {
        this.next_ = null;
        this.key_ = key;
        if (key == null) {
            this.type_ = 5;
            this.value_ = this.parseGMLlist_(lexer);
            if (lexer.getTokenType() == GMLlexer.GMLeof) return;
            throw new ParseError("Expecting GML key or end-of-file");
        }
        int token = lexer.nextToken();
        if (token == GMLlexer.GMLinteger) {
            this.type_ = 0;
            this.value_ = new Integer((int)lexer.getDoubleval());
            return;
        }
        if (token == GMLlexer.GMLreal) {
            this.type_ = 1;
            this.value_ = new Double(lexer.getDoubleval());
            return;
        }
        if (token == GMLlexer.GMLstring) {
            this.type_ = 2;
            this.value_ = lexer.getStringval();
            return;
        }
        if (token != 91) throw new ParseError("Expecting GML value (number, string, or list)");
        this.type_ = 3;
        this.value_ = this.parseGMLlist_(lexer);
        if (lexer.getTokenType() == 93) return;
        throw new ParseError("Expecting GML key or ']'");
    }

    private GMLobject parseGMLlist_(GMLlexer lexer) throws IOException, ParseError {
        int token;
        GMLobject retval = null;
        GMLobject prevobj = null;
        while ((token = lexer.nextToken()) == GMLlexer.GMLkey) {
            GMLobject newobj = new GMLobject(lexer, lexer.getStringval());
            if (prevobj == null) {
                retval = newobj;
            } else {
                prevobj.next_ = newobj;
            }
            prevobj = newobj;
        }
        return retval;
    }

    public String toString(int numtabs) {
        if (this.value_ == null) {
            return "";
        }
        String retval = "";
        int i = 0;
        while (i < numtabs) {
            retval = String.valueOf(retval) + "   ";
            ++i;
        }
        if (this.key_ != null) {
            retval = String.valueOf(retval) + this.key_;
        }
        if (this.type_ == 0) {
            retval = String.valueOf(retval) + " " + ((Integer)this.value_).toString() + "\n";
        } else if (this.type_ == 1) {
            String doublestring;
            double val = (Double)this.value_;
            if (val == Double.POSITIVE_INFINITY || val == Double.NaN) {
                val = Double.MAX_VALUE;
            }
            if (val == Double.NEGATIVE_INFINITY) {
                val = Double.MIN_VALUE;
            }
            if ((doublestring = Double.toString(val)).indexOf(46) == -1) {
                String expstring = "";
                int expstart = doublestring.indexOf(101);
                if (expstart != -1) {
                    expstring = doublestring.substring(expstart);
                    doublestring = doublestring.substring(0, expstart);
                }
                doublestring = String.valueOf(doublestring) + ".0" + expstring;
            }
            retval = String.valueOf(retval) + " " + doublestring + "\n";
        } else if (this.type_ == 2) {
            retval = this.value_ == null ? String.valueOf(retval) + " \"\"\n" : String.valueOf(retval) + " \"" + (String)this.value_ + "\"\n";
        } else if (this.type_ == 3) {
            retval = String.valueOf(retval) + " [\n";
            GMLobject obj = (GMLobject)this.value_;
            while (obj != null) {
                if (obj.value_ != null) {
                    retval = String.valueOf(retval) + obj.toString(numtabs + 1);
                }
                obj = obj.next_;
            }
            i = 0;
            while (i < numtabs) {
                retval = String.valueOf(retval) + "   ";
                ++i;
            }
            retval = String.valueOf(retval) + "]\n";
        } else {
            GMLobject obj = (GMLobject)this.value_;
            while (obj != null) {
                retval = String.valueOf(retval) + obj.toString(numtabs);
                obj = obj.next_;
            }
        }
        return retval;
    }

    public GMLobject getNextGMLSubObject() {
        while (!(this.searchobj_ == null || this.searchobj_.key_ == null || this.searchobj_.key_.equals(this.searchkey_) && (this.searchobj_.type_ == this.searchtype_ || this.searchobj_.type_ == 0 && this.searchtype_ == 1))) {
            this.searchobj_ = this.searchobj_.next_;
        }
        if (this.searchobj_ != null && this.searchobj_.type_ != this.searchtype_) {
            this.searchobj_.type_ = 1;
            this.searchobj_.value_ = new Double(((Integer)this.searchobj_.value_).intValue());
        }
        GMLobject retval = this.searchobj_;
        if (this.searchobj_ != null) {
            this.searchobj_ = this.searchobj_.next_;
        }
        return retval;
    }

    public GMLobject getGMLSubObject(String path, int type, boolean create) {
        String key;
        int end;
        this.searchobj_ = null;
        GMLobject currentobj = this;
        int start = 0;
        if (currentobj.type_ != 3 && currentobj.type_ != 5) {
            return null;
        }
        do {
            key = (end = path.indexOf(46, start)) >= 0 ? path.substring(start, end) : path.substring(start);
            GMLobject obj = (GMLobject)currentobj.value_;
            while (obj != null) {
                if (obj.key_.equals(key) && (end >= 0 && (obj.type_ == 3 || obj.type_ == 5) || end == -1 && (obj.type_ == type || obj.type_ == 0 && type == 1))) break;
                obj = obj.next_;
            }
            if (obj == null) {
                if (!create) {
                    return null;
                }
                obj = new GMLobject(key, 3);
                if (end == -1) {
                    obj.type_ = type;
                }
                obj.next_ = (GMLobject)currentobj.value_;
                currentobj.value_ = obj;
            } else if (end == -1 && type != obj.type_) {
                obj.type_ = 1;
                obj.value_ = new Double(((Integer)obj.value_).intValue());
            }
            currentobj = obj;
        } while ((start = end + 1) != 0);
        this.searchobj_ = currentobj.next_;
        this.searchkey_ = key;
        this.searchtype_ = type;
        return currentobj;
    }

    public void setHashFromGML(String path, int type, Hashtable hash) {
        if (this.type_ != 3 && this.type_ != 5) {
            return;
        }
        GMLobject list = this.getGMLSubObject(path, 3, false);
        if (list == null) {
            return;
        }
        GMLobject tmp = (GMLobject)list.value_;
        while (tmp != null) {
            if (type == tmp.type_ || type == 1 && tmp.type_ == 0) {
                hash.put(tmp.key_, tmp.value_);
            }
            tmp = tmp.next_;
        }
    }

    public Object getValue(String path, int type) {
        GMLobject obj = this.getGMLSubObject(path, type, false);
        if (obj == null) {
            return null;
        }
        return obj.value_;
    }

    public void setValue(String path, int type, Object value) {
        GMLobject obj = this.getGMLSubObject(path, type, true);
        obj.value_ = value;
    }

    public void addObject(GMLobject object) {
        if (this.type_ != 3) {
            return;
        }
        object.next_ = (GMLobject)this.value_;
        this.value_ = object;
    }

    public void addObjectToEnd(GMLobject object) {
        if (this.type_ != 3 && this.type_ != 5) {
            return;
        }
        GMLobject obj = (GMLobject)this.value_;
        while (obj != null && obj.next_ != null) {
            obj = obj.next_;
        }
        if (obj == null) {
            this.value_ = object;
        } else {
            obj.next_ = object;
        }
    }

    public void deleteUnsafe() {
        if (this.type_ != 3 && this.type_ != 5) {
            return;
        }
        GMLobject object = (GMLobject)this.value_;
        GMLobject prevobject = null;
        while (object != null) {
            char chr;
            if (!object.key_.equals("vgj") && (chr = object.key_.charAt(0)) >= 'A' && chr <= 'Z') {
                object = object.next_;
                if (prevobject != null) {
                    prevobject.next_ = object;
                    continue;
                }
                this.value_ = object;
                continue;
            }
            object.deleteUnsafe();
            prevobject = object;
            object = object.next_;
        }
    }

    public void deleteAll(String key, int type) {
        GMLobject object = (GMLobject)this.value_;
        GMLobject prevobject = null;
        while (object != null) {
            if (object.key_.equals(key) && object.type_ == type) {
                object = object.next_;
                if (prevobject != null) {
                    prevobject.next_ = object;
                    continue;
                }
                this.value_ = object;
                continue;
            }
            prevobject = object;
            object = object.next_;
        }
    }

    public void prune() {
        if (this.type_ != 3) {
            return;
        }
        GMLobject obj = (GMLobject)this.value_;
        while (obj != null) {
            obj.prune();
            obj = obj.next_;
        }
        GMLobject prevobj = null;
        obj = (GMLobject)this.value_;
        while (obj != null) {
            if (obj.value_ == null) {
                if (prevobj != null) {
                    prevobj.next_ = obj.next_;
                } else {
                    this.value_ = obj.next_;
                }
            } else {
                prevobj = obj;
            }
            obj = obj.next_;
        }
    }
}

