/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.graph;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GMLlexer {
    public static int GMLstring = 256;
    public static int GMLinteger = 257;
    public static int GMLreal = 258;
    public static int GMLeof = 259;
    public static int GMLkey = 260;
    private InputStream stream_;
    private int linenumber_ = 0;
    private int nextChar_ = 10;
    private String stringval_;
    private double doubleval_;
    private int tokenType_;

    public GMLlexer(InputStream streamin) {
        this.stream_ = streamin;
    }

    public int nextToken() throws IOException {
        this.skipWhitespace_();
        if (this.nextChar_ >= 97 && this.nextChar_ <= 122 || this.nextChar_ >= 65 && this.nextChar_ <= 90) {
            this.stringval_ = "";
            boolean index = false;
            while (this.nextChar_ >= 97 && this.nextChar_ <= 122 || this.nextChar_ >= 65 && this.nextChar_ <= 90 || this.nextChar_ >= 48 && this.nextChar_ <= 57) {
                this.stringval_ = String.valueOf(this.stringval_) + String.valueOf((char)this.nextChar_);
                this.nextChar_ = this.stream_.read();
            }
            this.tokenType_ = GMLkey;
            return this.tokenType_;
        }
        if (this.nextChar_ == 45 || this.nextChar_ >= 48 && this.nextChar_ <= 57) {
            double fracval = 0.0;
            double expval = 0.0;
            double intval = 0.0;
            boolean havefrac = false;
            boolean haveexp = false;
            boolean isneg = false;
            boolean expisneg = false;
            if (this.nextChar_ == 45) {
                isneg = true;
                this.nextChar_ = this.stream_.read();
                if (this.nextChar_ >= 48 && this.nextChar_ > 57) {
                    // empty if block
                }
            }
            while (this.nextChar_ >= 48 && this.nextChar_ <= 57) {
                intval = intval * 10.0 + (double)this.nextChar_ - 48.0;
                this.nextChar_ = this.stream_.read();
            }
            if (this.nextChar_ == 46) {
                havefrac = true;
                this.nextChar_ = this.stream_.read();
                while (this.nextChar_ >= 48 && this.nextChar_ <= 57) {
                    fracval = (fracval + (double)(this.nextChar_ - 48)) / 10.0;
                    this.nextChar_ = this.stream_.read();
                }
            }
            if (this.nextChar_ == 101 || this.nextChar_ == 69) {
                this.stream_.mark(3);
                this.nextChar_ = this.stream_.read();
                if (this.nextChar_ < 48 && this.nextChar_ > 57 && this.nextChar_ != 45 && this.nextChar_ != 43) {
                    this.stream_.reset();
                } else {
                    if (this.nextChar_ == 43 || this.nextChar_ == 45) {
                        if (this.nextChar_ == 45) {
                            expisneg = true;
                        }
                        this.nextChar_ = this.stream_.read();
                    }
                    if (this.nextChar_ < 48 && this.nextChar_ > 57) {
                        this.stream_.reset();
                    } else {
                        haveexp = true;
                        while (this.nextChar_ >= 48 && this.nextChar_ <= 57) {
                            expval = expval * 10.0 + (double)(this.nextChar_ - 48);
                            this.nextChar_ = this.stream_.read();
                        }
                    }
                }
            }
            this.doubleval_ = intval;
            if (havefrac) {
                this.doubleval_ += fracval;
            }
            if (isneg) {
                this.doubleval_ = -this.doubleval_;
            }
            if (expisneg) {
                expval = -expval;
            }
            if (haveexp) {
                this.doubleval_ *= Math.pow(10.0, expval);
            }
            if (!havefrac && !haveexp) {
                this.tokenType_ = GMLinteger;
                return this.tokenType_;
            }
            return GMLreal;
        }
        if (this.nextChar_ == 34) {
            this.stringval_ = "";
            this.nextChar_ = this.stream_.read();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
            while (this.nextChar_ >= 0 && this.nextChar_ != 34) {
                bos.write(this.nextChar_);
                this.nextChar_ = this.stream_.read();
            }
            this.stringval_ = String.valueOf(this.stringval_) + bos.toString();
            if (this.nextChar_ != 34) {
                throw new IOException("\u7f3a\u5c11\u56de\u5f15\u53f7");
            }
            this.nextChar_ = this.stream_.read();
            this.tokenType_ = GMLstring;
            return this.tokenType_;
        }
        if (this.nextChar_ != -1) {
            int retval = this.nextChar_;
            this.stringval_ = String.valueOf((char)this.nextChar_);
            this.nextChar_ = this.stream_.read();
            this.tokenType_ = retval;
            return this.tokenType_;
        }
        this.tokenType_ = GMLeof;
        return this.tokenType_;
    }

    public String getStringval() {
        return this.stringval_;
    }

    public double getDoubleval() {
        return this.doubleval_;
    }

    public int getTokenType() {
        return this.tokenType_;
    }

    public int getLineNumber() {
        return this.linenumber_;
    }

    private void skipWhitespace_() throws IOException {
        while (this.nextChar_ == 32 || this.nextChar_ == 9 || this.nextChar_ == 10 || this.nextChar_ == 13) {
            if (this.nextChar_ == 10 || this.nextChar_ == 13) {
                int chr = this.nextChar_;
                ++this.linenumber_;
                this.nextChar_ = this.stream_.read();
                if (chr == 13 && this.nextChar_ == 10) {
                    this.nextChar_ = this.stream_.read();
                }
                if (this.nextChar_ != 35) continue;
                while (this.nextChar_ != 10 && this.nextChar_ != 13 && this.nextChar_ != -1) {
                    chr = this.nextChar_;
                    this.nextChar_ = this.stream_.read();
                }
                if (chr != 13 || this.nextChar_ != 10) continue;
                this.nextChar_ = this.stream_.read();
                continue;
            }
            this.nextChar_ = this.stream_.read();
        }
    }

    public static String Color2Hex(Color c) {
        String r = "00" + Integer.toString(c.getRed(), 16);
        r = r.substring(r.length() - 2, r.length());
        String g = "00" + Integer.toString(c.getGreen(), 16);
        g = g.substring(g.length() - 2, g.length());
        String b = "00" + Integer.toString(c.getBlue(), 16);
        b = b.substring(b.length() - 2, b.length());
        return "#" + r + g + b;
    }
}

