/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.algorithm.tree;

import EDU.auburn.VGJ.algorithm.GraphAlgorithm;
import EDU.auburn.VGJ.algorithm.tree.TreeAlgorithmData;
import EDU.auburn.VGJ.graph.Graph;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.gui.GraphCanvas;
import EDU.auburn.VGJ.util.DPoint;

public class TreeAlgorithm
implements GraphAlgorithm {
    private char rootOrient_;
    private DPoint rootPos_;
    private Graph graph_;
    private int depth_;
    private Node[] prevNodeAtLevel_;
    private double[] levelHeight_;
    private double[] levelPosition_;
    private double levelSeparation_;
    private double subtreeSeparation_;
    private double siblingSeparation_;

    public TreeAlgorithm(char orientation) {
        this.rootOrient_ = orientation;
    }

    public String compute(Graph graph, GraphCanvas update) {
        Node tmpnode;
        Node root = update.getSelectedNode();
        if (root == null && graph.isDirected()) {
            int numroots = 0;
            tmpnode = graph.firstNode();
            while (tmpnode != null) {
                if (graph.parents(tmpnode.getIndex()).isEmpty()) {
                    root = tmpnode;
                    ++numroots;
                }
                tmpnode = graph.nextNode(tmpnode);
            }
            if (numroots != 1) {
                root = null;
            }
        }
        if (root == null) {
            return "You need to select a root node.";
        }
        this.levelSeparation_ = update.getVSpacing();
        this.subtreeSeparation_ = this.siblingSeparation_ = update.getHSpacing();
        this.graph_ = graph;
        this.rootPos_ = root.getPosition();
        tmpnode = graph.firstNode();
        while (tmpnode != null) {
            tmpnode.data = new TreeAlgorithmData();
            tmpnode = graph.nextNode(tmpnode);
        }
        this.depth_ = 0;
        this.initializeData_(root, 0);
        this.prevNodeAtLevel_ = new Node[this.depth_ + 1];
        int i = 0;
        while (i < this.depth_ + 1) {
            this.prevNodeAtLevel_[i] = null;
            ++i;
        }
        this.setInitialPositions_(root);
        this.levelHeight_ = new double[this.depth_ + 1];
        i = 0;
        while (i < this.depth_ + 1) {
            this.levelHeight_[i] = 0.0;
            ++i;
        }
        this.setLevelHeight_(root);
        this.levelPosition_ = new double[this.depth_ + 1];
        this.levelPosition_[0] = 0.0;
        i = 1;
        while (i < this.depth_ + 1) {
            this.levelPosition_[i] = this.levelPosition_[i - 1] + (this.levelHeight_[i - 1] + this.levelHeight_[i]) / 2.0;
            ++i;
        }
        this.setFinalPositions_(root, 0.0);
        double xoffs = this.rootPos_.x - root.getPosition().x;
        double yoffs = this.rootPos_.y - root.getPosition().y;
        tmpnode = graph.firstNode();
        while (tmpnode != null) {
            if (((TreeAlgorithmData)tmpnode.data).level != -1) {
                DPoint pos = tmpnode.getPosition();
                tmpnode.setPosition(pos.x + xoffs, pos.y + yoffs);
            }
            tmpnode = graph.nextNode(tmpnode);
        }
        return null;
    }

    private void initializeData_(Node node, int level) {
        ((TreeAlgorithmData)node.data).level = level;
        if (level > this.depth_) {
            this.depth_ = level;
        }
        Node[] children = new Node[node.numberOfChildren()];
        int num_children = 0;
        int child = node.firstChild();
        while (child != -1) {
            if (((TreeAlgorithmData)this.graph_.getNodeFromIndex((int)child).data).level == -1) {
                children[num_children++] = this.graph_.getNodeFromIndex(child);
            }
            child = node.nextChild();
        }
        if (num_children == 0) {
            ((TreeAlgorithmData)node.data).isLeaf = true;
            return;
        }
        int i = 0;
        while (i < num_children - 1) {
            int j = i + 1;
            while (j < num_children) {
                if ((this.rootOrient_ == 'd' || this.rootOrient_ == 'u') && children[j].getPosition().x < children[i].getPosition().x || (this.rootOrient_ == 'l' || this.rootOrient_ == 'r') && children[j].getPosition().y < children[i].getPosition().y) {
                    Node tmpnode = children[i];
                    children[i] = children[j];
                    children[j] = tmpnode;
                }
                ++j;
            }
            ++i;
        }
        ((TreeAlgorithmData)node.data).leftChild = children[0];
        ((TreeAlgorithmData)node.data).rightChild = children[num_children - 1];
        i = 0;
        while (i < num_children) {
            ((TreeAlgorithmData)children[i].data).parent = node;
            ++i;
        }
        i = 0;
        while (i < num_children - 1) {
            ((TreeAlgorithmData)children[i].data).rightSibling = children[i + 1];
            ++i;
        }
        i = 1;
        while (i < num_children) {
            ((TreeAlgorithmData)children[i].data).leftSibling = children[i - 1];
            ++i;
        }
        i = 0;
        while (i < num_children) {
            ((TreeAlgorithmData)children[i].data).level = level + 1;
            ++i;
        }
        i = 0;
        while (i < num_children) {
            this.initializeData_(children[i], level + 1);
            ++i;
        }
    }

    private void setInitialPositions_(Node node) {
        TreeAlgorithmData data = (TreeAlgorithmData)node.data;
        data.leftNeighbor = this.prevNodeAtLevel_[data.level];
        if (data.leftNeighbor != null) {
            ((TreeAlgorithmData)data.leftNeighbor.data).rightNeighbor = node;
        }
        this.prevNodeAtLevel_[data.level] = node;
        if (data.leftSibling != null) {
            data.prelim = this.rootOrient_ == 'd' || this.rootOrient_ == 'u' ? ((TreeAlgorithmData)data.leftSibling.data).prelim + this.siblingSeparation_ + (node.getBoundingBox().width + data.leftSibling.getBoundingBox().width) / 2.0 : ((TreeAlgorithmData)data.leftSibling.data).prelim + this.siblingSeparation_ + (node.getBoundingBox().height + data.leftSibling.getBoundingBox().height) / 2.0;
        }
        if (!data.isLeaf) {
            Node tmpnode = data.leftChild;
            while (tmpnode != null) {
                this.setInitialPositions_(tmpnode);
                tmpnode = ((TreeAlgorithmData)tmpnode.data).rightSibling;
            }
            double mid_point = (((TreeAlgorithmData)data.leftChild.data).prelim + ((TreeAlgorithmData)data.rightChild.data).prelim) / 2.0;
            if (data.leftSibling != null) {
                data.modifier = data.prelim - mid_point;
                this.evenOut(node);
            } else {
                data.prelim = mid_point;
            }
        }
    }

    private void evenOut(Node node) {
        TreeAlgorithmData data = (TreeAlgorithmData)node.data;
        Node left_most = data.leftChild;
        Node neighbor = ((TreeAlgorithmData)left_most.data).leftNeighbor;
        int compare_depth = 1;
        while (left_most != null && neighbor != null) {
            double left_mod_sum = 0.0;
            double right_mod_sum = 0.0;
            Node ancestor_leftmost = left_most;
            Node ancestor_neighbor = neighbor;
            int i = 0;
            while (i < compare_depth) {
                ancestor_leftmost = ((TreeAlgorithmData)ancestor_leftmost.data).parent;
                ancestor_neighbor = ((TreeAlgorithmData)ancestor_neighbor.data).parent;
                right_mod_sum += ((TreeAlgorithmData)ancestor_leftmost.data).modifier;
                left_mod_sum += ((TreeAlgorithmData)ancestor_neighbor.data).modifier;
                ++i;
            }
            double move_distance = this.rootOrient_ == 'd' || this.rootOrient_ == 'u' ? ((TreeAlgorithmData)neighbor.data).prelim + left_mod_sum + this.subtreeSeparation_ + (left_most.getBoundingBox().width + neighbor.getBoundingBox().width) / 2.0 - ((TreeAlgorithmData)left_most.data).prelim - right_mod_sum : ((TreeAlgorithmData)neighbor.data).prelim + left_mod_sum + this.subtreeSeparation_ + (left_most.getBoundingBox().height + neighbor.getBoundingBox().height) / 2.0 - ((TreeAlgorithmData)left_most.data).prelim - right_mod_sum;
            if (move_distance > 0.0) {
                Node tmpnode = node;
                int left_sibling = 0;
                while (tmpnode != null && tmpnode != ancestor_neighbor) {
                    ++left_sibling;
                    tmpnode = ((TreeAlgorithmData)tmpnode.data).leftSibling;
                }
                if (tmpnode != null) {
                    double slide_value = move_distance / (double)left_sibling;
                    tmpnode = node;
                    while (tmpnode != ancestor_neighbor) {
                        ((TreeAlgorithmData)tmpnode.data).prelim += move_distance;
                        ((TreeAlgorithmData)tmpnode.data).modifier += move_distance;
                        move_distance -= slide_value;
                        tmpnode = ((TreeAlgorithmData)tmpnode.data).leftSibling;
                    }
                } else {
                    return;
                }
            }
            if ((left_most = ((TreeAlgorithmData)left_most.data).leftChild == null ? this.leftMost_(node, 0, ++compare_depth) : ((TreeAlgorithmData)left_most.data).leftChild) == null) continue;
            neighbor = ((TreeAlgorithmData)left_most.data).leftNeighbor;
        }
    }

    private Node leftMost_(Node node, int level, int depth) {
        if (level >= depth) {
            return node;
        }
        if (((TreeAlgorithmData)node.data).leftChild == null) {
            return null;
        }
        Node right_most = ((TreeAlgorithmData)node.data).leftChild;
        Node left_most = this.leftMost_(right_most, level + 1, depth);
        while (left_most == null && ((TreeAlgorithmData)right_most.data).rightSibling != null) {
            right_most = ((TreeAlgorithmData)right_most.data).rightSibling;
            left_most = this.leftMost_(right_most, level + 1, depth);
        }
        return left_most;
    }

    private void setFinalPositions_(Node node, double mod_sum) {
        double x = 0.0;
        double y = 0.0;
        TreeAlgorithmData data = (TreeAlgorithmData)node.data;
        x = data.prelim + mod_sum;
        y = (double)(-data.level) * this.levelSeparation_ - this.levelPosition_[data.level];
        if (data.leftChild != null) {
            this.setFinalPositions_(data.leftChild, mod_sum + data.modifier);
        }
        if (data.rightSibling != null) {
            this.setFinalPositions_(data.rightSibling, mod_sum);
        }
        if (this.rootOrient_ == 'd') {
            node.setPosition(x, y);
        } else if (this.rootOrient_ == 'u') {
            node.setPosition(x, -y);
        } else if (this.rootOrient_ == 'l') {
            node.setPosition(y, x);
        } else if (this.rootOrient_ == 'r') {
            node.setPosition(-y, x);
        }
    }

    private void setLevelHeight_(Node node) {
        TreeAlgorithmData data = (TreeAlgorithmData)node.data;
        if (this.rootOrient_ == 'd' || this.rootOrient_ == 'u') {
            if (node.getBoundingBox().height > this.levelHeight_[data.level]) {
                this.levelHeight_[data.level] = node.getBoundingBox().height;
            }
        } else if (node.getBoundingBox().width > this.levelHeight_[data.level]) {
            this.levelHeight_[data.level] = node.getBoundingBox().width;
        }
        if (data.leftChild != null) {
            this.setLevelHeight_(data.leftChild);
        }
        if (data.rightSibling != null) {
            this.setLevelHeight_(data.rightSibling);
        }
    }

    private void createGroups_(Node node) {
        TreeAlgorithmData data = (TreeAlgorithmData)node.data;
        if (data.leftChild != null) {
            this.createGroups_(data.leftChild);
        }
        if (data.rightSibling != null) {
            this.createGroups_(data.rightSibling);
        }
        if (data.leftChild == null) {
            return;
        }
        int groupnode_id = this.graph_.insertNode();
        Node groupnode = this.graph_.nodeFromIndex(groupnode_id);
        groupnode.setGroup();
        data.group = groupnode;
    }

    private void groupNodes_(Node node) {
        TreeAlgorithmData data = (TreeAlgorithmData)node.data;
        if (data.leftChild != null) {
            this.groupNodes_(data.leftChild);
        }
        if (data.rightSibling != null) {
            this.groupNodes_(data.rightSibling);
        }
        if (data.leftChild == null) {
            return;
        }
        Node groupnode = data.group;
        Node child = data.leftChild;
        while (child != null) {
            TreeAlgorithmData child_data = (TreeAlgorithmData)child.data;
            Node tmpnode = child;
            if (child_data.group != null) {
                tmpnode = child_data.group;
            }
            this.graph_.setNodeGroup(tmpnode, groupnode);
            child = child_data.rightSibling;
        }
        this.graph_.setNodeGroup(node, groupnode);
    }
}

