/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.algorithm.cgd;

import EDU.auburn.VGJ.algorithm.cgd.Clan;
import EDU.auburn.VGJ.graph.Graph;
import EDU.auburn.VGJ.graph.Set;
import EDU.auburn.VGJ.util.DDimension;
import EDU.auburn.VGJ.util.DPoint;

public class ClanTree {
    public ClanTree parent = null;
    public ClanTree firstChild = null;
    public ClanTree nextSibling = null;
    public Clan clan = null;
    public double minx;
    public double maxx;
    public double centerx;
    public ClanTree leftSibling;
    public DDimension size = new DDimension(0.0, 0.0);
    public DPoint position = new DPoint(0.0, 0.0);
    public double extraheight = 0.0;
    public boolean dummy;
    public int heightInTree;

    public String toString() {
        return this.toString_(0, null);
    }

    public String toString(Graph graph) {
        return this.toString_(0, graph);
    }

    private String toString_(int indent, Graph graph) {
        String string = new String();
        int i = 0;
        while (i < indent) {
            string = String.valueOf(string) + "   ";
            ++i;
        }
        string = graph != null ? String.valueOf(string) + this.clan.toString(graph) : String.valueOf(string) + this.clan.toString();
        if (this.firstChild != null) {
            string = String.valueOf(string) + "\n";
            i = 0;
            while (i < indent + 1) {
                string = String.valueOf(string) + "   ";
                ++i;
            }
            string = String.valueOf(string) + "(\n";
            ClanTree tmpclan = this.firstChild;
            while (tmpclan != null) {
                string = String.valueOf(string) + tmpclan.toString_(indent + 1, graph);
                string = String.valueOf(string) + "\n";
                tmpclan = tmpclan.nextSibling;
            }
            i = 0;
            while (i < indent + 1) {
                string = String.valueOf(string) + "   ";
                ++i;
            }
            string = String.valueOf(string) + ")";
        }
        return string;
    }

    public void fixLinear(Set node_subset, Set[] child_relation, Set[] parent_relation) {
        ClanTree child = this.firstChild;
        while (child != null) {
            child.fixLinear(node_subset, child_relation, parent_relation);
            child = child.nextSibling;
        }
        if (this.clan.clanType != 3) {
            return;
        }
        boolean is_linear = true;
        ClanTree last = this.firstChild;
        ClanTree cur = last.nextSibling;
        while (is_linear && cur != null) {
            Set last_children = new Set();
            last_children.union(child_relation[last.clan.sinks.first()]);
            last_children.intersect(node_subset);
            Set cur_parents = new Set();
            cur_parents.union(parent_relation[cur.clan.sources.first()]);
            cur_parents.intersect(node_subset);
            if (!cur.clan.nodes.isSubset(last_children) || !last.clan.nodes.isSubset(cur_parents)) {
                is_linear = false;
                break;
            }
            last = cur;
            cur = last.nextSibling;
        }
        if (is_linear) {
            this.clan.clanType = 2;
        }
    }

    public int numberOfChildren() {
        int num = 0;
        ClanTree tmpnode = this.firstChild;
        while (tmpnode != null) {
            ++num;
            tmpnode = tmpnode.nextSibling;
        }
        return num;
    }
}

