/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.algorithm.cgd;

import EDU.auburn.VGJ.algorithm.GraphAlgorithm;
import EDU.auburn.VGJ.algorithm.cgd.Clan;
import EDU.auburn.VGJ.algorithm.cgd.ClanTree;
import EDU.auburn.VGJ.algorithm.cgd.Partition;
import EDU.auburn.VGJ.graph.Graph;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.graph.Set;
import EDU.auburn.VGJ.gui.GraphCanvas;
import EDU.auburn.VGJ.util.DDimension;
import EDU.auburn.VGJ.util.DPoint;
import javax.swing.JOptionPane;

public class CGDAlgorithm
implements GraphAlgorithm {
    private Set[] childRelation_;
    private Set[] descendentRelation_;
    private Set[] parentRelation_;
    private Set[] ancestorRelation_;
    private int numNodes_;
    private int numNodesOriginal_;
    private Graph graph_;
    private Clan firstClan_;
    private Set[] ccNodes_;
    private int ccComponents_;
    private int[] topOOrder_;
    private int[] height_;
    private ClanTree root_;
    private double vSpacing_;
    private double hSpacing_;
    private boolean showTree_;
    private int lastIndex_;
    private ClanTree[] treeLookup_;
    private static final int debug_ = 0;
    private int id_;
    private int numClans_;

    public CGDAlgorithm() {
        this.showTree_ = false;
    }

    public CGDAlgorithm(boolean show) {
        this.showTree_ = show;
    }

    public String compute(Graph graph, GraphCanvas update) {
        int j;
        if (!graph.isDirected()) {
            return "\u672c\u529f\u80fd\u4ec5\u5bf9\u6709\u5411\u56fe\u6709\u6548.";
        }
        this.graph_ = graph;
        Graph oldgraph = (Graph)graph.clone();
        if (this.graph_.numberOfNodes() < 2) {
            return "\u81f3\u5c11\u5b9a\u4e49\u4e24\u4e2a\u8282\u70b9\u624d\u597d\u5e03\u5c40.";
        }
        this.makeChildRelation_();
        this.numNodesOriginal_ = this.numNodes_;
        Set[] old_child_relation = new Set[this.numNodes_];
        int i = 0;
        while (i < this.numNodes_) {
            old_child_relation[i] = (Set)this.childRelation_[i].clone();
            ++i;
        }
        this.transitiveReduction_();
        int extras = 0;
        i = 0;
        while (i < this.numNodes_) {
            j = old_child_relation[i].first();
            while (j != -1) {
                if (!this.childRelation_[i].isElement(j)) {
                    ++extras;
                }
                j = old_child_relation[i].next();
            }
            ++i;
        }
        this.numNodes_ += extras;
        Set[] new_child_relation = new Set[this.numNodes_];
        i = 0;
        while (i < this.numNodes_) {
            new_child_relation[i] = new Set();
            ++i;
        }
        i = 0;
        while (i < this.numNodesOriginal_) {
            j = this.childRelation_[i].first();
            while (j != -1) {
                new_child_relation[i].includeElement(j);
                j = this.childRelation_[i].next();
            }
            ++i;
        }
        this.lastIndex_ = this.numNodesOriginal_;
        i = 0;
        while (i < this.numNodesOriginal_) {
            j = old_child_relation[i].first();
            while (j != -1) {
                if (!this.childRelation_[i].isElement(j)) {
                    int newindex = graph.insertNode(true);
                    graph.removeEdge(i, j);
                    graph.insertEdge(i, newindex);
                    graph.insertEdge(newindex, j);
                    new_child_relation[i].includeElement(newindex);
                    new_child_relation[newindex].includeElement(j);
                }
                j = old_child_relation[i].next();
            }
            ++i;
        }
        this.childRelation_ = new_child_relation;
        Set[] child_relation_back = new Set[this.numNodes_];
        i = 0;
        while (i < this.numNodes_) {
            child_relation_back[i] = (Set)this.childRelation_[i].clone();
            ++i;
        }
        this.transitiveClosure_();
        this.descendentRelation_ = new Set[this.numNodes_];
        i = 0;
        while (i < this.numNodes_) {
            this.descendentRelation_[i] = (Set)this.childRelation_[i].clone();
            ++i;
        }
        this.childRelation_ = child_relation_back;
        i = 0;
        while (i < this.numNodes_) {
            if (this.descendentRelation_[i].isElement(i)) {
                this.graph_.copy(oldgraph);
                return "\u5305\u542b\u6709\u5faa\u73af\uff0c\u4e0d\u80fd\u4f7f\u7528\u672c\u529f\u80fd\u8fdb\u884c\u81ea\u52a8\u5e03\u5c40\uff0c\u8bf7\u4f7f\u7528\u6811\u5f62\u5e03\u5c40.";
            }
            ++i;
        }
        this.parentRelation_ = new Set[this.numNodes_];
        this.ancestorRelation_ = new Set[this.numNodes_];
        i = 0;
        while (i < this.numNodes_) {
            this.parentRelation_[i] = new Set();
            this.ancestorRelation_[i] = new Set();
            ++i;
        }
        i = 0;
        while (i < this.numNodes_) {
            j = this.childRelation_[i].first();
            while (j != -1) {
                this.parentRelation_[j].includeElement(i);
                j = this.childRelation_[i].next();
            }
            j = this.descendentRelation_[i].first();
            while (j != -1) {
                this.ancestorRelation_[j].includeElement(i);
                j = this.descendentRelation_[i].next();
            }
            ++i;
        }
        this.assignHeights_();
        this.topOOrder_ = new int[this.numNodes_];
        boolean is_dag = this.fillTopOOrder_();
        if (!is_dag) {
            return "\u5305\u542b\u6709\u5faa\u73af\uff0c\u4e0d\u80fd\u4f7f\u7528\u672c\u529f\u80fd\u8fdb\u884c\u81ea\u52a8\u5e03\u5c40\uff0c\u8bf7\u4f7f\u7528\u6811\u5f62\u5e03\u5c40.";
        }
        Set allNodes = new Set();
        allNodes.fill(this.numNodes_);
        this.root_ = null;
        this.parseSet_(allNodes);
        this.breakPrimitives_(this.root_);
        this.reduce_(this.root_);
        this.id_ = this.numNodes_;
        this.setId_(this.root_);
        this.numClans_ = this.id_ - this.numNodes_;
        this.setPositions_(this.root_);
        this.reOrder_(this.root_);
        this.vSpacing_ = update.getVSpacing();
        this.hSpacing_ = update.getHSpacing();
        this.graph_.removeEdgePaths();
        this.attributeGraph_();
        graph.dummysToEdgePaths();
        if (this.showTree_) {
            JOptionPane.showMessageDialog(update.getFrame(), this.root_.toString(this.graph_), "\u63d0\u793a", 2);
            this.graph_.copy(oldgraph);
        }
        return null;
    }

    private void breakPrimitives_(ClanTree node) {
        if (node.clan.clanType == 3) {
            ClanTree subclan;
            node.clan.clanType = 2;
            ClanTree ind_tree = new ClanTree();
            ind_tree.clan = new Clan(4, new Set(), node.clan.sources, new Set(), node.clan.order);
            Set remaining_nodes = (Set)node.clan.nodes.clone();
            int curr_max = 0;
            int n = node.clan.sources.first();
            while (n != -1) {
                if (this.height_[n] > curr_max) {
                    curr_max = this.height_[n];
                }
                n = node.clan.sources.next();
            }
            while ((subclan = node.firstChild) != null) {
                node.firstChild = node.firstChild.nextSibling;
                if (!node.clan.sources.intersects(subclan.clan.sources)) continue;
                if (this.height_[subclan.clan.sources.first()] >= curr_max) {
                    ind_tree.clan.nodes.union(subclan.clan.nodes);
                    ind_tree.clan.sinks.union(subclan.clan.sinks);
                    this.addChild_(ind_tree, subclan);
                    remaining_nodes.difference(subclan.clan.nodes);
                    continue;
                }
                if (this.parentRelation_[subclan.clan.sources.first()].isEmpty()) continue;
                ind_tree.clan.nodes.union(subclan.clan.nodes);
                ind_tree.clan.sinks.union(subclan.clan.sinks);
                this.addChild_(ind_tree, subclan);
                remaining_nodes.difference(subclan.clan.nodes);
            }
            this.addChild_(node, ind_tree);
            this.addChild_(node, this.parseSet_(remaining_nodes));
        }
        ClanTree tmpclan = node.firstChild;
        while (tmpclan != null) {
            this.breakPrimitives_(tmpclan);
            tmpclan = tmpclan.nextSibling;
        }
    }

    private ClanTree parseSet_(Set node_subset) {
        Clan f;
        Partition S = new Partition(0, this.childRelation_, this.parentRelation_, this.descendentRelation_, this.ancestorRelation_, this.numNodes_, node_subset);
        Partition M = new Partition(1, this.childRelation_, this.parentRelation_, this.descendentRelation_, this.ancestorRelation_, this.numNodes_, node_subset);
        this.firstClan_ = null;
        int i = 0;
        while (i < S.size()) {
            int j = 0;
            while (j < M.size()) {
                Set F = (Set)S.star(i).clone();
                F.intersect(M.star(j));
                if (F.numberOfElements() > 1) {
                    this.makeConnectedComponents_(F);
                    int legal_components = 0;
                    Set legal_nodes = new Set();
                    Clan candidates = null;
                    int c = 0;
                    while (c < this.ccComponents_) {
                        if (this.ccNodes_[c].numberOfElements() > 1) {
                            Set s = (Set)S.members(i).clone();
                            s.intersect(this.ccNodes_[c]);
                            Set m = (Set)M.members(j).clone();
                            m.intersect(this.ccNodes_[c]);
                            Set ds = (Set)s.clone();
                            Set am = (Set)m.clone();
                            ds.indexedUnion(this.descendentRelation_, s);
                            am.indexedUnion(this.ancestorRelation_, m);
                            Set ads = (Set)ds.clone();
                            Set adm = (Set)am.clone();
                            ads.indexedUnion(this.ancestorRelation_, s);
                            adm.indexedUnion(this.descendentRelation_, m);
                            ds.intersect(node_subset);
                            am.intersect(node_subset);
                            ads.intersect(node_subset);
                            adm.intersect(node_subset);
                            if (adm.isSubset(ds) && ads.isSubset(am)) {
                                Clan clan = new Clan(0, this.ccNodes_[c], s, m, this.nodeOrder_(this.ccNodes_[c]));
                                clan.next = candidates;
                                candidates = clan;
                                ++legal_components;
                                legal_nodes.union(this.ccNodes_[c]);
                            }
                        } else {
                            ++legal_components;
                            legal_nodes.union(this.ccNodes_[c]);
                        }
                        ++c;
                    }
                    if (legal_components > 1) {
                        Set sources = (Set)legal_nodes.clone();
                        Set sinks = (Set)legal_nodes.clone();
                        sources.intersect(S.members(i));
                        sinks.intersect(M.members(j));
                        Clan clan = new Clan(1, legal_nodes, sources, sinks, this.nodeOrder_(sources));
                        clan.next = candidates;
                        candidates = clan;
                    }
                    while (candidates != null) {
                        Clan cand = candidates;
                        candidates = candidates.next;
                        Set cand_nodes = cand.nodes;
                        Clan prev_clan = null;
                        Clan clan = this.firstClan_;
                        while (clan != null) {
                            Set clan_nodes = clan.nodes;
                            if (cand_nodes.equals(clan_nodes)) {
                                if (cand.clanType != 0) {
                                    clan.clanType = cand.clanType;
                                }
                                cand = null;
                                break;
                            }
                            if (cand_nodes.intersects(clan_nodes) && !clan_nodes.isSubset(cand_nodes) && !cand_nodes.isSubset(clan_nodes)) {
                                cand_nodes.union(clan_nodes);
                                cand.size = cand_nodes.numberOfElements();
                                cand.clanType = 2;
                                if (prev_clan != null) {
                                    prev_clan.listnext = clan.listnext;
                                } else {
                                    this.firstClan_ = clan.listnext;
                                }
                            }
                            prev_clan = clan;
                            clan = clan.listnext;
                        }
                        if (cand == null) continue;
                        if (cand.clanType == 0) {
                            cand.clanType = 3;
                        }
                        this.addToClanList_(cand);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.firstClan_.next = null;
        Clan largest = this.firstClan_;
        while (largest.listnext != null) {
            largest.listnext.next = largest;
            largest = largest.listnext;
        }
        ClanTree root = new ClanTree();
        if (this.root_ == null) {
            this.root_ = root;
        }
        root.clan = largest;
        largest = largest.next;
        while ((f = largest) != null) {
            largest = largest.next;
            this.addClan_(root, f);
        }
        int i2 = node_subset.first();
        while (i2 != -1) {
            Set singleset = new Set();
            singleset.includeElement(i2);
            Clan clan = new Clan(5, singleset, singleset, singleset, this.topOOrder_[i2]);
            this.addClan_(root, clan);
            i2 = node_subset.next();
        }
        root.fixLinear(node_subset, this.childRelation_, this.parentRelation_);
        return root;
    }

    private void addToClanList_(Clan clan) {
        if (this.firstClan_ == null) {
            this.firstClan_ = clan;
            return;
        }
        if (this.firstClan_.size > clan.size) {
            clan.listnext = this.firstClan_;
            this.firstClan_ = clan;
            return;
        }
        Clan tmpclan = this.firstClan_;
        while (tmpclan.listnext != null && tmpclan.listnext.size < clan.size) {
            tmpclan = tmpclan.listnext;
        }
        clan.listnext = tmpclan.listnext;
        tmpclan.listnext = clan;
    }

    private void transitiveClosure_() {
        int i = 0;
        while (i < this.numNodes_) {
            int j = 0;
            while (j < this.numNodes_) {
                if (this.childRelation_[j].isElement(i)) {
                    this.childRelation_[j].union(this.childRelation_[i]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void transitiveReduction_() {
        this.transitiveClosure_();
        int i = 0;
        while (i < this.numNodes_) {
            int j = 0;
            while (j < this.numNodes_) {
                if (this.childRelation_[j].isElement(i)) {
                    this.childRelation_[j].difference(this.childRelation_[i]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void makeChildRelation_() {
        this.numNodes_ = 0;
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (tmpnode.getIndex() > this.numNodes_ - 1) {
                this.numNodes_ = tmpnode.getIndex() + 1;
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        this.childRelation_ = new Set[this.numNodes_];
        int i = 0;
        while (i < this.numNodes_) {
            this.childRelation_[i] = new Set();
            ++i;
        }
        tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            int child = tmpnode.firstChild();
            while (child != -1) {
                this.childRelation_[tmpnode.getIndex()].includeElement(child);
                child = tmpnode.nextChild();
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
    }

    void makeConnectedComponents_(Set f) {
        int n;
        this.ccComponents_ = 0;
        this.ccNodes_ = new Set[f.numberOfElements()];
        while ((n = f.first()) != -1) {
            this.ccNodes_[this.ccComponents_] = new Set();
            Set c = this.ccNodes_[this.ccComponents_];
            c.includeElement(n);
            Set tmpset = (Set)this.ancestorRelation_[n].clone();
            tmpset.union(this.descendentRelation_[n]);
            tmpset.intersect(f);
            c.union(tmpset);
            int last_size = -1;
            while (c.numberOfElements() != last_size) {
                last_size = c.numberOfElements();
                tmpset = new Set();
                tmpset.indexedUnion(this.ancestorRelation_, c);
                tmpset.indexedUnion(this.descendentRelation_, c);
                tmpset.intersect(f);
                c.union(tmpset);
            }
            f.difference(c);
            ++this.ccComponents_;
        }
    }

    private boolean fillTopOOrder_() {
        int[] count = new int[this.numNodes_];
        int i = 0;
        while (i < this.numNodes_) {
            this.topOOrder_[i] = this.height_[i];
            ++i;
        }
        return true;
    }

    private int nodeOrder_(Set node_set) {
        int order = this.numNodes_;
        int n = node_set.first();
        while (n != -1) {
            if (this.topOOrder_[n] < order) {
                order = this.topOOrder_[n];
            }
            n = node_set.next();
        }
        return order;
    }

    private void addClan_(ClanTree node, Clan clan) {
        ClanTree newnode = new ClanTree();
        newnode.clan = clan;
        this.addChild_(node, newnode);
    }

    private void addChild_(ClanTree node, ClanTree newnode) {
        ClanTree child;
        Clan clan = newnode.clan;
        int order = clan.order;
        block0: do {
            if (node.firstChild == null) {
                node.firstChild = newnode;
                newnode.parent = node;
                newnode.nextSibling = null;
                return;
            }
            child = node.firstChild;
            while (child != null) {
                if (child.clan.nodes.isSubset(clan.nodes)) {
                    node = child;
                    continue block0;
                }
                child = child.nextSibling;
            }
        } while (child != null);
        if (node.firstChild.clan.order > order) {
            newnode.nextSibling = node.firstChild;
            node.firstChild = newnode;
            newnode.parent = node;
            return;
        }
        ClanTree tmpnode = node.firstChild;
        while (tmpnode.nextSibling != null && tmpnode.nextSibling.clan.order <= order) {
            tmpnode = tmpnode.nextSibling;
        }
        newnode.nextSibling = tmpnode.nextSibling;
        tmpnode.nextSibling = newnode;
        newnode.parent = node;
    }

    private void moveChild_(ClanTree node, ClanTree newnode) {
        Clan clan = newnode.clan;
        int order = clan.order;
        if (node.firstChild == null) {
            node.firstChild = newnode;
            newnode.parent = node;
            newnode.nextSibling = null;
            return;
        }
        if (node.firstChild.clan.order > order) {
            newnode.nextSibling = node.firstChild;
            node.firstChild = newnode;
            newnode.parent = node;
            return;
        }
        ClanTree tmpnode = node.firstChild;
        while (tmpnode.nextSibling != null && tmpnode.nextSibling.clan.order <= order) {
            tmpnode = tmpnode.nextSibling;
        }
        newnode.nextSibling = tmpnode.nextSibling;
        tmpnode.nextSibling = newnode;
        newnode.parent = node;
    }

    private void assignHeights_() {
        Set sources_ = new Set();
        int i = 0;
        while (i < this.numNodes_) {
            if (this.parentRelation_[i].isEmpty()) {
                sources_.includeElement(i);
            }
            ++i;
        }
        this.height_ = new int[this.numNodes_];
        i = 0;
        while (i < this.numNodes_) {
            this.height_[i] = -1;
            ++i;
        }
        i = sources_.first();
        while (i != -1) {
            this.assignHeights_(i, 0);
            i = sources_.next();
        }
    }

    private void assignHeights_(int node, int height) {
        if (height > this.height_[node]) {
            this.height_[node] = height;
            Set children = this.childRelation_[node];
            int i = children.first();
            while (i != -1) {
                this.assignHeights_(i, height + 1);
                i = children.next();
            }
        }
    }

    private void reduce_(ClanTree node) {
        int num_children = 0;
        ClanTree child = node.firstChild;
        while (child != null) {
            ++num_children;
            child = child.nextSibling;
        }
        ClanTree[] children = new ClanTree[num_children];
        child = node.firstChild;
        int i = 0;
        while (child != null) {
            children[i] = child;
            child = child.nextSibling;
            ++i;
        }
        i = 0;
        while (i < num_children) {
            this.reduce_(children[i]);
            ++i;
        }
        int ptype = node.parent != null ? node.parent.clan.clanType : 0;
        int ntype = node.clan.clanType;
        if (node.parent != null && (ptype == ntype || ptype == 4 && ntype == 1 || ptype == 1 && ntype == 4)) {
            ClanTree tmpnode;
            if (ntype == 4) {
                node.parent.clan.clanType = 4;
            }
            while (node.firstChild != null) {
                tmpnode = node.firstChild;
                node.firstChild = node.firstChild.nextSibling;
                this.moveChild_(node.parent, tmpnode);
            }
            if (node.parent.firstChild == node) {
                node.parent.firstChild = node.nextSibling;
            } else {
                tmpnode = node.parent.firstChild;
                while (tmpnode.nextSibling != node) {
                    tmpnode = tmpnode.nextSibling;
                }
                tmpnode.nextSibling = node.nextSibling;
            }
        }
    }

    private void printRelation_(Set[] relation) {
        System.out.println();
        int i = 0;
        while (i < this.numNodes_) {
            int j = 0;
            while (j < this.numNodes_) {
                if (relation[i].isElement(j)) {
                    System.out.print("1 ");
                } else {
                    System.out.print("0 ");
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    private void setId_(ClanTree node) {
        node.clan.id = node.clan.clanType == 5 ? node.clan.nodes.first() : this.id_++;
        ClanTree tmpnode = node.firstChild;
        while (tmpnode != null) {
            this.setId_(tmpnode);
            tmpnode = tmpnode.nextSibling;
        }
    }

    void attributeGraph_() {
        this.bbSizeAttribute_(this.root_, false);
        this.fillLeftSiblings_(this.root_);
        this.bbCornerAttribute_(this.root_);
        this.treeLookup_ = new ClanTree[this.numNodes_];
        this.setLookup_(this.root_);
        this.setHeightInTree_(this.root_, 0);
        this.longEdgeHeuristic_();
        this.treeLookup_ = new ClanTree[this.numNodes_];
        this.setLookup_(this.root_);
        this.bbSizeAttribute_(this.root_, true);
        this.bbCornerAttribute_(this.root_);
        this.realSizes_(this.root_);
        this.angleFix_();
        this.angleFix_();
        Node first_source = this.graph_.getNodeFromIndex(0);
        int i = 0;
        while (i < this.numNodes_) {
            if (this.parentRelation_[i].isEmpty()) {
                first_source = this.graph_.getNodeFromIndex(i);
                break;
            }
            ++i;
        }
        DPoint offset = first_source.getPosition();
        this.copyCorner_(this.root_);
        this.removeBends_();
        DPoint pos = first_source.getPosition();
        offset.x -= pos.x;
        offset.y -= pos.y;
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            pos = tmpnode.getPosition();
            tmpnode.setPosition(pos.x + offset.x, pos.y + offset.y);
            tmpnode = this.graph_.nextNode(tmpnode);
        }
    }

    private void copyCorner_(ClanTree node) {
        if (node == null) {
            return;
        }
        if (node.clan.clanType == 5) {
            DPoint center_position = new DPoint(node.position.x, node.position.y);
            center_position.x += node.size.width / 2.0;
            center_position.y -= node.size.height / 2.0;
            this.graph_.getNodeFromIndex(node.clan.id).setPosition(center_position);
        }
        this.copyCorner_(node.firstChild);
        this.copyCorner_(node.nextSibling);
    }

    private void bbCornerAttribute_(ClanTree node) {
        if (node == null) {
            return;
        }
        if (node.parent == null) {
            node.position.x = 0.0;
            node.position.y = 0.0;
        } else if (node.parent.clan.clanType == 2) {
            node.position.x = node.parent.position.x + (node.parent.size.width - node.size.width) / 2.0;
            node.position.y = node.leftSibling != null ? node.leftSibling.position.y - node.leftSibling.size.height - node.parent.extraheight : node.parent.position.y;
        } else {
            node.position.y = node.parent.position.y - (node.parent.size.height - node.size.height) / 2.0;
            node.position.x = node.leftSibling != null ? node.leftSibling.position.x + node.leftSibling.size.width : node.parent.position.x;
        }
        this.bbCornerAttribute_(node.firstChild);
        this.bbCornerAttribute_(node.nextSibling);
    }

    private void realSizes_(ClanTree node) {
        if (node == null) {
            return;
        }
        if (node.parent != null) {
            if (node.parent.clan.clanType == 2) {
                node.size.width = node.parent.size.width;
                node.position.x = node.parent.position.x;
            } else {
                node.size.height = node.parent.size.height;
                node.position.y = node.parent.position.y;
            }
        }
        this.realSizes_(node.firstChild);
        this.realSizes_(node.nextSibling);
    }

    private void fillLeftSiblings_(ClanTree node) {
        ClanTree tmpnode = node.firstChild;
        ClanTree prevnode = null;
        while (tmpnode != null) {
            tmpnode.leftSibling = prevnode;
            prevnode = tmpnode;
            tmpnode = tmpnode.nextSibling;
        }
        tmpnode = node.firstChild;
        while (tmpnode != null) {
            this.fillLeftSiblings_(tmpnode);
            tmpnode = tmpnode.nextSibling;
        }
    }

    private void bbSizeAttribute_(ClanTree node, boolean repeat) {
        if (node == null) {
            return;
        }
        this.bbSizeAttribute_(node.firstChild, repeat);
        node.extraheight = 0.0;
        node.size = this.bbSize_(node, repeat);
        this.bbSizeAttribute_(node.nextSibling, repeat);
    }

    private DDimension bbSize_(ClanTree node, boolean repeat) {
        DDimension size = new DDimension(0.0, 0.0);
        if (node.clan.clanType == 2) {
            size.width = this.childMax_(node, 1);
            size.height = this.childSum_(node, 2);
        } else if (node.clan.clanType == 5) {
            if (!repeat) {
                size = this.graph_.getNodeFromIndex(node.clan.id).getBoundingBox();
                size.width += this.hSpacing_;
                size.height += this.vSpacing_;
            } else {
                size.width = node.size.width;
                size.height = node.size.height;
            }
        } else {
            size.height = node.size.height < this.childMax_(node, 2) ? this.childMax_(node, 2) : node.size.height;
            this.setExtras_(node, size.height);
            size.width = this.childSum_(node, 1);
        }
        return size;
    }

    private double childMax_(ClanTree node, int axis) {
        double max = 0.0;
        ClanTree child = node.firstChild;
        while (child != null) {
            if (axis == 1 && child.size.width > max || axis == 2 && child.size.height > max) {
                max = axis == 1 ? child.size.width : child.size.height;
            }
            child = child.nextSibling;
        }
        return max;
    }

    private double childSum_(ClanTree node, int axis) {
        double sum = 0.0;
        ClanTree child = node.firstChild;
        while (child != null) {
            sum += axis == 1 ? child.size.width : child.size.height;
            child = child.nextSibling;
        }
        return sum;
    }

    private void setExtras_(ClanTree node, double height) {
        double sum = 0.0;
        ClanTree child = node.firstChild;
        while (child != null) {
            if (child.clan.clanType == 2 && child.size.height < height) {
                int children = 0;
                ClanTree tmp = child.firstChild;
                while (tmp != null) {
                    ++children;
                    tmp = tmp.nextSibling;
                }
                if (children > 1) {
                    child.extraheight = (height - child.size.height) / (double)(children - 1);
                    child.size.height = height;
                }
            }
            child = child.nextSibling;
        }
    }

    private void setPositions_(ClanTree node) {
        node.dummy = false;
        if (node.clan.clanType == 5) {
            int graphnode = node.clan.nodes.first();
            if (graphnode < this.numNodesOriginal_) {
                node.maxx = node.centerx = this.graph_.getNodeFromIndex((int)graphnode).getPosition().x;
                node.minx = node.centerx;
            } else {
                node.dummy = true;
            }
        } else {
            boolean firsttime = true;
            ClanTree tmp = node.firstChild;
            while (tmp != null) {
                this.setPositions_(tmp);
                if (!tmp.dummy) {
                    if (firsttime) {
                        node.minx = tmp.minx;
                        node.maxx = tmp.maxx;
                    } else {
                        if (tmp.minx < node.minx) {
                            node.minx = tmp.minx;
                        }
                        if (tmp.maxx > node.maxx) {
                            node.maxx = tmp.maxx;
                        }
                    }
                    firsttime = false;
                }
                tmp = tmp.nextSibling;
            }
            if (firsttime) {
                node.dummy = true;
            } else {
                node.centerx = (node.minx + node.maxx) / 2.0;
            }
        }
    }

    private void reOrder_(ClanTree node) {
        ClanTree tmpnode;
        if (node.clan.clanType == 5) {
            return;
        }
        int numchildren = 0;
        int numdummies = 0;
        ClanTree tmp = node.firstChild;
        while (tmp != null) {
            this.reOrder_(tmp);
            ++numchildren;
            if (tmp.dummy) {
                ++numdummies;
            }
            tmp = tmp.nextSibling;
        }
        if (numchildren < 2 || node.clan.clanType != 1 && node.clan.clanType != 4) {
            return;
        }
        ClanTree[] children = new ClanTree[numchildren];
        int i = 0;
        tmp = node.firstChild;
        while (tmp != null) {
            children[i++] = tmp;
            tmp = tmp.nextSibling;
        }
        i = 0;
        while (i < numchildren - 1) {
            int j = i + 1;
            while (j < numchildren) {
                if (!children[i].dummy && !children[j].dummy && children[j].centerx < children[i].centerx || !children[i].dummy && children[j].dummy) {
                    tmpnode = children[i];
                    children[i] = children[j];
                    children[j] = tmpnode;
                }
                ++j;
            }
            ++i;
        }
        if (numdummies > 0) {
            int num_left = (numchildren - numdummies) / 2;
            i = 0;
            while (i < num_left) {
                tmpnode = children[i];
                children[i] = children[i + numdummies];
                children[i + numdummies] = tmpnode;
                ++i;
            }
        }
        node.firstChild = children[0];
        i = 0;
        while (i < numchildren - 1) {
            children[i].nextSibling = children[i + 1];
            ++i;
        }
        children[i].nextSibling = null;
    }

    private void setLookup_(ClanTree node) {
        if (node == null) {
            return;
        }
        if (node.clan.clanType == 5) {
            this.treeLookup_[node.clan.id] = node;
        }
        this.setLookup_(node.firstChild);
        this.setLookup_(node.nextSibling);
    }

    private void setHeightInTree_(ClanTree node, int height) {
        if (node == null) {
            return;
        }
        node.heightInTree = height;
        this.setHeightInTree_(node.firstChild, height + 1);
        this.setHeightInTree_(node.nextSibling, height);
    }

    private void longEdgeHeuristic_() {
        int old_numnodes = this.numNodes_;
        int i = 0;
        while (i < old_numnodes) {
            Set children = (Set)this.graph_.children(i).clone();
            int j = children.first();
            while (j != -1) {
                ClanTree nodei = this.treeLookup_[i];
                ClanTree nodej = this.treeLookup_[j];
                int topnode = i;
                int bottomnode = j;
                ClanTree sparenti = nodei.parent;
                ClanTree sparentj = nodej.parent;
                while (sparenti != null && sparenti.clan.clanType != 2) {
                    sparenti = sparenti.parent;
                }
                while (sparentj != null && sparentj.clan.clanType != 2) {
                    sparentj = sparentj.parent;
                }
                if (sparenti != null && sparentj != null) {
                    ClanTree tmpnode;
                    ClanTree right_node;
                    ClanTree left_node;
                    ClanTree lca = nodei;
                    ClanTree lca2 = nodej;
                    while (lca.parent != lca2.parent) {
                        if (lca.heightInTree >= lca2.heightInTree) {
                            lca = lca.parent;
                        }
                        if (lca.heightInTree >= lca2.heightInTree) continue;
                        lca2 = lca2.parent;
                    }
                    while (lca2 != null && lca2 != lca) {
                        lca2 = lca2.nextSibling;
                    }
                    if (lca2 == null) {
                        left_node = nodei;
                        right_node = nodej;
                    } else {
                        left_node = nodej;
                        right_node = nodei;
                    }
                    lca = lca.parent;
                    while (left_node.parent != lca) {
                        if (left_node.parent.clan.clanType == 2) {
                            tmpnode = left_node.nextSibling;
                            while (tmpnode != null) {
                                topnode = this.addDummy_(tmpnode, topnode, bottomnode, nodei, nodej);
                                tmpnode = tmpnode.nextSibling;
                            }
                        }
                        left_node = left_node.parent;
                    }
                    while (right_node.parent != lca) {
                        if (right_node.parent.clan.clanType == 2) {
                            tmpnode = right_node.leftSibling;
                            while (tmpnode != null) {
                                bottomnode = this.addDummy_(tmpnode, topnode, bottomnode, nodei, nodej);
                                tmpnode = tmpnode.leftSibling;
                            }
                        }
                        right_node = right_node.parent;
                    }
                    left_node = left_node.nextSibling;
                    while (left_node != right_node) {
                        topnode = this.addDummy_(left_node, topnode, bottomnode, nodei, nodej);
                        left_node = left_node.nextSibling;
                    }
                }
                j = children.next();
            }
            ++i;
        }
    }

    private void angleFix_() {
        int i = 0;
        while (i < this.numNodes_) {
            ClanTree tnodei = this.treeLookup_[i];
            int k = 0;
            while (k < 2) {
                Set connections = k == 0 ? this.graph_.parents(i) : this.graph_.children(i);
                int j = connections.first();
                while (j != -1) {
                    double y2;
                    double x2;
                    if (j < this.numNodes_) {
                        ClanTree tnodej = this.treeLookup_[j];
                        x2 = tnodej.position.x + tnodej.size.width / 2.0;
                        y2 = tnodej.position.y - tnodej.size.height / 2.0;
                    } else {
                        DPoint pos = this.graph_.getNodeFromIndex(j).getPosition();
                        x2 = pos.x;
                        y2 = pos.y;
                    }
                    double x1 = tnodei.position.x + tnodei.size.width / 2.0;
                    double y1 = tnodei.position.y - tnodei.size.height / 2.0;
                    double dx = Math.abs(x1 - x2);
                    if (dx != 0.0) {
                        double dy = Math.abs(y1 - y2);
                        double dy2 = dy / dx * tnodei.size.width / 2.0;
                        double dist = tnodei.size.height / 2.0;
                        if (!((dist -= dy2) <= this.vSpacing_ / 2.0)) {
                            double offs = dy * dy / (dx * dx + dy * dy);
                            offs = Math.sqrt(offs);
                            offs *= tnodei.size.width / 2.0;
                            if (x2 > x1) {
                                offs = tnodei.size.width - offs;
                            }
                            int newnodeindex = this.graph_.insertNode(true);
                            Node newnode = this.graph_.getNodeFromIndex(newnodeindex);
                            if (k == 0) {
                                this.graph_.removeEdge(j, i);
                                this.graph_.insertEdge(j, newnodeindex);
                                this.graph_.insertEdge(newnodeindex, i);
                                newnode.setPosition(tnodei.position.x + offs, tnodei.position.y - this.vSpacing_ / 4.0);
                            } else {
                                this.graph_.removeEdge(i, j);
                                this.graph_.insertEdge(i, newnodeindex);
                                this.graph_.insertEdge(newnodeindex, j);
                                newnode.setPosition(tnodei.position.x + offs, tnodei.position.y - tnodei.size.height + this.vSpacing_ / 4.0);
                            }
                        }
                    }
                    j = connections.next();
                }
                ++k;
            }
            ++i;
        }
    }

    private void removeBends_() {
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (tmpnode.getIndex() >= this.numNodesOriginal_) {
                boolean needed = false;
                int index = tmpnode.getIndex();
                Node node1 = this.graph_.getNodeFromIndex(this.graph_.parents(index).first());
                Node node2 = this.graph_.getNodeFromIndex(tmpnode.firstChild());
                DPoint p1 = node1.getPosition();
                DPoint p2 = node2.getPosition();
                double dxdy = (p2.x - p1.x) / (p2.y - p1.y);
                double minx = Math.min(p1.x, p2.x);
                double miny = Math.min(p1.y, p2.y);
                double maxx = Math.max(p1.x, p2.x);
                double maxy = Math.max(p1.y, p2.y);
                Node tmpnode2 = this.graph_.firstNode();
                while (tmpnode2 != null) {
                    if (tmpnode2.getIndex() < this.numNodesOriginal_ && tmpnode2 != node1 && tmpnode2 != node2) {
                        DPoint p = tmpnode2.getPosition();
                        DDimension bbx = tmpnode2.getBoundingBox();
                        double x1 = p.x - bbx.width / 2.0 - this.hSpacing_ / 10.0;
                        double x2 = p.x + bbx.width / 2.0 + this.hSpacing_ / 10.0;
                        double y1 = p.y - bbx.height / 2.0 - this.vSpacing_ / 10.0;
                        double y2 = p.y + bbx.height / 2.0 + this.vSpacing_ / 10.0;
                        if (!(x1 <= minx && x2 <= minx || x1 >= maxx && x2 >= maxx || y1 <= miny && y2 <= miny || y1 >= maxy && y2 >= maxy)) {
                            double cross;
                            if (y1 > miny && y1 < maxy && x1 <= (cross = p1.x + dxdy * (y1 - p1.y)) && cross <= x2) {
                                needed = true;
                                break;
                            }
                            if (y2 > miny && y2 < maxy && x1 <= (cross = p1.x + dxdy * (y2 - p1.y)) && cross <= x2) {
                                needed = true;
                                break;
                            }
                            if (x1 > minx && x1 < maxx && y1 <= (cross = p1.y + (x1 - p1.x) / dxdy) && cross <= y2) {
                                needed = true;
                                break;
                            }
                            if (x2 > minx && x2 < maxx && y1 <= (cross = p1.y + (x2 - p1.x) / dxdy) && cross <= y2) {
                                needed = true;
                                break;
                            }
                        }
                    }
                    tmpnode2 = this.graph_.nextNode(tmpnode2);
                }
                if (!needed) {
                    this.graph_.removeEdge(node1.getIndex(), index);
                    this.graph_.removeEdge(index, node2.getIndex());
                    this.graph_.insertEdge(node1.getIndex(), node2.getIndex());
                }
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
    }

    public int addDummy_(ClanTree treenode, int top, int bottom, ClanTree edgesource, ClanTree edgesink) {
        ++this.numNodes_;
        int newnodeindex = this.graph_.insertNode(true);
        this.graph_.removeEdge(top, bottom);
        this.graph_.insertEdge(top, newnodeindex);
        this.graph_.insertEdge(newnodeindex, bottom);
        if (treenode.clan.clanType == 5) {
            ClanTree copy = new ClanTree();
            copy.clan = treenode.clan;
            copy.size.setTo(treenode.size);
            copy.position.move(treenode.position);
            copy.parent = treenode;
            treenode.clan = new Clan(1, new Set(), null, null, 0);
            treenode.firstChild = copy;
        }
        ClanTree tnode = new ClanTree();
        tnode.clan = new Clan(5, new Set(newnodeindex), null, null, 0);
        tnode.clan.id = newnodeindex;
        tnode.parent = treenode;
        double x1 = edgesource.position.x + edgesource.size.width / 2.0;
        double y1 = edgesource.position.y + edgesource.size.height / 2.0;
        double x2 = edgesink.position.x + edgesink.size.width / 2.0;
        double y2 = edgesink.position.y + edgesink.size.height / 2.0;
        double y = treenode.position.y + treenode.size.height / 2.0;
        double idealx = x2 + (x1 - x2) / (y1 - y2) * (y - y2);
        int closest = 0;
        int index = 1;
        double cdist = Math.abs(treenode.position.x - idealx);
        ClanTree tmpnode = treenode.firstChild;
        while (tmpnode != null) {
            if (Math.abs(tmpnode.position.x + tmpnode.size.width - idealx) <= cdist) {
                cdist = Math.abs(tmpnode.position.x + tmpnode.size.width - idealx);
                closest = index;
            }
            ++index;
            tmpnode = tmpnode.nextSibling;
        }
        if (closest == 0) {
            tnode.nextSibling = treenode.firstChild;
            treenode.firstChild = tnode;
        } else {
            tmpnode = treenode.firstChild;
            index = 1;
            while (index < closest) {
                tmpnode = tmpnode.nextSibling;
                ++index;
            }
            tnode.nextSibling = tmpnode.nextSibling;
            tmpnode.nextSibling = tnode;
            tnode.leftSibling = tmpnode;
        }
        if (tnode.nextSibling != null) {
            tnode.nextSibling.leftSibling = tnode;
        }
        tnode.size.setTo(this.hSpacing_, this.vSpacing_);
        Node newnode = this.graph_.getNodeFromIndex(newnodeindex);
        newnode.setBoundingBox(this.hSpacing_, this.vSpacing_);
        return newnodeindex;
    }
}

