/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.api;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Properties;

public final class RfcRegisterInfo
extends RfcAcceptInfo {
    protected String tpname;
    protected String gwhost;
    protected String gwserv;
    protected String saprouter;
    protected boolean snc_mode = false;
    protected byte snc_qop;
    protected String snc_myname;
    protected String snc_lib;
    protected String groupKey;
    public static final byte RFC_SNC_QOP_INVALID = 0;
    public static final byte RFC_SNC_QOP_OPEN = 1;
    public static final byte RFC_SNC_QOP_INTEGRITY = 2;
    public static final byte RFC_SNC_QOP_PRIVACY = 3;
    public static final byte RFC_SNC_QOP_DEFAULT = 8;
    public static final byte RFC_SNC_QOP_MAX = 9;

    public String getDestination() {
        return new String(this.tpname);
    }

    public void checkParameters() throws RfcException {
        if (this.tpname == null) {
            throw new RfcException(19, "Required parameter programID ('progid') is missing\nConnection parameters: " + this.toParametersString(), 101, 0L, true);
        }
        if (this.gwhost == null) {
            throw new RfcException(19, "Required parameter gateway host ('gwhost') is missing\nConnection parameters: " + this.toParametersString(), 101, 0L, true);
        }
        if (this.gwserv == null) {
            throw new RfcException(19, "Required parameter gateway service ('gwserv') is missing\nConnection parameters: " + this.toParametersString(), 101, 0L, true);
        }
        boolean throwException = false;
        int len = this.gwserv.length();
        char c = '\u0000';
        if (len == 4) {
            for (int i = 0; i < len; ++i) {
                c = this.gwserv.charAt(i);
                if (c >= '0' && c <= '9') continue;
                throwException = true;
                break;
            }
        } else if (this.gwserv.startsWith("sapgw")) {
            if (this.gwserv.equals("sapgw$$")) {
                String sysnr = JCoRuntime.getProfileParameter("SAPSYSTEM");
                if (sysnr == null) {
                    throw new RfcException(19, "'sapgw$$' as value for 'gwserv' requires SAPSYSTEM to be set in environment\nConnection parameters: " + this.toParametersString(), 101, 0L, true);
                }
                if (Environment.inJStartup()) {
                    boolean isDoubleStack;
                    String instanceName = JCoRuntime.getProfileParameter("INSTANCE_NAME");
                    boolean bl = isDoubleStack = instanceName != null && instanceName.length() > 0 && instanceName.charAt(0) == 'D';
                    if (!isDoubleStack) {
                        throw new RfcException(19, "'sapgw$$' as value for 'gwserv' is only valid in a double stack environment\nConnection parameters: " + this.toParametersString(), 101, 0L, true);
                    }
                }
                this.gwserv = "sapgw" + sysnr;
            } else {
                if (len < 7) {
                    throwException = true;
                }
                for (int i = 5; i < len; ++i) {
                    c = this.gwserv.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    throwException = true;
                    break;
                }
            }
        }
        if (throwException) {
            throw new RfcException(19, "Parameter gateway service ('gwserv') needs to be of format #### or sapgw## (# is a digit)\nConnection parameters: " + this.toParametersString(), 101, 0L, true);
        }
    }

    public String toParametersString() {
        FastStringBuffer buffer = new FastStringBuffer(128);
        if (this.tpname != null) {
            buffer.append("TPNAME=").append(this.tpname);
        }
        if (this.gwhost != null) {
            buffer.append(" GWHOST=").append(this.gwhost);
        }
        if (this.gwserv != null) {
            buffer.append(" GWSERV=").append(this.gwserv);
        }
        if (this.saprouter != null) {
            buffer.append(" SAPROUTER='").append(this.saprouter).append('\'');
        }
        if (this.snc_mode) {
            buffer.append(" SNC_MODE=1 SNC_MYNAME='").append(this.snc_myname).append('\'');
            if (this.snc_qop != -1) {
                buffer.append(" SNC_QOP=").append(this.snc_qop);
            }
        }
        return buffer.toString();
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer();
        buf.append(" -g\"").append(this.gwhost).append("\" -x\"").append(this.gwserv);
        buf.append("\" -a\"").append(this.tpname).append('\"');
        if (this.saprouter != null) {
            buf.append(" -r\"").append(this.saprouter).append('\"');
        }
        if (this.snc_mode) {
            buf.append(" -S\"").append(this.snc_myname).append('\"');
            if (this.snc_lib != null) {
                buf.append(" -L\"").append(this.snc_lib).append('\"');
            }
            if (this.snc_qop != -1) {
                buf.append(" -Q\"").append(Byte.toString(this.snc_qop)).append('\"');
            }
        }
        if (this.rfc_trace) {
            buf.append(" -t");
        }
        return buf.toString();
    }

    public String toStringTrace(long handle) {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("*> RfcRegisterProgram ... \n");
        buffer.append(this.tpname == null ? SP + "Server Program ID     = <null>\n" : SP + "Server Program ID     = " + this.tpname + '\n');
        buffer.append(this.gwhost == null ? SP + "Host name of Gateway  = <null> \n" : SP + "Host name of Gateway  = " + this.gwhost + '\n');
        buffer.append(this.gwserv == null ? SP + "Service of Gateway    = <null>\n" : SP + "Service of Gateway    = " + this.gwserv + '\n');
        buffer.append(this.rfc_trace ? SP + "RFC-Trace             = ON\n" : SP + "RFC-Trace             = OFF\n");
        if (this.saprouter != null) {
            buffer.append(SP).append("SAPRouterstring       = ").append(this.saprouter).append("\n");
        }
        buffer.append(this.snc_mode ? SP + "SNC                   = ON\n" : "");
        buffer.append(this.snc_myname != null ? SP + "SNC Own Name          = " + this.snc_myname + '\n' : "");
        buffer.append(this.snc_lib != null ? SP + "SNC Library Name      = " + this.snc_lib + '\n' : "");
        if (handle == 0L) {
            buffer.append("<* Error: RfcRegisterProgram failed !!!\n");
        } else {
            buffer.append(SP + "RFC Handle            = " + handle + "\n");
            buffer.append("<* RfcRegisterProgram ended successfully *>\n");
        }
        return buffer.toString();
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        this.groupKey = JCoRuntime.findProperty("jco.server.group_key", props);
        this.tpname = JCoRuntime.findProperty("jco.server.progid", props);
        this.gwhost = JCoRuntime.findProperty("jco.server.gwhost", props);
        this.gwserv = JCoRuntime.findProperty("jco.server.gwserv", props);
        this.saprouter = JCoRuntime.findProperty("jco.server.saprouter", props);
        this.snc_mode = JCoRuntime.toBoolean(JCoRuntime.findProperty("jco.server.snc_mode", props));
        if (this.snc_mode) {
            this.snc_myname = JCoRuntime.findProperty("jco.server.snc_myname", props);
            String qop = JCoRuntime.findProperty("jco.server.snc_qop", props);
            try {
                this.snc_qop = Byte.parseByte(qop);
            }
            catch (Exception e) {
                this.snc_qop = (byte)8;
            }
            this.snc_lib = JCoRuntime.findProperty("jco.server.snc_lib", props);
        }
    }

    public String getSAPRouter() {
        return this.saprouter;
    }

    public String getGatewayHost() {
        return this.gwhost;
    }

    public String getGatewayService() {
        return this.gwserv;
    }

    public String getProgramID() {
        return this.tpname;
    }

    public boolean usesSNC() {
        return this.snc_mode;
    }

    public String getSNCLibrary() {
        return this.snc_lib;
    }

    public String getSNCMyName() {
        return this.snc_myname;
    }

    public byte getSNCQuality() {
        return this.snc_qop;
    }

    public int getConnectionType() {
        return 12;
    }

    public char getOwnType() {
        return 'R';
    }

    public String getGroupKey() {
        return this.groupKey;
    }
}

