/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import java.util.HashMap;
import java.util.Locale;

public abstract class Language {
    static HashMap<String, MapEntry> t002 = new HashMap(101);

    public static String getSAPLanguage(String isoLanguage) {
        if (isoLanguage == null) {
            return null;
        }
        MapEntry entry = t002.get(isoLanguage);
        if (entry != null) {
            return entry.sapLanguage;
        }
        return null;
    }

    public static String getISOLanguage(String sapLanguage) {
        if (sapLanguage == null) {
            return null;
        }
        MapEntry entry = t002.get(sapLanguage);
        if (entry != null) {
            return entry.isoLanguage;
        }
        return null;
    }

    static {
        new MapEntry("0", "SR", "Serbian");
        new MapEntry("1", "ZH", "Chinese");
        new MapEntry("2", "TH", "Thai");
        new MapEntry("3", "KO", "Korean");
        new MapEntry("4", "RO", "Romanian");
        new MapEntry("5", "SL", "Slovene");
        new MapEntry("6", "HR", "Croatian");
        new MapEntry("7", "MS", "Malayan");
        new MapEntry("8", "UK", "Ukrainian");
        new MapEntry("9", "ET", "Estonian");
        new MapEntry("A", "AR", "Arabic");
        new MapEntry("B", "HE", "Hebrew");
        new MapEntry("C", "CS", "Czech");
        new MapEntry("D", "DE", "German");
        new MapEntry("E", "EN", "English");
        new MapEntry("F", "FR", "French");
        new MapEntry("G", "EL", "Greek");
        new MapEntry("H", "HU", "Hungarian");
        new MapEntry("I", "IT", "Italian");
        new MapEntry("J", "JA", "Japanese");
        new MapEntry("K", "DA", "Danish");
        new MapEntry("L", "PL", "Polish");
        new MapEntry("M", "ZF", "Chinese trad.");
        new MapEntry("N", "NL", "Dutch");
        new MapEntry("O", "NO", "Norwegian");
        new MapEntry("P", "PT", "Portuguese");
        new MapEntry("Q", "SK", "Slovakian");
        new MapEntry("R", "RU", "Russian");
        new MapEntry("S", "ES", "Spanish");
        new MapEntry("T", "TR", "Turkish");
        new MapEntry("U", "FI", "Finnish");
        new MapEntry("V", "SV", "Swedish");
        new MapEntry("W", "BG", "Bulgarian");
        new MapEntry("X", "LT", "Lithuanian");
        new MapEntry("Y", "LV", "Latvian");
        new MapEntry("Z", "Z1", "Reserved for Customer");
        new MapEntry("a", "AF", "Afrikaans");
        new MapEntry("b", "IS", "Icelandic");
        new MapEntry("c", "CA", "Catalan");
        new MapEntry("d", "SH", "Serbo-Croatian");
        new MapEntry("i", "ID", "Indonesian");
    }

    protected static class MapEntry {
        String sapLanguage;
        String isoLanguage;
        String description;

        protected MapEntry(String sapLanguage, String isoLanguage, String description) {
            this.sapLanguage = sapLanguage;
            this.isoLanguage = isoLanguage;
            this.description = description;
            t002.put(sapLanguage, this);
            t002.put(isoLanguage, this);
            t002.put(isoLanguage.toLowerCase(Locale.ENGLISH), this);
            t002.put("" + Character.toLowerCase(isoLanguage.charAt(0)) + isoLanguage.charAt(1), this);
            t002.put("" + isoLanguage.charAt(0) + Character.toLowerCase(isoLanguage.charAt(1)), this);
        }
    }
}

