/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoParameterFieldIterator;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultParameterFieldIterator;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.FastStringBuffer;
import java.util.ArrayList;
import java.util.Date;

public class DefaultParameterList
extends AbstractRecord
implements JCoParameterList {
    static final long serialVersionUID = 3000120080918L;
    protected static final int INACTIVE_PARAMETER = 2;
    protected static final int HIDDEN_PARAMETER = 4;
    protected static final int SKIP_PARAMETER = 8;

    DefaultParameterList(JCoListMetaData metaData) {
        super(1, metaData);
        int i = 0;
        while (i < this.metaData.numFields) {
            int n = i++;
            this.flags[n] = (byte)(this.flags[n] | 1);
        }
    }

    protected String getDefaultValue(int index) {
        String defval = null;
        DefaultListMetaData md = (DefaultListMetaData)this.metaData;
        if (md.defaults.length > 0 && md.defaults[index] != null) {
            defval = md.defaults[index];
            if (defval.equalsIgnoreCase("SY-DATUM")) {
                defval = daterfc.format(new Date());
            } else if (defval.equalsIgnoreCase("SY-LANGU")) {
                defval = "E";
            } else if (defval.equalsIgnoreCase("SPACE")) {
                defval = null;
            } else if (defval.indexOf("'") >= 0 && defval.lastIndexOf("'") > 0) {
                int i1 = defval.indexOf("'") + 1;
                int i2 = defval.lastIndexOf("'");
                defval = i1 > 0 && i2 > i1 ? defval.substring(i1, i2) : null;
            }
        }
        return defval;
    }

    public boolean isActive(int index) {
        return (this.flags[index] & 2) == 0;
    }

    public boolean isActive(String field_name) {
        return (this.flags[this.metaData.indexOf(field_name)] & 2) == 0;
    }

    public void setActive(int index, boolean active) {
        if (active) {
            int n = index;
            this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFD);
        } else {
            int n = index;
            this.flags[n] = (byte)(this.flags[n] | 2);
        }
    }

    public void setActive(String name, boolean active) {
        this.setActive(this.metaData.indexOf(name), active);
    }

    public DefaultListMetaData getListMetaData() {
        return (DefaultListMetaData)this.metaData;
    }

    protected String dumpContent() {
        byte itype;
        int index;
        Object o;
        FastStringBuffer buf = new FastStringBuffer();
        AbstractRecord r = null;
        AbstractMetaData md = null;
        ArrayList<Object> mdsToDump = new ArrayList<Object>();
        mdsToDump.add(this);
        while (!mdsToDump.isEmpty()) {
            o = mdsToDump.remove(0);
            if (o instanceof AbstractRecord) {
                r = (AbstractRecord)o;
                md = r.metaData;
            } else if (o instanceof AbstractMetaData) {
                r = null;
                md = (AbstractMetaData)o;
            } else {
                buf.append("warning unexpected class ").append(o.getClass().getName()).append(JCoRuntime.CRLF);
                continue;
            }
            buf.append(md.getName()).append(JCoRuntime.CRLF);
            for (index = 0; index < md.getFieldCount(); ++index) {
                int c;
                buf.append("   ");
                String str = md.name[index];
                buf.append(str);
                for (c = str.length(); c < 32; ++c) {
                    buf.append(' ');
                }
                str = "-";
                o = md.getRecordTypeName(index);
                if (o != null) {
                    str = (String)o;
                }
                buf.append(str);
                for (c = str.length(); c < 32; ++c) {
                    buf.append(' ');
                }
                str = md.getTypeAsString(index);
                buf.append(str);
                for (c = str.length(); c < 10; ++c) {
                    buf.append(' ');
                }
                str = String.valueOf(md.boffset[index]);
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                str = String.valueOf(md.blength[index]);
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                if (md instanceof JCoRecordMetaData) {
                    str = String.valueOf(((JCoRecordMetaData)((Object)md)).getByteOffset(index));
                    buf.append(str);
                    for (c = str.length(); c < 8; ++c) {
                        buf.append(' ');
                    }
                }
                str = String.valueOf(md.getByteLength(index));
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                if (md instanceof JCoRecordMetaData) {
                    str = String.valueOf(((JCoRecordMetaData)((Object)md)).getUnicodeByteOffset(index));
                    buf.append(str);
                    for (c = str.length(); c < 8; ++c) {
                        buf.append(' ');
                    }
                }
                str = String.valueOf(md.getUnicodeByteLength(index));
                buf.append(str);
                for (c = str.length(); c < 8; ++c) {
                    buf.append(' ');
                }
                if (md instanceof JCoListMetaData) {
                    if (((JCoListMetaData)((Object)md)).isImport(index)) {
                        buf.append('I');
                    }
                    if (((JCoListMetaData)((Object)md)).isChanging(index)) {
                        buf.append('C');
                    }
                    if (((JCoListMetaData)((Object)md)).isExport(index)) {
                        buf.append('E');
                    }
                    if (((JCoListMetaData)((Object)md)).isOptional(index)) {
                        buf.append('O');
                    }
                    if (r != null && r instanceof DefaultParameterList) {
                        if (((DefaultParameterList)r).isActive(index)) {
                            buf.append('A');
                        }
                        if ((((DefaultParameterList)r).flags[index] & 1) != 0) {
                            buf.append('u');
                        }
                        if ((((DefaultParameterList)r).flags[index] & 8) != 0) {
                            buf.append('s');
                        }
                    }
                }
                buf.append(JCoRuntime.CRLF);
                itype = md.type[index];
                if (itype != 17 && itype != 99) continue;
                if (md.getRecordMetaData(index) != null) {
                    mdsToDump.add(md.getRecordMetaData(index));
                    continue;
                }
                if (r == null || r.getValue(index) == null) continue;
                mdsToDump.add(r.getValue(index));
            }
        }
        if (this.metaData.numOdata != this.metaData.numFields) {
            buf.append("content:").append(JCoRuntime.CRLF).append(Trace.dumpContent(this.data, Trace.isOn(16), Trace.isOn(32) ? this.data.length : Math.min(1000, this.data.length)));
        }
        for (index = 0; index < this.metaData.numFields; ++index) {
            itype = this.metaData.type[index];
            if (itype != 29 && itype != 30 && itype != 17 && itype != 99) continue;
            o = this.odata[this.metaData.oindex[index]];
            buf.append(this.metaData.name[index]).append(": ");
            if (o == null) {
                buf.append("null");
            } else if (itype == 29) {
                char[] ca = ((String)o).toCharArray();
                buf.append(JCoRuntime.CRLF).append(Trace.dumpContent(ca, Trace.isOn(16), Trace.isOn(32) ? ca.length : Math.min(1000, ca.length)));
            } else if (itype == 30) {
                byte[] ba = (byte[])o;
                buf.append(JCoRuntime.CRLF).append(Trace.dumpContent(ba, Trace.isOn(32) ? ba.length : Math.min(1000, ba.length)));
            } else {
                r = (AbstractRecord)o;
                boolean isFlat = true;
                for (int rIdx = 0; rIdx < this.getFieldCount(); ++rIdx) {
                    int rType = this.metaData.getType(rIdx);
                    if (rType != 29 && rType != 30 && rType != 17 && rType != 99) continue;
                    isFlat = false;
                    break;
                }
                if (isFlat) {
                    if (itype == 17) {
                        buf.append(JCoRuntime.CRLF).append(Trace.dumpContent(r.data, Trace.isOn(16), Trace.isOn(32) ? r.data.length : Math.min(1000, r.data.length)));
                    } else {
                        buf.append(r.numRows).append(" row(s)").append(JCoRuntime.CRLF);
                        int rowsToDump = Trace.isOn(32) ? r.numRows : Math.min(5, r.numRows);
                        for (int i = 0; i < rowsToDump; ++i) {
                            buf.append("row ").append(i).append(JCoRuntime.CRLF);
                            buf.append(Trace.dumpContent(r.tableDataRows[i], Trace.isOn(16), Trace.isOn(32) ? r.tableDataRows[i].length : Math.min(1000, r.tableDataRows[i].length)));
                        }
                    }
                } else {
                    char[] ca = r.toXML().toCharArray();
                    buf.append(JCoRuntime.CRLF).append(Trace.dumpContent(ca, Trace.isOn(16), Trace.isOn(32) ? ca.length : Math.min(1000, ca.length)));
                }
            }
            buf.append(JCoRuntime.CRLF);
        }
        return buf.toString();
    }

    public JCoParameterFieldIterator getParameterFieldIterator() {
        return new DefaultParameterFieldIterator(this);
    }
}

