/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DynamicRecordMetaData;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.Trace;

public class CustomRepository
extends AbapRepository
implements JCoCustomRepository {
    private boolean useRepositoryConnections = true;
    private Context ctx;

    protected CustomRepository(String name) {
        super(name);
    }

    public void addFunctionTemplateToCache(JCoFunctionTemplate meta) {
        this.addFunctionTemplate(meta);
    }

    public void addRecordMetaDataToCache(JCoRecordMetaData meta) {
        this.addRecordMetaData(meta);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDestination(JCoDestination abapDestination) throws JCoException, JCoRuntimeException {
        block8: {
            if (this.destinationList.getCurrentDestination() != null) {
                throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Repository destination is already set. The repository destination can not be changed");
            }
            if (abapDestination == null || !(abapDestination instanceof InternalDestination)) {
                String string;
                if (abapDestination == null) {
                    string = "Destination equals null is not allowed.";
                    throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", string);
                }
                string = "Only JCoDestintations created by JCo are supported. Use JCoDestinationManager,getDestination().";
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", string);
            }
            ClientConnection client = null;
            try {
                client = ConnectionManager.getConnectionManager().getClient((InternalDestination)abapDestination, this.useRepositoryConnections);
                this.repository_version = client.getAttributes().getPartnerReleaseNumber();
                Object var5_3 = null;
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (client == null) throw throwable;
                ConnectionManager.getConnectionManager().releaseClient(client);
                throw throwable;
            }
            ConnectionManager.getConnectionManager().releaseClient(client);
        }
        if (this.repository_version == 0) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only destinations to an ABAP instance are allowed. The specified system has the version 0");
        }
        this.destinationList.addDestination((InternalDestination)abapDestination);
        this.containsUnicodeInfo = this.repository_version > 463;
    }

    public void setQueryMode(JCoCustomRepository.QueryMode queryMode) {
        switch (queryMode) {
            case ALL_AVAILABLE_LAYOUTS: {
                if (this.destinationList.getCurrentDestination() == null) {
                    throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Destination is not defined yet. Use setDestination() before.");
                }
                this.containsUnicodeInfo = this.getVersion() > 463;
                break;
            }
            case NON_UNICODE_LAYOUT_ONLY: {
                if (this.destinationList.getCurrentDestination() == null) {
                    throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Destination is not defined yet. Use setDestination() before.");
                }
                this.containsUnicodeInfo = false;
                break;
            }
            case DISABLE_REPOSITORY_POOL: {
                this.useRepositoryConnections = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConnection getClient(InternalDestination destination, boolean useRepositoryPool) throws JCoException {
        if (this.useRepositoryConnections) {
            return super.getClient(destination, useRepositoryPool);
        }
        Object object = this.semaphor;
        synchronized (object) {
            if (this.ctx != null) {
                throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "This instance of the custom repository is currently used. Becase DISABLE_REPOSITORY_POOL mode is set only one query may be executed.");
            }
            this.ctx = JCoRuntimeFactory.getRuntime().getRuntimeContext(false, null);
            if (Trace.isOn(64)) {
                StringBuilder buf = new StringBuilder("[JCoAPI] destination ").append(this.name).append(" destinationID=").append(destination.getDestinationID()).append(" executes repository call sessionID=").append(this.ctx.sessionID).append(", threadID=0x").append(Long.toHexString(Thread.currentThread().getId()));
                Trace.fireTrace(64, buf.toString());
            }
            ClientConnection client = this.ctx.getConnection(destination);
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseClient(ClientConnection client, InternalDestination destination) throws JCoException {
        if (this.useRepositoryConnections) {
            super.releaseClient(client, destination);
        } else {
            try {
                this.ctx.releaseConnection(destination, client);
                Object var4_3 = null;
                this.ctx = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.ctx = null;
                throw throwable;
            }
        }
    }

    DefaultClassMetaData queryClassMetaData(String className, InternalDestination destForQueries, boolean useRepositoryPool) throws JCoException {
        if (destForQueries == null) {
            return null;
        }
        return super.queryClassMetaData(className, destForQueries, useRepositoryPool);
    }

    JCoFunctionTemplate queryFunctionTemplate(String functionName, InternalDestination destForQueries, boolean useRepositoryPool) throws JCoException {
        if (destForQueries == null) {
            return null;
        }
        return super.queryFunctionTemplate(functionName, destForQueries, useRepositoryPool);
    }

    DefaultRecordMetaData queryRecordMetaData(String recordName, InternalDestination destForQueries, boolean useRepositoryPool) throws JCoException {
        if (destForQueries == null) {
            return null;
        }
        return super.queryRecordMetaData(recordName, destForQueries, useRepositoryPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolveDynamicRecordMetaData(DynamicRecordMetaData meta) throws JCoException {
        block7: {
            this.lastAccessTimestamp = System.currentTimeMillis();
            InternalDestination destForQueries = (InternalDestination)this.destinationList.getCurrentDestination();
            if (destForQueries == null) return;
            JCoFunction ddGetClidepStruct = this.getDdGetClidepStructTemplate().getFunction();
            ClientConnection client = this.getClient(destForQueries, this.useRepositoryConnections);
            try {
                try {
                    ddGetClidepStruct.getImportParameterList().setValue(0, meta.getParentStruct());
                    client.execute(ddGetClidepStruct, (JCoRepository)this);
                    JCoTable dfies_tab = ddGetClidepStruct.getExportParameterList().getTable("NTAB_FIELDS");
                    JCoTable lines_descr = null;
                    DefaultRecordMetaData rmd = new DefaultRecordMetaData(meta.getName());
                    this.constructMetaData(client, this.getVersion(), dfies_tab, null, lines_descr, lines_descr, rmd, null, 0, 0, 1);
                    meta.merge(rmd);
                    meta.comment = meta.comment + "generic box " + destForQueries.getClient() + "/" + destForQueries.getAttributes().getSystemID();
                    meta.allTypesResolved = true;
                    this.addRecordMetaData(meta);
                }
                catch (AbapException aex) {
                    if (!"NO_STRUC_IN_THIS_CLIENT".equals(aex.getKey())) throw aex;
                    meta.allTypesResolved = true;
                    Object var9_10 = null;
                    if (client != null) {
                        this.releaseClient(client, destForQueries);
                    }
                    this.lastRemoteQueryTimestamp = System.currentTimeMillis();
                    return;
                }
                Object var9_9 = null;
                if (client == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (client != null) {
                    this.releaseClient(client, destForQueries);
                }
                this.lastRemoteQueryTimestamp = System.currentTimeMillis();
                throw throwable;
            }
            this.releaseClient(client, destForQueries);
        }
        this.lastRemoteQueryTimestamp = System.currentTimeMillis();
    }
}

