/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.Trace;
import java.util.ArrayList;
import java.util.Iterator;

public class AutoJobRunner
implements Runnable {
    static long MAX_EXECUTION_PERIOD = Long.MAX_VALUE;
    private ArrayList<AutoJob> jobs = new ArrayList(5);
    private Thread ownThread = null;
    private boolean alive = true;
    private long executionPeriode = MAX_EXECUTION_PERIOD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        AutoJobRunner autoJobRunner = this;
        synchronized (autoJobRunner) {
            if (this.ownThread == null) {
                this.ownThread = new Thread((Runnable)this, "JCoTimeoutChecker");
                this.ownThread.setDaemon(true);
                this.ownThread.start();
            }
        }
    }

    void stop() {
        this.alive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addJob(AutoJob job) {
        boolean performAdd = true;
        ArrayList<AutoJob> arrayList = this.jobs;
        synchronized (arrayList) {
            long jobExecutionPeriode;
            if (this.jobs.contains(job)) {
                performAdd = false;
            }
            if (performAdd) {
                this.jobs.add(job);
            }
            if (this.executionPeriode > (jobExecutionPeriode = job.getExecutePeriode())) {
                this.executionPeriode = jobExecutionPeriode;
                this.jobs.notify();
            }
            if (performAdd && this.jobs.size() == 1) {
                this.jobs.notify();
            }
        }
        return performAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        ArrayList<AutoJob> arrayList = this.jobs;
        synchronized (arrayList) {
            this.jobs.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeJob(AutoJob job) {
        ArrayList<AutoJob> arrayList = this.jobs;
        synchronized (arrayList) {
            return this.jobs.remove(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.alive) {
            ArrayList<AutoJob> arrayList = this.jobs;
            synchronized (arrayList) {
                this.executionPeriode = MAX_EXECUTION_PERIOD;
                long currentTime = System.currentTimeMillis();
                Iterator<AutoJob> it = this.jobs.iterator();
                while (it.hasNext()) {
                    try {
                        AutoJob aJob = it.next();
                        long jobExecutionPeriode = aJob.getExecutePeriode();
                        if (currentTime > aJob.getLastExecutionTime() + jobExecutionPeriode) {
                            aJob.execute();
                        }
                        if (this.executionPeriode <= jobExecutionPeriode) continue;
                        this.executionPeriode = jobExecutionPeriode;
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(4, true)) continue;
                        Trace.fireTrace(4, "[JCoAPI] Exception in background thread", th);
                    }
                }
            }
            try {
                arrayList = this.jobs;
                synchronized (arrayList) {
                    if (this.jobs.isEmpty()) {
                        this.jobs.wait();
                    } else {
                        this.jobs.wait(this.executionPeriode);
                    }
                }
            }
            catch (Exception e) {
                Trace.fireTraceCritical("[JCoAPI] unexpected exception in wait", e);
            }
        }
    }

    static interface AutoJob {
        public void execute() throws Exception;

        public long getExecutePeriode();

        public long getLastExecutionTime();
    }
}

