/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util.scanner;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.commontemplate.util.scanner.Accepter;
import org.commontemplate.util.scanner.AllAccepter;
import org.commontemplate.util.scanner.ArrayStateMap;
import org.commontemplate.util.scanner.BackAccepter;
import org.commontemplate.util.scanner.BackSpaceAccepter;
import org.commontemplate.util.scanner.CharStream;
import org.commontemplate.util.scanner.DFAScanner;
import org.commontemplate.util.scanner.ListTokenReceiver;
import org.commontemplate.util.scanner.MatchingTypeResolver;
import org.commontemplate.util.scanner.ReaderCharStream;
import org.commontemplate.util.scanner.Scanner;
import org.commontemplate.util.scanner.ScanningException;
import org.commontemplate.util.scanner.StringCharStream;

public class Tokenizer {
    public static final int END = -10;
    public static final int BREAK = -11;
    public static final int BACK = -12;
    public static final int BACK_SPACE = -13;
    public static final int ERROR = -20;
    private static final Map accepters = Tokenizer.initAccepters();
    private final Scanner scanner;

    private static final Map initAccepters() {
        HashMap<Integer, Accepter> hashMap = new HashMap<Integer, Accepter>();
        hashMap.put(new Integer(-10), new AllAccepter());
        hashMap.put(new Integer(-11), new BackAccepter(1));
        hashMap.put(new Integer(-12), new BackAccepter(2));
        hashMap.put(new Integer(-13), new BackSpaceAccepter(1));
        return Collections.unmodifiableMap(hashMap);
    }

    public Tokenizer(String[] stringArray, int[][] nArray) {
        if (stringArray.length != nArray[0].length - 1) {
            throw new IllegalArgumentException("\u7c7b\u578b\u7684\u4e2a\u6570\u4e0e\u72b6\u6001\u5217\u4e0d\u914d\u7f6e\uff01\u72b6\u6001\u5217\u7684\u4e2a\u6570\u5e94\u7b49\u4e8e\u7c7b\u578b\u4e2a\u6570+1\uff0c\u591a\u51fa\u7684\u4e00\u5217\u72b6\u6001\u7528\u4e8e\u5904\u7406\u5176\u5b83\u672a\u5b9a\u4e49\u7c7b\u578b\u3002");
        }
        this.scanner = new DFAScanner(new MatchingTypeResolver(stringArray), new ArrayStateMap(nArray), accepters);
    }

    public List split(CharStream charStream) throws IOException, ScanningException {
        ListTokenReceiver listTokenReceiver = new ListTokenReceiver();
        this.scanner.scan(charStream, listTokenReceiver);
        return listTokenReceiver.getTokens();
    }

    public List split(Reader reader) throws IOException, ScanningException {
        return this.split(new ReaderCharStream(reader));
    }

    public List split(String string) throws IOException, ScanningException {
        return this.split(new StringCharStream(string));
    }
}

