/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util.scanner;

import org.commontemplate.util.Location;
import org.commontemplate.util.Offset;
import org.commontemplate.util.Position;

public final class Token {
    public static final int UNKOWN_TYPE = -1;
    private final String message;
    private final Offset offset;
    private final Position beginPosition;
    private final int type;
    private Position endPosition;
    private Location location;
    private String toString;

    public Token(String string, Offset offset) {
        this(string, offset, -1);
    }

    public Token(String string, Offset offset, int n) {
        this.message = string;
        this.offset = offset;
        this.beginPosition = offset.getPosition();
        this.type = n;
    }

    public Token(String string, long l, Position position) {
        this(string, new Offset(l, position), -1);
    }

    public Token(String string, long l, Position position, int n) {
        this(string, new Offset(l, position), n);
    }

    public String getMessage() {
        return this.message;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public int getType() {
        return this.type;
    }

    public Position getBeginPosition() {
        return this.beginPosition;
    }

    public Position getEndPosition() {
        if (this.endPosition == null) {
            int n = this.countLines(this.message);
            int n2 = this.message.lastIndexOf(10);
            int n3 = 0;
            n3 = n2 == -1 ? this.beginPosition.getColumn() + this.message.length() : this.message.length() - n2 - 1;
            int n4 = this.beginPosition.getRow() + n;
            this.endPosition = new Position(n4, n3);
        }
        return this.endPosition;
    }

    public Location getLocation() {
        if (this.location == null) {
            this.location = new Location(this.getBeginPosition(), this.getEndPosition());
        }
        return this.location;
    }

    public Token addToken(Token token) {
        return new Token(this.message + token.message, this.offset);
    }

    public Token subToken(int n, int n2) {
        if (n >= n2) {
            throw new IllegalStateException(n + " >= " + n2 + ", \u8d77\u59cb\u4f4d\u7f6e\u5fc5\u9700\u5c0f\u4e8e\u7ed3\u675f\u4f4d\u7f6e!");
        }
        if (n < 0 || n > this.message.length() || n2 > this.message.length()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        String string = this.message.substring(n, n2);
        int n3 = this.beginPosition.getRow();
        int n4 = this.beginPosition.getColumn();
        if (n > 0) {
            n3 += this.countLines(this.message.substring(0, n));
            int n5 = string.lastIndexOf(10);
            n4 = n5 == -1 ? (n4 += n) : string.length() - n5 - 1;
        }
        return new Token(string, this.offset.getLength() + (long)n, new Position(n3, n4));
    }

    private int countLines(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.message);
            stringBuffer.append(this.getLocation().toString());
            this.toString = stringBuffer.toString();
        }
        return this.toString;
    }
}

