/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util.scanner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.commontemplate.util.Assert;
import org.commontemplate.util.scanner.TypeResolver;

public class MatchingTypeResolver
implements TypeResolver {
    public static final char DISCRETE_SEPARATOR = '|';
    public static final char SERIATE_SEPARATOR = '-';
    private static final char NULL_CHAR = '\u0000';
    private final Map types = new HashMap();
    private final Set scopes = new HashSet();
    private final int otherType;

    public MatchingTypeResolver(String[] stringArray) {
        this.otherType = stringArray.length;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            boolean bl = false;
            boolean bl2 = false;
            char c = '\u0000';
            int n2 = string.length();
            for (int j = 0; j < n2; ++j) {
                char c2 = string.charAt(j);
                if (bl) {
                    if (c2 == '-') {
                        Assert.assertFalse(bl2, " - \u5206\u5272\u7b26\u4f4d\u7f6e\u4e0d\u6b63\u786e, \u540e\u9762\u5e94\u8be5\u6709\u4e00\u5b57\u7b26!");
                        bl2 = true;
                    } else if (c2 == '|') {
                        Assert.assertTrue(c != '\u0000', "\u542b\u6709\u65e0\u7528\u7684 | \u5206\u5272\u7b26");
                        this.types.put(new Character(c), new Integer(i));
                        c = '\u0000';
                    } else {
                        Assert.fail("\u5b57\u7b26\u4e4b\u95f4\u5e94\u8be5\u6709\u5206\u5272\u7b26\u4e4b\u95f4!");
                    }
                } else if (bl2) {
                    Assert.assertTrue(c != '\u0000', " - \u5206\u5272\u7b26\u4f4d\u7f6e\u4e0d\u6b63\u786e, \u524d\u9762\u5e94\u8be5\u6709\u4e00\u5b57\u7b26!");
                    this.scopes.add(new CharScope(i, c, c2));
                    bl2 = false;
                } else {
                    Assert.assertTrue(c == '\u0000', "\u5b57\u7b26\u4f4d\u7f6e\u9519\u8bef!");
                    c = c2;
                }
                bl = !bl;
            }
            if (c == '\u0000') continue;
            this.types.put(new Character(c), new Integer(i));
        }
    }

    public int getType(char c) {
        if (this.types.containsKey(new Character(c))) {
            return (Integer)this.types.get(new Character(c));
        }
        Iterator iterator = this.scopes.iterator();
        while (iterator.hasNext()) {
            CharScope charScope = (CharScope)iterator.next();
            if (!charScope.isMatching(c)) continue;
            return charScope.getType();
        }
        return this.otherType;
    }

    private static final class CharScope {
        private int type;
        private char begin;
        private char end;

        public CharScope(int n, char c, char c2) {
            this.type = n;
            this.begin = c;
            this.end = c2;
        }

        public boolean isMatching(char c) {
            return c >= this.begin && c <= this.end;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            return this.begin + "-" + this.end + ":" + this.type;
        }
    }
}

