/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util.scanner;

import java.io.IOException;
import java.util.Map;
import org.commontemplate.util.Assert;
import org.commontemplate.util.Offset;
import org.commontemplate.util.Position;
import org.commontemplate.util.scanner.Accepter;
import org.commontemplate.util.scanner.CharStream;
import org.commontemplate.util.scanner.Scanner;
import org.commontemplate.util.scanner.ScanningException;
import org.commontemplate.util.scanner.StateMap;
import org.commontemplate.util.scanner.Token;
import org.commontemplate.util.scanner.TokenReceiver;
import org.commontemplate.util.scanner.TypeResolver;

public class DFAScanner
implements Scanner {
    private final TypeResolver typeResolver;
    private final StateMap stateMap;
    private final Map accepters;

    public DFAScanner(TypeResolver typeResolver, StateMap stateMap, Map map) {
        Assert.assertNotNull(typeResolver, "typeResolver == null!");
        Assert.assertNotNull(stateMap, "stateMap == null!");
        Assert.assertNotNull(map, "accepters == null!");
        this.typeResolver = typeResolver;
        this.stateMap = stateMap;
        this.accepters = map;
    }

    public void scan(CharStream charStream, TokenReceiver tokenReceiver) throws IOException, ScanningException {
        this.scan(charStream, tokenReceiver, Offset.ZERO);
    }

    public void scan(CharStream charStream, TokenReceiver tokenReceiver, Offset offset) throws IOException, ScanningException {
        long l = offset.getLength();
        int n = offset.getPosition().getRow();
        int n2 = offset.getPosition().getColumn();
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n5 = 0;
        while (true) {
            char c;
            if (stringBuffer2.length() > 0) {
                c = stringBuffer2.charAt(0);
                stringBuffer2.deleteCharAt(0);
            } else {
                c = charStream.nextChar();
                if (c == '\u0000') break;
            }
            ++l;
            if (c == '\n') {
                ++n;
                n2 = 0;
            } else {
                ++n2;
            }
            if (stringBuffer.length() == 0) {
                n3 = n;
                n4 = n2;
            }
            stringBuffer.append(c);
            int n6 = this.typeResolver.getType(c);
            if ((n5 = this.stateMap.getNextState(n5, n6)) >= 0) continue;
            Accepter accepter = (Accepter)this.accepters.get(new Integer(n5));
            if (accepter == null) {
                throw new ScanningException(n5, l, n, n2, "\u9519\u8bef\u53d1\u751f\u5728\u5b57\u7b26:" + c + " \u4f4d\u7f6e:(" + n + "," + n2 + ")");
            }
            int n7 = accepter.accept(stringBuffer.toString());
            Assert.assertTrue(n7 >= 0 && n7 <= stringBuffer.length(), "\u63a5\u6536\u7b56\u7565\u51fa\u9519\uff01");
            l -= (long)n7;
            if (n7 > 0) {
                tokenReceiver.receive(new Token(stringBuffer.substring(0, n7), l, new Position(n3, n4), n5));
            }
            if (n7 < stringBuffer.length()) {
                stringBuffer2.insert(0, stringBuffer.substring(n7));
            }
            stringBuffer.setLength(0);
            n5 = 0;
        }
        if (stringBuffer.length() > 0) {
            tokenReceiver.receive(new Token(stringBuffer.toString(), l, new Position(n3, n4), 0));
        }
    }
}

