/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util;

import java.util.Collection;
import java.util.Map;
import org.commontemplate.util.Assert;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return ((String)object).length() > 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() > 0;
        }
        if (object instanceof Map) {
            return ((Map)object).size() > 0;
        }
        return true;
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return ((String)object).length() == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() == 0;
        }
        if (object instanceof Map) {
            return ((Map)object).size() == 0;
        }
        return false;
    }

    public static boolean isString(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() < 2) {
            return false;
        }
        if (string2.startsWith("\"") || string2.startsWith("'") || string2.startsWith("`")) {
            Assert.assertTrue(string2.endsWith(string2.substring(0, 1)));
            return true;
        }
        return false;
    }

    public static boolean isNumber(String string) {
        return string != null && string.length() > 0 && string.charAt(0) >= '0' && string.charAt(0) <= '9';
    }

    public static boolean isSignNumber(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            return true;
        }
        return string != null && string.length() > 1 && (string.charAt(0) == '+' || string.charAt(0) == '-') && string.charAt(1) >= '0' && string.charAt(1) <= '9';
    }

    public static Number parseSignNumber(String string) {
        char c = string.charAt(string.length() - 1);
        if (c >= '0' && c <= '9') {
            if (string.indexOf(46) != -1) {
                return new Float(string);
            }
            return new Integer(string);
        }
        if (c == 'S' || c == 's') {
            return new Short(string.substring(0, string.length() - 1));
        }
        if (c == 'L' || c == 'l') {
            return new Long(string.substring(0, string.length() - 1));
        }
        if (c == 'F' || c == 'f') {
            return new Float(string.substring(0, string.length() - 1));
        }
        if (c == 'D' || c == 'd') {
            return new Double(string.substring(0, string.length() - 1));
        }
        throw new IllegalArgumentException();
    }

    public static boolean isNamed(String string) {
        return string != null && string.length() > 0 && string.matches("^[_|A-Z|a-z][_|0-9|A-Z|a-z]*$");
    }

    public static boolean isFunction(String string) {
        return string != null && string.length() > 1 && string.charAt(0) == '.' && TypeUtils.isNamed(string.substring(1));
    }

    public static boolean isOperator(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (!(c == '_' || c == '\"' || c == '\'' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') && (c < 'a' || c > 'z')) continue;
            return false;
        }
        return true;
    }

    public static boolean isMultiOperator(String string) {
        return string != null && string.trim().length() > 1 && TypeUtils.isOperator(string);
    }
}

