/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ReaderInputStream
extends InputStream {
    protected Reader reader;
    protected ByteArrayOutputStream byteArrayOut;
    protected Writer writer;
    protected char[] chars;
    protected byte[] buffer;
    protected int index;
    protected int length;

    public ReaderInputStream(Reader reader) {
        this.reader = reader;
        this.byteArrayOut = new ByteArrayOutputStream();
        this.writer = new OutputStreamWriter(this.byteArrayOut);
        this.chars = new char[1024];
    }

    public ReaderInputStream(Reader reader, String string) throws UnsupportedEncodingException {
        this.reader = reader;
        this.byteArrayOut = new ByteArrayOutputStream();
        this.writer = new OutputStreamWriter((OutputStream)this.byteArrayOut, string);
        this.chars = new char[1024];
    }

    public int read() throws IOException {
        if (this.index >= this.length) {
            this.fillBuffer();
        }
        if (this.index >= this.length) {
            return -1;
        }
        return 0xFF & this.buffer[this.index++];
    }

    protected void fillBuffer() throws IOException {
        if (this.length < 0) {
            return;
        }
        int n = this.reader.read(this.chars);
        if (n < 0) {
            this.length = -1;
        } else {
            this.byteArrayOut.reset();
            this.writer.write(this.chars, 0, n);
            this.writer.flush();
            this.buffer = this.byteArrayOut.toByteArray();
            this.length = this.buffer.length;
            this.index = 0;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.index >= this.length) {
            this.fillBuffer();
        }
        if (this.index >= this.length) {
            return -1;
        }
        int n3 = Math.min(n2, this.length - this.index);
        System.arraycopy(this.buffer, this.index, byArray, n, n3);
        this.index += n3;
        return n3;
    }

    public int available() throws IOException {
        return this.index < this.length ? this.length - this.index : (this.length >= 0 && this.reader.ready() ? 1 : 0);
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

