/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util;

import java.io.Serializable;

public final class Position
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Position ZERO = new Position(0, 0);
    private final int row;
    private final int column;
    private String toString;

    public Position(int n, int n2) {
        this.row = n;
        this.column = n2;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public Position offset(Position position) {
        return new Position(this.row + position.row, this.column + position.column);
    }

    public Position offsetRow(int n) {
        return new Position(this.row + n, this.column);
    }

    public Position offsetColumn(int n) {
        return new Position(this.row, this.column + n);
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            stringBuffer.append(this.row);
            stringBuffer.append(',');
            stringBuffer.append(this.column);
            stringBuffer.append(')');
            this.toString = stringBuffer.toString();
        }
        return this.toString;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Position)) {
            return false;
        }
        Position position = (Position)object;
        return this.row == position.row && this.column == position.column;
    }

    public int hashCode() {
        return 37 * (this.row + this.column);
    }
}

