/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util;

public final class NumberArithmetic {
    private NumberArithmetic() {
    }

    public static Number add(Number number, Number number2) {
        if (number instanceof Byte || number2 instanceof Byte) {
            int n = number.byteValue() + number2.byteValue();
            if (n > 127 || n < -128) {
                throw new ArithmeticException(number + "\u4e0e" + number2 + "\u76f8\u52a0\u540e\uff0cByte\u503c\u8d8a\u754c\uff1a" + n);
            }
            return new Byte((byte)n);
        }
        if (number instanceof Short || number2 instanceof Short) {
            int n = number.shortValue() + number2.shortValue();
            if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
                throw new ArithmeticException(number + "\u4e0e" + number2 + "\u76f8\u52a0\u540e\uff0cShort\u503c\u8d8a\u754c\uff1a" + n);
            }
            return new Short((short)n);
        }
        if (number instanceof Integer || number2 instanceof Integer) {
            return new Integer(number.intValue() + number2.intValue());
        }
        if (number instanceof Long || number2 instanceof Long) {
            return new Long(number.longValue() + number2.longValue());
        }
        if (number instanceof Float || number2 instanceof Float) {
            return new Float(number.floatValue() + number2.floatValue());
        }
        return new Double(number.doubleValue() + number2.doubleValue());
    }

    public static Number subtract(Number number, Number number2) {
        if (number instanceof Byte || number2 instanceof Byte) {
            int n = number.byteValue() - number2.byteValue();
            if (n > 127 || n < -128) {
                throw new ArithmeticException(number + "\u4e0e" + number2 + "\u76f8\u51cf\u540e\uff0cByte\u503c\u8d8a\u754c\uff1a" + n);
            }
            return new Byte((byte)n);
        }
        if (number instanceof Short || number2 instanceof Short) {
            int n = number.shortValue() - number2.shortValue();
            if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
                throw new ArithmeticException(number + "\u4e0e" + number2 + "\u76f8\u51cf\u540e\uff0cShort\u503c\u8d8a\u754c\uff1a" + n);
            }
            return new Short((short)n);
        }
        if (number instanceof Integer || number2 instanceof Integer) {
            return new Integer(number.intValue() - number2.intValue());
        }
        if (number instanceof Long || number2 instanceof Long) {
            return new Long(number.longValue() - number2.longValue());
        }
        if (number instanceof Float || number2 instanceof Float) {
            return new Float(number.floatValue() - number2.floatValue());
        }
        return new Double(number.doubleValue() - number2.doubleValue());
    }

    public static Number multiply(Number number, Number number2) {
        if (number instanceof Byte || number2 instanceof Byte) {
            int n = number.byteValue() * number2.byteValue();
            if (n > 127 || n < -128) {
                throw new ArithmeticException(number + "\u4e0e" + number2 + "\u76f8\u4e58\u540e\uff0cByte\u503c\u8d8a\u754c\uff1a" + n);
            }
            return new Byte((byte)n);
        }
        if (number instanceof Short || number2 instanceof Short) {
            int n = number.shortValue() * number2.shortValue();
            if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
                throw new ArithmeticException(number + "\u4e0e" + number2 + "\u76f8\u4e58\u540e\uff0cShort\u503c\u8d8a\u754c\uff1a" + n);
            }
            return new Short((short)n);
        }
        if (number instanceof Integer || number2 instanceof Integer) {
            return new Integer(number.intValue() * number2.intValue());
        }
        if (number instanceof Long || number2 instanceof Long) {
            return new Long(number.longValue() * number2.longValue());
        }
        if (number instanceof Float || number2 instanceof Float) {
            return new Float(number.floatValue() * number2.floatValue());
        }
        return new Double(number.doubleValue() * number2.doubleValue());
    }

    public static Number divide(Number number, Number number2) {
        if (number instanceof Byte || number2 instanceof Byte) {
            int n = number.byteValue() / number2.byteValue();
            if (n > 127 || n < -128) {
                throw new ArithmeticException(number + "\u4e0e" + number2 + "\u76f8\u9664\u540e\uff0cByte\u503c\u8d8a\u754c\uff1a" + n);
            }
            return new Byte((byte)n);
        }
        if (number instanceof Short || number2 instanceof Short) {
            int n = number.shortValue() / number2.shortValue();
            if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
                throw new ArithmeticException(number + "\u4e0e" + number2 + "\u76f8\u9664\u540e\uff0cShort\u503c\u8d8a\u754c\uff1a" + n);
            }
            return new Short((short)n);
        }
        if (number instanceof Integer || number2 instanceof Integer) {
            return new Integer(number.intValue() / number2.intValue());
        }
        if (number instanceof Long || number2 instanceof Long) {
            return new Long(number.longValue() / number2.longValue());
        }
        if (number instanceof Float || number2 instanceof Float) {
            return new Float(number.floatValue() / number2.floatValue());
        }
        return new Double(number.doubleValue() / number2.doubleValue());
    }

    public static Number modulus(Number number, Number number2) {
        if (number instanceof Byte || number2 instanceof Byte) {
            int n = number.byteValue() % number2.byteValue();
            if (n > 127 || n < -128) {
                throw new ArithmeticException(number + "\u4e0e" + number2 + "\u6c42\u6a21\u540e\uff0cByte\u503c\u8d8a\u754c\uff1a" + n);
            }
            return new Byte((byte)n);
        }
        if (number instanceof Short || number2 instanceof Short) {
            int n = number.shortValue() % number2.shortValue();
            if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
                throw new ArithmeticException(number + "\u4e0e" + number2 + "\u6c42\u6a21\u540e\uff0cShort\u503c\u8d8a\u754c\uff1a" + n);
            }
            return new Short((short)n);
        }
        if (number instanceof Integer || number2 instanceof Integer) {
            return new Integer(number.intValue() % number2.intValue());
        }
        if (number instanceof Long || number2 instanceof Long) {
            return new Long(number.longValue() % number2.longValue());
        }
        if (number instanceof Float || number2 instanceof Float) {
            return new Float(number.floatValue() % number2.floatValue());
        }
        return new Double(number.doubleValue() % number2.doubleValue());
    }

    public static Number negative(Number number) {
        if (number instanceof Byte) {
            return new Byte(-number.byteValue());
        }
        if (number instanceof Short) {
            return new Short(-number.shortValue());
        }
        if (number instanceof Integer) {
            return new Integer(-number.intValue());
        }
        if (number instanceof Long) {
            return new Long(-number.longValue());
        }
        if (number instanceof Float) {
            return new Float(-number.floatValue());
        }
        return new Double(-number.doubleValue());
    }
}

