/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util;

import java.io.IOException;
import java.text.Collator;
import java.util.Currency;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

public final class LocaleUtils {
    private static final String FINAL_DEFAULT_ENCODING = "UTF-8";
    static /* synthetic */ Class class$org$commontemplate$util$LocaleUtils;

    private LocaleUtils() {
    }

    public static Locale getNativeLocale() {
        return Locale.getDefault();
    }

    public static String getNativeEncoding() {
        String string = System.getProperty("file.encoding");
        if (string != null && string.length() > 0) {
            return string;
        }
        return LocaleUtils.getDefaultEncoding(LocaleUtils.getNativeLocale());
    }

    public static String getDefaultEncoding(Locale locale) {
        Properties properties = new Properties();
        try {
            properties.load((class$org$commontemplate$util$LocaleUtils == null ? (class$org$commontemplate$util$LocaleUtils = LocaleUtils.class$("org.commontemplate.util.LocaleUtils")) : class$org$commontemplate$util$LocaleUtils).getClassLoader().getResourceAsStream("org/commontemplate/util/default_encodings.properties"));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        String string = LocaleUtils.searchValue(properties, locale);
        if (string != null) {
            return string;
        }
        return FINAL_DEFAULT_ENCODING;
    }

    public static TimeZone getNativeTimeZone() {
        String string = System.getProperty("user.timezone");
        if (string != null && string.length() > 0) {
            return TimeZone.getTimeZone(string);
        }
        return LocaleUtils.getDefaultTimeZone(LocaleUtils.getNativeLocale());
    }

    public static TimeZone getDefaultTimeZone(Locale locale) {
        Properties properties = new Properties();
        try {
            properties.load((class$org$commontemplate$util$LocaleUtils == null ? (class$org$commontemplate$util$LocaleUtils = LocaleUtils.class$("org.commontemplate.util.LocaleUtils")) : class$org$commontemplate$util$LocaleUtils).getClassLoader().getResourceAsStream("org/commontemplate/util/default_timezone.properties"));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        String string = LocaleUtils.searchValue(properties, locale);
        if (string == null) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(string);
    }

    private static String searchValue(Properties properties, Locale locale) {
        String string = (String)properties.get(locale.getLanguage());
        if (string == null) {
            string = (String)properties.get(locale.getLanguage() + "_" + locale.getCountry());
        }
        return string;
    }

    public static Currency getNativeCurrency() {
        return LocaleUtils.getDefaultCurrency(LocaleUtils.getNativeLocale());
    }

    public static Currency getDefaultCurrency(Locale locale) {
        return Currency.getInstance(locale);
    }

    public static Collator getNativeCollator() {
        return LocaleUtils.getDefaultCollator(LocaleUtils.getNativeLocale());
    }

    public static Collator getDefaultCollator(Locale locale) {
        return Collator.getInstance(locale);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

