/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.commontemplate.util.Assert;
import org.commontemplate.util.Stack;

public class LinkedStack
implements Stack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final LinkedList stack = new LinkedList();

    public boolean isEmpty() {
        return this.stack.size() == 0;
    }

    public void push(Object object) {
        this.stack.addLast(object);
    }

    public Object pop() {
        Object object = this.peek();
        this.stack.removeLast();
        return object;
    }

    public Object peek() {
        Assert.assertFalse(this.isEmpty(), "\u7a7a\u6808!");
        return this.stack.getLast();
    }

    public void poke(Object object) {
        Assert.assertFalse(this.isEmpty(), "\u7a7a\u6808!");
        this.stack.removeLast();
        this.push(object);
    }

    public void clear() {
        this.stack.clear();
    }

    public List values() {
        return Collections.unmodifiableList(this.stack);
    }

    public String toString() {
        return this.stack.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof LinkedStack) {
            return false;
        }
        LinkedStack linkedStack = (LinkedStack)object;
        return this.stack.equals(linkedStack.stack);
    }

    public int hashCode() {
        return 37 * this.stack.hashCode();
    }
}

