/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.commontemplate.util.ExceptionMessageSource;

public abstract class ExceptionSupport
extends Exception {
    private static final long serialVersionUID = 4410422013855597828L;
    private String messageKey;
    private Object[] messageArgs = new Object[0];

    public ExceptionSupport(String string) {
        this.messageKey = string;
    }

    public ExceptionSupport(String string, Throwable throwable) {
        super(throwable);
        this.messageKey = string;
    }

    public ExceptionSupport(String string, Object[] objectArray, Throwable throwable) {
        super(throwable);
        this.messageKey = string;
        this.messageArgs = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.messageArgs, 0, objectArray.length);
    }

    public String getMessage() {
        return ExceptionMessageSource.getMessage(this.messageKey, this.messageArgs);
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public List getMessageArgs() {
        return Collections.unmodifiableList(Arrays.asList(this.messageArgs));
    }
}

