/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class ExceptionMessageSource {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle(System.getProperty("org.commontemplate.util.ExceptionMessageSource.baseName", "org/commontemplate/util/exception_messages"));

    private ExceptionMessageSource() {
    }

    public static synchronized void setResourceBundle(ResourceBundle resourceBundle) {
        ExceptionMessageSource.resourceBundle = resourceBundle;
    }

    public static String getMessage(String string) {
        return resourceBundle.getString(string);
    }

    public static String getMessage(String string, String string2) {
        String string3 = ExceptionMessageSource.getMessage(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static String getMessage(String string, Object[] objectArray) {
        String string2 = ExceptionMessageSource.getMessage(string);
        if (objectArray == null || objectArray.length == 0) {
            return string2;
        }
        return ExceptionMessageSource.formatMessage(string2, objectArray);
    }

    public static String getMessage(String string, Object[] objectArray, String string2) {
        String string3 = ExceptionMessageSource.getMessage(string, string2);
        if (objectArray == null || objectArray.length == 0) {
            return string3;
        }
        return ExceptionMessageSource.formatMessage(string3, objectArray);
    }

    private static String formatMessage(String string, Object[] objectArray) {
        if (string != null && string.length() > 0 && objectArray != null && objectArray.length > 0) {
            return new MessageFormat(string, resourceBundle.getLocale()).format(objectArray);
        }
        return string;
    }
}

