/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.commontemplate.util.Assert;

public class ClassUtils {
    private ClassUtils() {
    }

    public static Class forName(String string) throws ClassNotFoundException {
        Assert.assertNotNull(string, "className\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return Class.forName(string);
    }

    public static Class forCanonicalName(String string) throws ClassNotFoundException {
        Assert.assertNotNull(string, "className\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (string.endsWith("[]")) {
            string = "[L" + string.substring(0, string.length() - 2) + ";";
        }
        return Class.forName(string);
    }

    public static Object getObjectProperty(Object object, String string) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (object == null) {
            return null;
        }
        Method method = ClassUtils.getClassGetter(object.getClass(), string);
        return method.invoke(object, new Object[0]);
    }

    public static void setObjectProperty(Object object, String string, Object object2) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (object == null) {
            return;
        }
        Method method = ClassUtils.getClassSetter(object.getClass(), string);
        method.invoke(object, object2);
    }

    public static void setObjectProperties(Object object, Map map) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (object == null) {
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = String.valueOf(entry.getKey());
            Object v = entry.getValue();
            ClassUtils.setObjectProperty(object, string, v);
        }
    }

    public static Method getClassGetter(Class clazz, String string) throws NoSuchMethodException, SecurityException {
        Assert.assertNotNull(clazz, "class\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.assertNotEmpty(string, "property\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        string = string.trim();
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
        try {
            return clazz.getMethod("get" + string2, new Class[0]);
        }
        catch (Exception exception) {
            return clazz.getMethod("is" + string2, new Class[0]);
        }
    }

    public static Method getClassSetter(Class clazz, String string) throws NoSuchMethodException, SecurityException {
        Assert.assertNotNull(clazz, "class\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.assertNotEmpty(string, "property\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        string = string.trim();
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
        return clazz.getMethod("set" + string2, new Class[0]);
    }
}

