/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.util;

import java.util.Collection;
import java.util.Map;

public final class Assert {
    private Assert() {
    }

    public static void fail() {
        Assert.fail("\u65ad\u8a00\u6b64\u5904\u4e0d\u4f1a\u88ab\u8fd0\u884c\u5230\uff0c\u4f46\u5374\u8fd0\u884c\u4e86!");
    }

    public static void fail(String string) {
        throw new IllegalStateException(string);
    }

    public static void assertEquals(String string, String string2) {
        Assert.assertEquals(string, string2, "\u65ad\u8a00\u4e24\u503c\u76f8\u7b49, \u4f46" + string + "\u4e0d\u7b49\u4e8e" + string2 + "!");
    }

    public static void assertEquals(String string, String string2, String string3) {
        if (string == null || !string.equals(string2)) {
            throw new IllegalStateException(string3);
        }
    }

    public static void assertMatches(String string, String string2) {
        Assert.assertMatches(string, string2, "\u65ad\u8a00\u6b64\u503c\u5339\u914d\u8868\u8fbe\u5f0f" + string2 + ", \u4f46" + string + "\u4e0d\u5339\u914d!");
    }

    public static void assertMatches(String string, String string2, String string3) {
        if (!string.matches(string2)) {
            throw new IllegalStateException(string3);
        }
    }

    public static void assertAssignableFrom(Class clazz, Class clazz2) {
        Assert.assertAssignableFrom(clazz, clazz2, "\u65ad\u8a00" + clazz.getName() + "\u7ee7\u627f\u4e8e" + clazz2.getName() + ",\u4f46\u5374\u4e0d\u662f!");
    }

    public static void assertAssignableFrom(Class clazz, Class clazz2, String string) {
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new IllegalStateException(string);
        }
    }

    public static void assertTrue(boolean bl) {
        Assert.assertTrue(bl, "\u65ad\u8a00\u6b64\u547d\u9898\u5e94\u8be5\u4e3a\u771f, \u4f46\u5374\u4e3a\u5047!");
    }

    public static void assertTrue(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    public static void assertFalse(boolean bl) {
        Assert.assertFalse(bl, "\u65ad\u8a00\u6b64\u547d\u9898\u5e94\u8be5\u4e3a\u5047, \u4f46\u5374\u4e3a\u771f!");
    }

    public static void assertFalse(boolean bl, String string) {
        if (bl) {
            throw new IllegalStateException(string);
        }
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(object, "\u65ad\u8a00\u6b64\u5bf9\u8c61\u4e0d\u4e3a\u7a7a, \u4f46\u5374\u4e3a\u7a7a!");
    }

    public static void assertNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    public static void assertEmpty(Object object) {
        Assert.assertEmpty(object, "\u65ad\u8a00\u6b64\u5bf9\u8c61\u4e3a\u7a7a, \u4f46\u5374\u4e0d\u4e3a\u7a7a!");
    }

    public static void assertEmpty(Object object, String string) {
        if (object != null) {
            throw new IllegalStateException(string);
        }
    }

    public static void assertNotEmpty(Object object) {
        Assert.assertNotEmpty(object, "\u65ad\u8a00\u6b64\u5bf9\u8c61\u4e0d\u4e3a\u7a7a, \u4f46\u5374\u4e3a\u7a7a!");
    }

    public static void assertNotEmpty(Object object, String string) {
        if (object == null) {
            throw new IllegalStateException(string);
        }
    }

    public static void assertNotEmpty(String string) {
        Assert.assertNotEmpty(string, "\u65ad\u8a00\u6b64\u5bf9\u8c61\u4e0d\u4e3a\u7a7a, \u4f46\u5374\u4e3a\u7a7a!");
    }

    public static void assertNotEmpty(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalStateException(string2);
        }
    }

    public static void assertNotEmpty(Collection collection) {
        Assert.assertNotEmpty(collection, "\u65ad\u8a00\u6b64\u5bf9\u8c61\u4e0d\u4e3a\u7a7a, \u4f46\u5374\u4e3a\u7a7a!");
    }

    public static void assertNotEmpty(Collection collection, String string) {
        if (collection == null || collection.size() == 0) {
            throw new IllegalStateException(string);
        }
    }

    public static void assertNotEmpty(Map map) {
        Assert.assertNotEmpty(map, "\u65ad\u8a00\u6b64\u5bf9\u8c61\u4e0d\u4e3a\u7a7a, \u4f46\u5374\u4e3a\u7a7a!");
    }

    public static void assertNotEmpty(Map map, String string) {
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void assertNotEmpty(Object[] objectArray) {
        Assert.assertNotEmpty(objectArray, "\u65ad\u8a00\u6b64\u5bf9\u8c61\u4e0d\u4e3a\u7a7a, \u4f46\u5374\u4e3a\u7a7a!");
    }

    public static void assertNotEmpty(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void assertContain(String string, String string2) {
        Assert.assertContain(string, string2, "\u65ad\u8a00\"" + string + "\"\u5c06\u5305\u542b\"" + string2 + "\"\u5b50\u4e32\uff0c\u4f46\u5374\u4e0d\u5305\u542b!");
    }

    public static void assertContain(String string, String string2, String string3) {
        if (string == null || string2 == null || string.indexOf(string2) == -1) {
            throw new IllegalStateException(string3);
        }
    }

    public static void assertGreaterThan(int n, int n2) {
        Assert.assertGreaterThan(n, n2, "\u65ad\u8a00" + n + "\u5e94\u5927\u4e8e\"" + n2 + "\"!");
    }

    public static void assertGreaterThan(int n, int n2, String string) {
        if (n <= n2) {
            throw new IllegalStateException(string);
        }
    }

    public static void assertGreaterEqual(int n, int n2) {
        Assert.assertGreaterEqual(n, n2, "\u65ad\u8a00" + n + "\u5e94\u5927\u4e8e\u6216\u7b49\u4e8e\"" + n2 + "\"!");
    }

    public static void assertGreaterEqual(int n, int n2, String string) {
        if (n < n2) {
            throw new IllegalStateException(string);
        }
    }
}

