/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.tools.web;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.commontemplate.core.Context;
import org.commontemplate.core.Factory;
import org.commontemplate.core.ParsingException;
import org.commontemplate.core.RenderingException;
import org.commontemplate.core.Template;
import org.commontemplate.engine.Engine;
import org.commontemplate.standard.ConfigurationSettings;
import org.commontemplate.tools.PropertiesConfigurationLoader;
import org.commontemplate.tools.bean.ComboResourceLoader;
import org.commontemplate.tools.bean.ResourceLoader;
import org.commontemplate.tools.web.ApplicationMap;
import org.commontemplate.tools.web.CookieMap;
import org.commontemplate.tools.web.HeaderMap;
import org.commontemplate.tools.web.ModelMap;
import org.commontemplate.tools.web.ParameterMap;
import org.commontemplate.tools.web.RequestMap;
import org.commontemplate.tools.web.SessionMap;
import org.commontemplate.util.Assert;

public final class EngineHolder {
    public static final String CONFIG_PARAM_NAME = "commontemplate-config";
    public static final String DEFAULT_CONFIG_WEB_PATH = "/WEB-INF/commontemplate.properties";
    public static final String DEFAULT_CONFIG_CLASS_PATH = "commontemplate.properties";
    public static final String STANDARD_CONFIG_PATH = "org/commontemplate/tools/web/commontemplate.properties";
    private static ServletContext servletContext;
    private static ConfigurationSettings config;
    private static Factory engine;
    private static final String APPLICATION_SCOPE_NAME = "application";
    private static final String COOKIE_SCOPE_NAME = "cookie";
    private static final String SESSION_SCOPE_NAME = "session";
    private static final String HEADER_SCOPE_NAME = "header";
    private static final String PARAMETER_SCOPE_NAME = "parameter";
    private static final String REQUEST_SCOPE_NAME = "request";
    private static final String MODEL_SCOPE_NAME = "model";
    static /* synthetic */ Class class$org$commontemplate$tools$web$EngineInitializeListener;

    private EngineHolder() {
    }

    public static final boolean isInitialized() {
        return engine != null;
    }

    public static final void init(ServletContext servletContext) {
        URL uRL;
        Assert.assertNotNull(servletContext, "[commontemplate] Template engine initializtion error: servletContext == null!");
        servletContext.log("[commontemplate] Template engine initializing...");
        long l = System.currentTimeMillis();
        servletContext.log("[commontemplate] Searching config...");
        String string = servletContext.getInitParameter(CONFIG_PARAM_NAME);
        if (string != null) {
            string = string.trim();
        }
        if ((string == null || string.length() == 0) && new File(servletContext.getRealPath("/") + DEFAULT_CONFIG_WEB_PATH).exists()) {
            string = DEFAULT_CONFIG_WEB_PATH;
        }
        if ((string == null || string.length() == 0) && (uRL = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_CONFIG_CLASS_PATH)) != null && new File(uRL.getFile()).exists()) {
            string = DEFAULT_CONFIG_CLASS_PATH;
        }
        if (string == null || string.length() == 0) {
            string = STANDARD_CONFIG_PATH;
        }
        servletContext.log("[commontemplate] Loading config: " + string);
        EngineHolder.servletContext = servletContext;
        config = PropertiesConfigurationLoader.loadConfiguration(string, (ResourceLoader)new ComboResourceLoader(servletContext), EngineHolder.getVariables(servletContext));
        engine = new Engine(config);
        servletContext.log("[commontemplate] Template engine initialized in " + (System.currentTimeMillis() - l) + "ms");
    }

    public static final void init(ServletContext servletContext, String string) {
        Assert.assertNotNull(servletContext, "[commontemplate] Template engine initializtion error: servletContext == null!");
        servletContext.log("[commontemplate] Template engine initializing...");
        long l = System.currentTimeMillis();
        servletContext.log("[commontemplate] Loading config: " + string);
        EngineHolder.servletContext = servletContext;
        config = PropertiesConfigurationLoader.loadConfiguration(string.trim(), (ResourceLoader)new ComboResourceLoader(servletContext), EngineHolder.getVariables(servletContext));
        engine = new Engine(config);
        servletContext.log("[commontemplate] Template engine initialized in " + (System.currentTimeMillis() - l) + "ms");
    }

    public static final void init(ServletContext servletContext, Properties properties) {
        Assert.assertNotNull(servletContext, "[commontemplate] Template engine initializtion error: servletContext == null!");
        servletContext.log("[commontemplate] Template engine initializing...");
        long l = System.currentTimeMillis();
        EngineHolder.servletContext = servletContext;
        config = PropertiesConfigurationLoader.loadConfiguration(properties, (ResourceLoader)new ComboResourceLoader(servletContext), EngineHolder.getVariables(servletContext));
        engine = new Engine(config);
        servletContext.log("[commontemplate] Template engine initialized in " + (System.currentTimeMillis() - l) + "ms");
    }

    private static final Map getVariables(ServletContext servletContext) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("servletContext", servletContext);
        hashMap.put("servletContext.rootPath", servletContext.getRealPath("/"));
        hashMap.put("servletContext.serverInfo", servletContext.getServerInfo());
        hashMap.put("servletContext.version", servletContext.getMajorVersion() + "." + servletContext.getMinorVersion());
        return hashMap;
    }

    public static final void destroy() {
        servletContext = null;
        config = null;
        engine = null;
    }

    public static final ServletContext getServletContext() throws NullPointerException {
        EngineHolder.checkInitialized();
        return servletContext;
    }

    public static final ConfigurationSettings getConfiguration() throws NullPointerException {
        EngineHolder.checkInitialized();
        return config;
    }

    public static final Factory getEngine() throws NullPointerException {
        EngineHolder.checkInitialized();
        return engine;
    }

    private static final void checkInitialized() throws NullPointerException {
        if (engine == null) {
            throw new NullPointerException("\u5f15\u64ce\u672a\u521d\u59cb\u5316\uff01\u8bf7\u5728web.xml\u4e2d\u52a0\u4e0a\u914d\u7f6e\uff1a <listener><listener-class>" + (class$org$commontemplate$tools$web$EngineInitializeListener == null ? (class$org$commontemplate$tools$web$EngineInitializeListener = EngineHolder.class$("org.commontemplate.tools.web.EngineInitializeListener")) : class$org$commontemplate$tools$web$EngineInitializeListener).getName() + "</listener-class></listener>");
        }
    }

    public static final Context createContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return EngineHolder.createContext(httpServletRequest, httpServletResponse, null);
    }

    public static final Context createContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) throws IOException {
        return EngineHolder.createContext(httpServletRequest, httpServletResponse, locale, null);
    }

    public static final Context createContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale, Object object) throws IOException {
        if (httpServletRequest == null) {
            throw new NullPointerException("request == null");
        }
        if (httpServletResponse == null) {
            throw new NullPointerException("response == null");
        }
        if (locale == null) {
            locale = httpServletRequest.getLocale();
        }
        Context context = EngineHolder.getEngine().createContext(httpServletResponse.getWriter(), locale);
        context.pushLocalContext(APPLICATION_SCOPE_NAME, new ApplicationMap(httpServletRequest));
        context.pushLocalContext(COOKIE_SCOPE_NAME, new CookieMap(httpServletRequest));
        context.pushLocalContext(SESSION_SCOPE_NAME, new SessionMap(httpServletRequest));
        context.pushLocalContext(HEADER_SCOPE_NAME, new HeaderMap(httpServletRequest));
        context.pushLocalContext(PARAMETER_SCOPE_NAME, new ParameterMap(httpServletRequest));
        context.pushLocalContext(REQUEST_SCOPE_NAME, new RequestMap(httpServletRequest));
        if (object == null) {
            context.pushLocalContext(MODEL_SCOPE_NAME);
        } else if (object instanceof Map) {
            context.pushLocalContext(MODEL_SCOPE_NAME, (Map)object);
        } else {
            context.pushLocalContext(MODEL_SCOPE_NAME, new ModelMap(object));
        }
        context.defineReadonlyVariable(REQUEST_SCOPE_NAME, httpServletRequest);
        context.defineReadonlyVariable("response", httpServletResponse);
        context.defineReadonlyVariable("servletContext", servletContext);
        context.putObject(REQUEST_SCOPE_NAME, httpServletRequest);
        context.putObject("response", httpServletResponse);
        context.putObject("servletContext", servletContext);
        return context;
    }

    public static final void renderTemplate(String string, Context context) throws IOException, ParsingException, RenderingException {
        EngineHolder.renderTemplate(string, null, context);
    }

    public static final void renderTemplate(String string, String string2, Context context) throws IOException, ParsingException, RenderingException {
        EngineHolder.renderTemplate(string, string2, null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void renderTemplate(String string, String string2, HttpServletResponse httpServletResponse, Context context) throws IOException, ParsingException, RenderingException {
        if (string == null) {
            throw new NullPointerException("templateName == null");
        }
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        Template template = EngineHolder.getEngine().getTemplate(string, string2);
        if (httpServletResponse != null) {
            String string3 = template.getEncoding();
            String string4 = "text/html";
            if (string3 != null) {
                string4 = string4 + "; charset=" + string3;
                httpServletResponse.setCharacterEncoding(string3);
            }
            httpServletResponse.setContentType(string4);
        }
        try {
            template.render(context);
        }
        finally {
            context.clear();
        }
    }

    public static final void renderTemplate(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale, Object object) throws IOException, ParsingException, RenderingException {
        EngineHolder.renderTemplate(string, string2, httpServletResponse, EngineHolder.createContext(httpServletRequest, httpServletResponse, locale, object));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

