/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.tools.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class EncodingFilter
implements Filter {
    private String requestEncoding = null;
    private String responseEncoding = null;
    private String contextType = "text/html";

    public void init(FilterConfig filterConfig) throws ServletException {
        String string;
        this.requestEncoding = filterConfig.getInitParameter("requestEncoding");
        this.responseEncoding = filterConfig.getInitParameter("responseEncoding");
        String string2 = filterConfig.getInitParameter("encoding");
        if (string2 != null) {
            if (this.requestEncoding == null) {
                this.requestEncoding = string2;
            }
            if (this.responseEncoding == null) {
                this.responseEncoding = string2;
            }
        }
        if ((string = filterConfig.getInitParameter("contextType")) != null) {
            string = string.trim();
        }
        if (string == null || string.length() == 0) {
            string = "text/html";
        }
        this.contextType = this.responseEncoding != null ? string + ";charset=" + this.responseEncoding : string;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.requestEncoding != null) {
            servletRequest.setCharacterEncoding(this.requestEncoding);
        }
        if (this.responseEncoding != null) {
            servletResponse.setCharacterEncoding(this.responseEncoding);
        }
        servletResponse.setContentType(this.contextType);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        this.requestEncoding = null;
        this.responseEncoding = null;
    }
}

