/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.tools.web;

import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.commontemplate.util.MapSupport;

public class CookieMap
extends MapSupport {
    private static final long serialVersionUID = 1L;
    private final Cookie[] cookies;

    public CookieMap(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new NullPointerException("request is null!");
        }
        this.cookies = httpServletRequest.getCookies();
    }

    public CookieMap(Cookie[] cookieArray) {
        if (cookieArray != null) {
            int n = cookieArray.length;
            this.cookies = new Cookie[n];
            for (int i = 0; i < n; ++i) {
                this.cookies[i] = cookieArray[i];
            }
        } else {
            this.cookies = new Cookie[0];
        }
    }

    protected Enumeration getNames() {
        return new CookieEnumerator(this.cookies == null ? new Cookie[]{} : this.cookies);
    }

    protected Object getValue(Object object) {
        if (this.cookies != null && this.cookies.length > 0) {
            for (int i = 0; i < this.cookies.length; ++i) {
                if (!object.equals(this.cookies[i].getName())) continue;
                return this.cookies[i].getValue();
            }
        }
        return null;
    }

    private static final class CookieEnumerator
    implements Enumeration {
        private int i = 0;
        private final Cookie[] cookieArray;

        public CookieEnumerator(Cookie[] cookieArray) {
            this.cookieArray = cookieArray;
        }

        public boolean hasMoreElements() {
            return this.cookieArray != null && this.cookieArray.length > this.i;
        }

        public Object nextElement() {
            if (this.cookieArray == null) {
                return null;
            }
            Cookie cookie = this.cookieArray[this.i];
            ++this.i;
            return cookie.getName();
        }
    }
}

