/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.tools.bean;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.commontemplate.tools.bean.BeanException;
import org.commontemplate.tools.bean.BeanFactory;
import org.commontemplate.tools.bean.ClassLoaderResourceLoader;
import org.commontemplate.tools.bean.ResourceLoader;
import org.commontemplate.util.Assert;
import org.commontemplate.util.TypeUtils;

public class PropertiesBeanFactory
implements BeanFactory {
    private final Properties properties;
    private final Map variables;
    private static final String EXTENDS_KEY = "@extends";

    public PropertiesBeanFactory(String string) {
        this(string, new ClassLoaderResourceLoader());
    }

    public PropertiesBeanFactory(String string, ResourceLoader resourceLoader) {
        this(string, resourceLoader, null);
    }

    public PropertiesBeanFactory(String string, Map map) {
        this(string, (ResourceLoader)new ClassLoaderResourceLoader(), map);
    }

    public PropertiesBeanFactory(String string, ResourceLoader resourceLoader, Map map) {
        Assert.assertNotNull(string, "\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.assertNotNull(resourceLoader, "\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5668\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.properties = PropertiesBeanFactory.extendProperties(PropertiesBeanFactory.loadProperties(string, resourceLoader), resourceLoader);
        this.variables = map;
    }

    public PropertiesBeanFactory(Properties properties, ResourceLoader resourceLoader, Map map) {
        Assert.assertNotNull(properties, "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.assertNotNull(resourceLoader, "\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5668\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.properties = PropertiesBeanFactory.extendProperties(properties, resourceLoader);
        this.variables = map;
    }

    private static Properties extendProperties(Properties properties, ResourceLoader resourceLoader) {
        String string = properties.getProperty(EXTENDS_KEY);
        if (string != null && string.trim().length() > 0) {
            String[] stringArray = string.split("\\,");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i] == null || stringArray[i].trim().length() <= 0) continue;
                Properties properties2 = PropertiesBeanFactory.extendProperties(PropertiesBeanFactory.loadProperties(stringArray[i].trim(), resourceLoader), resourceLoader);
                properties2.putAll((Map<?, ?>)properties);
                properties = properties2;
            }
        }
        return properties;
    }

    private static Properties loadProperties(String string, ResourceLoader resourceLoader) {
        try {
            InputStream inputStream = resourceLoader.getResourceAsStream(string);
            if (inputStream == null) {
                throw new FileNotFoundException("\u672a\u627e\u5230\u914d\u7f6e\u6587\u4ef6: " + string);
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            return properties;
        }
        catch (IOException iOException) {
            throw new BeanException(iOException);
        }
    }

    public Object getBean(String string) throws BeanException {
        return this.getProperty(string);
    }

    private void initProperty(String string, Object object) {
        String string2 = "";
        if (string != null) {
            string2 = string + ".";
        }
        Method[] methodArray = object.getClass().getMethods();
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            Method method = methodArray[i];
            String string3 = method.getName();
            if (string3.length() <= 3 || !string3.startsWith("set") || method.getParameterTypes().length != 1) continue;
            String string4 = this.castProperty(string3);
            if (!this.hasProperty(string2 + string4)) continue;
            Object object2 = this.getProperty(string2 + string4);
            try {
                method.invoke(object, object2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BeanException("\u8bf7\u68c0\u67e5\u914d\u914d\u7f6e\u9879\uff1a" + string2 + string4, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BeanException("\u8bf7\u68c0\u67e5\u914d\u914d\u7f6e\u9879\uff1a" + string2 + string4, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new BeanException("\u8bf7\u68c0\u67e5\u914d\u914d\u7f6e\u9879\uff1a" + string2 + string4, invocationTargetException);
            }
        }
    }

    private boolean hasProperty(String string) {
        String string2 = this.properties.getProperty(string);
        return string2 != null && string2.trim().length() > 0;
    }

    private String castProperty(String string) {
        String string2 = string.substring(3);
        return string2.substring(0, 1).toLowerCase() + string2.substring(1);
    }

    private Object getProperty(String string) {
        return this.parseProperty(string, this.properties.getProperty(string));
    }

    private Object parseProperty(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return null;
        }
        if ("true".equals(string2 = string2.trim())) {
            return Boolean.TRUE;
        }
        if ("false".equals(string2)) {
            return Boolean.FALSE;
        }
        if ("null".equals(string2)) {
            return null;
        }
        if (TypeUtils.isSignNumber(string2)) {
            return TypeUtils.parseSignNumber(string2);
        }
        if (string2.length() == 3 && string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'') {
            return new Character(string2.charAt(1));
        }
        if (string2.length() >= 2 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            return string2.substring(1, string2.length() - 1);
        }
        if (string2.length() > 1 && string2.charAt(0) == '$') {
            return this.getVariable(string2.substring(1));
        }
        if (string2.length() > 6 && string2.endsWith(".class")) {
            return this.getClassMeta(string2.substring(0, string2.length() - 6));
        }
        if (string2.length() > 9 && string2.endsWith("().static")) {
            return this.getObjectByStaticMethod(string2.substring(0, string2.length() - 9), string);
        }
        if (string2.length() > 7 && string2.endsWith(".static")) {
            return this.getObjectByStaticField(string2.substring(0, string2.length() - 9), string);
        }
        if (string2.length() > 2 && string2.endsWith("()")) {
            return this.getObject(string2.substring(0, string2.length() - 2), string);
        }
        if (string2.length() > 2 && string2.endsWith("<>")) {
            return this.getSet(string2.substring(0, string2.length() - 2));
        }
        if (string2.length() > 2 && string2.endsWith("[]")) {
            return this.getList(string2.substring(0, string2.length() - 2));
        }
        if (string2.length() > 2 && string2.endsWith("{}")) {
            return this.getMap(string2.substring(0, string2.length() - 2));
        }
        return string2;
    }

    private Object getVariable(String string) {
        String string2 = this.properties.getProperty(string);
        if (string2 != null && string2.trim().length() > 0) {
            return this.parseProperty(string, string2);
        }
        if (this.variables != null) {
            return this.variables.get(string);
        }
        return null;
    }

    private Object getClassMeta(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BeanException(classNotFoundException);
        }
    }

    private Object getObjectByStaticField(String string, String string2) {
        try {
            int n = string.lastIndexOf(46);
            Assert.assertTrue(n > 0 && n < string.length() - 1, "\u975e\u6cd5\u7684\u9759\u6001\u5b57\u6bb5\uff1a" + string);
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            Object object = Class.forName(string3).getField(string4).get(null);
            this.initProperty(string2, object);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BeanException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BeanException(classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BeanException(illegalArgumentException);
        }
        catch (SecurityException securityException) {
            throw new BeanException(securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BeanException(noSuchFieldException);
        }
    }

    private Object getObjectByStaticMethod(String string, String string2) {
        try {
            int n = string.lastIndexOf(46);
            Assert.assertTrue(n > 0 && n < string.length() - 1, "\u975e\u6cd5\u7684\u9759\u6001\u5de5\u5382\u65b9\u6cd5\uff1a" + string);
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            Object object = Class.forName(string3).getMethod(string4, new Class[0]).invoke(null, new Object[0]);
            this.initProperty(string2, object);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BeanException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BeanException(classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BeanException(illegalArgumentException);
        }
        catch (SecurityException securityException) {
            throw new BeanException(securityException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new BeanException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new BeanException(noSuchMethodException);
        }
    }

    private Object getObject(String string, String string2) {
        try {
            Object obj = Class.forName(string).newInstance();
            this.initProperty(string2, obj);
            return obj;
        }
        catch (InstantiationException instantiationException) {
            throw new BeanException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BeanException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BeanException(classNotFoundException);
        }
    }

    private Set getSet(String string) {
        if (!TypeUtils.isNamed(string)) {
            throw new BeanException("\u975e\u6cd5Set\u540d\u79f0\uff1a" + string);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        String string2 = string + "<";
        Iterator<Map.Entry<Object, Object>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            if (!string3.startsWith(string2) || !string3.endsWith(">")) continue;
            hashSet.add(this.parseProperty(string3, string4));
        }
        return hashSet;
    }

    private List getList(String string) {
        if (!TypeUtils.isNamed(string)) {
            throw new BeanException("\u975e\u6cd5List\u540d\u79f0\uff1a" + string);
        }
        String string2 = string + "[";
        int n = string2.length();
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        Object object = this.properties.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<Object, Object> entry = object.next();
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            if (!string3.startsWith(string2) || !string3.endsWith("]")) continue;
            treeMap.put(new Integer(string3.substring(n, string3.length() - 1)), this.parseProperty(string3, string4));
        }
        object = new ArrayList();
        object.addAll(treeMap.values());
        return object;
    }

    private Map getMap(String string) {
        if (!TypeUtils.isNamed(string)) {
            throw new BeanException("\u975e\u6cd5Map\u540d\u79f0\uff1a" + string);
        }
        String string2 = string + "{";
        int n = string2.length();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator<Map.Entry<Object, Object>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            if (!string3.startsWith(string2) || !string3.endsWith("}")) continue;
            hashMap.put(string3.substring(n, string3.length() - 1), this.parseProperty(string3, string4));
        }
        return hashMap;
    }
}

