/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.tools;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.commontemplate.config.Configuration;
import org.commontemplate.core.Context;
import org.commontemplate.core.Template;
import org.commontemplate.engine.Engine;
import org.commontemplate.tools.PropertiesConfigurationLoader;

public class TemplateRenderer {
    private Template template;
    private final Engine engine;
    private final Map variables = new HashMap();

    public TemplateRenderer(String string) {
        this(string, PropertiesConfigurationLoader.loadStandardConfiguration());
    }

    public TemplateRenderer(String string, Configuration configuration) {
        this.engine = new Engine(configuration);
        this.template = this.engine.parseTemplate(string);
    }

    public String evaluate() {
        StringWriter stringWriter = new StringWriter();
        this.render(stringWriter);
        String string = stringWriter.getBuffer().toString();
        stringWriter.getBuffer().setLength(0);
        return string;
    }

    public void render(Writer writer) {
        Context context = this.engine.createContext(writer);
        this.template.render(context);
    }

    public Object get(String string) {
        return this.variables.get(string);
    }

    public void remove(String string) {
        this.variables.remove(string);
    }

    public void clear() {
        this.variables.clear();
    }

    public TemplateRenderer putAll(Map map) {
        this.variables.putAll(map);
        return this;
    }

    public TemplateRenderer put(String string, Object object) {
        this.variables.put(string, object);
        return this;
    }

    public TemplateRenderer put(String string, char c) {
        this.variables.put(string, new Character(c));
        return this;
    }

    public TemplateRenderer put(String string, boolean bl) {
        this.variables.put(string, bl);
        return this;
    }

    public TemplateRenderer put(String string, byte by) {
        this.variables.put(string, new Byte(by));
        return this;
    }

    public TemplateRenderer put(String string, short s) {
        this.variables.put(string, new Short(s));
        return this;
    }

    public TemplateRenderer put(String string, int n) {
        this.variables.put(string, new Integer(n));
        return this;
    }

    public TemplateRenderer put(String string, long l) {
        this.variables.put(string, new Long(l));
        return this;
    }

    public TemplateRenderer put(String string, float f) {
        this.variables.put(string, new Float(f));
        return this;
    }

    public TemplateRenderer put(String string, double d) {
        this.variables.put(string, new Double(d));
        return this;
    }
}

