/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.tools;

import java.util.HashMap;
import java.util.Map;
import org.commontemplate.config.ExpressionConfiguration;
import org.commontemplate.core.VariableException;
import org.commontemplate.core.VariableResolver;
import org.commontemplate.engine.expression.ExpressionEngine;
import org.commontemplate.tools.PropertiesConfigurationLoader;

public class ExpressionEvaluator
implements VariableResolver {
    private final ExpressionEngine expressionEngine;
    private final String expr;
    private final Map variables = new HashMap();

    public ExpressionEvaluator(String string) {
        this(string, PropertiesConfigurationLoader.loadStandardExpressionConfiguration());
    }

    public ExpressionEvaluator(String string, ExpressionConfiguration expressionConfiguration) {
        this.expr = string;
        this.expressionEngine = new ExpressionEngine(expressionConfiguration);
    }

    public Object evaluate() {
        return this.expressionEngine.parseExpression(this.expr).evaluate(this);
    }

    public Object lookupVariable(String string) throws VariableException {
        return this.variables.get(string);
    }

    public Object get(String string) {
        return this.variables.get(string);
    }

    public void remove(String string) {
        this.variables.remove(string);
    }

    public void clear() {
        this.variables.clear();
    }

    public ExpressionEvaluator putAll(Map map) {
        this.variables.putAll(map);
        return this;
    }

    public ExpressionEvaluator put(String string, Object object) {
        this.variables.put(string, object);
        return this;
    }

    public ExpressionEvaluator put(String string, char c) {
        this.variables.put(string, new Character(c));
        return this;
    }

    public ExpressionEvaluator put(String string, boolean bl) {
        this.variables.put(string, bl);
        return this;
    }

    public ExpressionEvaluator put(String string, byte by) {
        this.variables.put(string, new Byte(by));
        return this;
    }

    public ExpressionEvaluator put(String string, short s) {
        this.variables.put(string, new Short(s));
        return this;
    }

    public ExpressionEvaluator put(String string, int n) {
        this.variables.put(string, new Integer(n));
        return this;
    }

    public ExpressionEvaluator put(String string, long l) {
        this.variables.put(string, new Long(l));
        return this;
    }

    public ExpressionEvaluator put(String string, float f) {
        this.variables.put(string, new Float(f));
        return this;
    }

    public ExpressionEvaluator put(String string, double d) {
        this.variables.put(string, new Double(d));
        return this;
    }
}

