/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.property.number;

import java.text.DecimalFormat;
import org.commontemplate.standard.property.PropertyHandlerSupport;

public class NumberToSizeHandler
extends PropertyHandlerSupport {
    private static final long serialVersionUID = 1L;

    public Object handleProperty(Object object) throws Exception {
        float f = ((Number)object).floatValue();
        if (f < 0.0f) {
            throw new IllegalArgumentException(f + ".toSizeString\u51fa\u9519\uff0cSize\u5fc5\u9700\u5927\u4e8e\u6216\u7b49\u4e8e0 !");
        }
        if (f < 1024.0f) {
            return ((Number)object).intValue() + "Bytes";
        }
        if (f < 1.0264576E7f) {
            return this.format(f / 1024.0f) + "KB";
        }
        return this.format(f / 1048576.0f) + "MB";
    }

    private String format(float f) {
        return new DecimalFormat("###,##0.##").format(f);
    }
}

