/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.operator.sequence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class StringSequence
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List sequence;
    private final boolean cycle;
    private final boolean ignoreCase;

    public StringSequence(String string, boolean bl, boolean bl2) {
        this(string.split("\\,"), bl, bl2);
    }

    public StringSequence(String[] stringArray, boolean bl, boolean bl2) {
        this(Arrays.asList(stringArray), bl, bl2);
    }

    public StringSequence(List list, boolean bl, boolean bl2) {
        this.sequence = Collections.unmodifiableList(list);
        this.cycle = bl;
        this.ignoreCase = bl2;
    }

    public List getSequence() {
        return this.sequence;
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean containSequence(String string, String string2) {
        return this.indexOf(string) != -1 && this.indexOf(string2) != -1;
    }

    public List getSequence(String string, String string2) {
        int n;
        int n2 = this.indexOf(string);
        if (n2 <= (n = this.indexOf(string2))) {
            return this.sequence.subList(n2, n + 1);
        }
        if (this.cycle) {
            return this.cycleList(n2, n);
        }
        return this.reverseList(n2, n);
    }

    private List cycleList(int n, int n2) {
        List list = this.sequence.subList(n, this.sequence.size());
        List list2 = this.sequence.subList(0, n2 + 1);
        ArrayList arrayList = new ArrayList(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    private List reverseList(int n, int n2) {
        List list = this.sequence.subList(n2, n + 1);
        Collections.reverse(list);
        return list;
    }

    private int indexOf(String string) {
        if (this.ignoreCase) {
            int n = this.sequence.size();
            for (int i = 0; i < n; ++i) {
                if (!string.equalsIgnoreCase((String)this.sequence.get(i))) continue;
                return i;
            }
            return -1;
        }
        return this.sequence.indexOf(string);
    }
}

