/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.operator.sequence;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class IntegerSequence
implements List,
Serializable {
    private static final long serialVersionUID = 1L;
    private int begin;
    private int end;
    private int min;
    private int max;
    private boolean asc;
    private int size;
    private String buffer;

    public IntegerSequence(int n, int n2) {
        this.begin = n;
        this.end = n2;
        if (n < n2) {
            this.min = n;
            this.max = n2;
            this.asc = true;
        } else {
            this.min = n2;
            this.max = n;
            this.asc = false;
        }
        this.size = this.max - this.min + 1;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean contains(Object object) {
        int n = (Integer)object;
        return n >= this.min && n <= this.max;
    }

    public Iterator iterator() {
        return new IntegerSequenceIterator(this.begin, this.end);
    }

    public Object[] toArray() {
        Object[] objectArray = new Integer[this.size];
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new Integer(this.begin + i);
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        return objectArray;
    }

    public boolean containsAll(Collection collection) {
        return false;
    }

    public Object get(int n) {
        int n2 = this.begin + (this.asc ? n : -n);
        if (this.asc && n2 > this.end || !this.asc && n2 < this.end) {
            throw new IndexOutOfBoundsException("index = " + n);
        }
        return new Integer(n2);
    }

    public int indexOf(Object object) {
        int n = (Integer)object;
        if (n < this.min || n > this.max) {
            return -1;
        }
        return n - this.begin;
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public ListIterator listIterator() {
        return new IntegerSequenceIterator(this.begin, this.end);
    }

    public ListIterator listIterator(int n) {
        int n2 = this.begin + (this.asc ? n : -n);
        if (this.asc && n2 > this.end || !this.asc && n2 < this.end) {
            throw new IndexOutOfBoundsException("index = " + n);
        }
        return new IntegerSequenceIterator(n2, this.end);
    }

    public List subList(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        return new IntegerSequence(this.begin + n, this.begin + n + n2);
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.buffer == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            for (int i = this.min; i <= this.max; ++i) {
                if (i != this.min) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.asc ? i : this.max + this.min - i);
            }
            stringBuffer.append("]");
            this.buffer = stringBuffer.toString();
        }
        return this.buffer;
    }

    private static final class IntegerSequenceIterator
    implements ListIterator {
        private int begin;
        private int end;
        private int cur;
        private int inc;
        private boolean first;

        public IntegerSequenceIterator(int n, int n2) {
            this.begin = n;
            this.end = n2;
            this.first = true;
            this.cur = n;
            this.inc = n < n2 ? 1 : -1;
        }

        public boolean hasNext() {
            return this.first || this.cur != this.end;
        }

        public Object next() {
            if (this.first) {
                this.first = false;
                return new Integer(this.cur);
            }
            if (this.cur == this.end) {
                throw new NoSuchElementException("IndexOutOfBounds");
            }
            this.cur += this.inc;
            return new Integer(this.cur);
        }

        public int nextIndex() {
            if (this.first) {
                this.first = false;
                return 0;
            }
            if (this.cur == this.end) {
                throw new NoSuchElementException("IndexOutOfBounds");
            }
            this.cur += this.inc;
            return this.cur - this.begin;
        }

        public boolean hasPrevious() {
            return this.first || this.cur != this.begin;
        }

        public Object previous() {
            if (this.first) {
                this.first = false;
                return new Integer(this.cur);
            }
            if (this.cur == this.begin) {
                throw new NoSuchElementException("IndexOutOfBounds");
            }
            this.cur -= this.inc;
            return new Integer(this.cur);
        }

        public int previousIndex() {
            if (this.first) {
                this.first = false;
                return 0;
            }
            if (this.cur == this.begin) {
                throw new NoSuchElementException("IndexOutOfBounds");
            }
            this.cur -= this.inc;
            return this.cur - this.begin;
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

