/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.operator.sequence;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CharacterSequence
implements List,
Serializable {
    private static final long serialVersionUID = 1L;
    private char begin;
    private char end;
    private char min;
    private char max;
    private boolean asc;
    private int size;
    private String buffer;

    public CharacterSequence(char c, char c2) {
        this.begin = c;
        this.end = c2;
        if (c < c2) {
            this.min = c;
            this.max = c2;
            this.asc = true;
        } else {
            this.min = c2;
            this.max = c;
            this.asc = false;
        }
        this.size = this.max - this.min + 1;
    }

    public char getBegin() {
        return this.begin;
    }

    public char getEnd() {
        return this.end;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean contains(Object object) {
        char c = ((Character)object).charValue();
        return c >= this.min && c <= this.max;
    }

    public Iterator iterator() {
        return new CharacterSequenceIterator(this.begin, this.end);
    }

    public Object[] toArray() {
        Object[] objectArray = new Character[this.size];
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new Character((char)(this.begin + i));
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        return objectArray;
    }

    public boolean containsAll(Collection collection) {
        return false;
    }

    public Object get(int n) {
        char c = (char)(this.begin + (this.asc ? n : -n));
        if (this.asc && c > this.end || !this.asc && c < this.end) {
            throw new IndexOutOfBoundsException("index = " + n);
        }
        return new Character(c);
    }

    public int indexOf(Object object) {
        char c = ((Character)object).charValue();
        if (c < this.min || c > this.max) {
            return -1;
        }
        return c - this.begin;
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public ListIterator listIterator() {
        return new CharacterSequenceIterator(this.begin, this.end);
    }

    public ListIterator listIterator(int n) {
        char c = (char)(this.begin + (this.asc ? n : -n));
        if (this.asc && c > this.end || !this.asc && c < this.end) {
            throw new IndexOutOfBoundsException("index = " + n);
        }
        return new CharacterSequenceIterator(c, this.end);
    }

    public List subList(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        return new CharacterSequence((char)(this.begin + n), (char)(this.begin + n + n2));
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.buffer == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            for (int n = this.min; n <= this.max; n = (int)((char)(n + 1))) {
                if (n != this.min) {
                    stringBuffer.append(",");
                }
                stringBuffer.append((char)(this.asc ? n : this.max + this.min - n));
            }
            stringBuffer.append("]");
            this.buffer = stringBuffer.toString();
        }
        return this.buffer;
    }

    private static final class CharacterSequenceIterator
    implements ListIterator {
        private char begin;
        private char end;
        private char cur;
        private char inc;
        private boolean first;

        public CharacterSequenceIterator(char c, char c2) {
            this.begin = c;
            this.end = c2;
            this.first = true;
            this.cur = c;
            this.inc = (char)(c < c2 ? 1 : -1);
        }

        public boolean hasNext() {
            return this.first || this.cur != this.end;
        }

        public Object next() {
            if (this.first) {
                this.first = false;
                return new Character(this.cur);
            }
            if (this.cur == this.end) {
                throw new NoSuchElementException("IndexOutOfBounds");
            }
            this.cur = (char)(this.cur + this.inc);
            return new Character(this.cur);
        }

        public int nextIndex() {
            if (this.first) {
                this.first = false;
                return 0;
            }
            if (this.cur == this.end) {
                throw new NoSuchElementException("IndexOutOfBounds");
            }
            this.cur = (char)(this.cur + this.inc);
            return this.cur - this.begin;
        }

        public boolean hasPrevious() {
            return this.first || this.cur != this.begin;
        }

        public Object previous() {
            if (this.first) {
                this.first = false;
                return new Character(this.cur);
            }
            if (this.cur == this.begin) {
                throw new NoSuchElementException("IndexOutOfBounds");
            }
            this.cur = (char)(this.cur - this.inc);
            return new Character(this.cur);
        }

        public int previousIndex() {
            if (this.first) {
                this.first = false;
                return 0;
            }
            if (this.cur == this.begin) {
                throw new NoSuchElementException("IndexOutOfBounds");
            }
            this.cur = (char)(this.cur - this.inc);
            return this.cur - this.begin;
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

