/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.operator;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.commontemplate.core.DefinedException;
import org.commontemplate.core.UndefinedException;
import org.commontemplate.core.VariableException;
import org.commontemplate.core.VariableResolver;
import org.commontemplate.util.TypeUtils;

public class SimpleExpressionContext
implements VariableResolver {
    private final Map variablesContainer = new HashMap();
    private final Map aliasContainer = new HashMap();
    private final Set readonlyContainer = new HashSet();
    private boolean isLock = false;

    protected void assertVariables(Map map) throws VariableException {
        if (map != null && map.size() > 0) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.assertVariableName(string);
                if (!this.isDefinedVariable(string)) continue;
                throw new DefinedException(string + " \u5df2\u7ecf\u5b9a\u4e49!", string);
            }
        }
    }

    protected void assertVariableName(String string) throws VariableException {
        if (string == null) {
            throw new VariableException("\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3a\u7a7a!", null);
        }
        if (!TypeUtils.isNamed(string)) {
            throw new VariableException(string + " \u4e0d\u7b26\u5408\u547d\u540d\u89c4\u8303!", string);
        }
    }

    public void lockVariables() {
        this.isLock = true;
    }

    public void unlockVariables() {
        this.isLock = false;
    }

    public boolean isDefinedVariable(String string) throws VariableException {
        return this.variablesContainer.containsKey(string);
    }

    public void defineVariable(String string, Object object) throws DefinedException, VariableException {
        if (this.isLock) {
            throw new VariableException("\u5bb9\u5668\u9501\u5b9a!", string);
        }
        this.variablesContainer.put(string, object);
    }

    public void defineVariable(String string) throws DefinedException, VariableException {
        this.defineVariable(string, null);
    }

    public void defineReadonlyVariable(String string, Object object) throws DefinedException, VariableException {
        this.defineVariable(string, object);
        this.readonlyContainer.add(string);
    }

    public void defineAllVariables(Map map) throws DefinedException, VariableException {
        if (this.isLock) {
            throw new VariableException("\u5bb9\u5668\u9501\u5b9a!", map.keySet().toString());
        }
        this.variablesContainer.putAll(map);
    }

    public void defineVariableAlias(String string, String string2) throws VariableException {
        this.aliasContainer.put(string, string2);
    }

    public void assignVariable(String string, Object object) throws UndefinedException, VariableException {
        if (this.isLock) {
            throw new VariableException("\u5bb9\u5668\u9501\u5b9a!", string);
        }
        this.variablesContainer.put(string, object);
    }

    public Object lookupVariable(String string) throws VariableException {
        return this.variablesContainer.get(string);
    }

    public Map getDefinedVariables() {
        return Collections.unmodifiableMap(this.variablesContainer);
    }

    public void removeVariableAlias(String string) throws VariableException {
        this.aliasContainer.remove(string);
    }

    public void removeVariable(String string) throws UndefinedException, VariableException {
        Map.Entry entry;
        if (this.isLock) {
            throw new VariableException("\u53d8\u91cf\u5bb9\u5668\u9501\u5b9a! \u65e0\u6cd5\u79fb\u9664\uff1a" + string, string);
        }
        this.assertVariableName(string);
        this.variablesContainer.remove(string);
        this.readonlyContainer.remove(string);
        HashSet hashSet = new HashSet();
        Iterator iterator = this.aliasContainer.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!string.equals(entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            this.aliasContainer.remove(entry);
        }
        hashSet.clear();
    }

    public void clearVariables() {
        this.variablesContainer.clear();
        this.aliasContainer.clear();
        this.readonlyContainer.clear();
    }
}

