/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.commontemplate.standard.loader.AbstractResource;
import org.commontemplate.util.Assert;

public class ZipResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private final File file;

    public ZipResource(File file, String string, String string2) {
        super(string, string2);
        Assert.assertNotNull(file, "\u627e\u4e0d\u5230\u6a21\u677f\u6587\u4ef6!");
        this.file = file;
    }

    protected InputStream getInputStream() throws IOException {
        ZipFile zipFile = new ZipFile(this.file);
        return zipFile.getInputStream(zipFile.getEntry(this.getName()));
    }

    public long getLastModified() {
        try {
            ZipFile zipFile = new ZipFile(this.file);
            return zipFile.getEntry(this.getName()).getTime();
        }
        catch (ZipException zipException) {
            return -1L;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

