/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.loader;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.commontemplate.core.Resource;
import org.commontemplate.util.Assert;

class StringResource
extends Resource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String name;
    private final long lastModified;
    private static final String STRING_ENCODING = "UTF-8";

    public StringResource(String string, String string2) {
        Assert.assertNotNull(string, "\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a!");
        this.source = string;
        this.name = string2;
        this.lastModified = System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public String getEncoding() {
        return STRING_ENCODING;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public Reader getReader() throws IOException {
        return new StringReader(this.source);
    }
}

