/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.format;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.commontemplate.config.ConfigurationException;
import org.commontemplate.core.OutputFormatter;
import org.commontemplate.core.UnformattedException;
import org.commontemplate.util.ClassUtils;

public class OutputFormatterChain
implements OutputFormatter,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map typeFormatters;
    private OutputFormatter nullFormatter;
    private OutputFormatter generalFormatter;

    public void setTypeFormatters(Map map) {
        this.typeFormatters = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                this.typeFormatters.put(ClassUtils.forCanonicalName((String)entry.getKey()), entry.getValue());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException(entry.getKey() + "\u4e3a\u975e\u6cd5\u7684\u7c7b\u540d\uff01", classNotFoundException);
            }
        }
    }

    public void setNullFormatter(OutputFormatter outputFormatter) {
        this.nullFormatter = outputFormatter;
    }

    public void setGeneralFormatter(OutputFormatter outputFormatter) {
        this.generalFormatter = outputFormatter;
    }

    public String format(Object object, Locale locale, TimeZone timeZone) throws UnformattedException {
        if (object == null) {
            if (this.nullFormatter != null) {
                return this.nullFormatter.format(null, locale, timeZone);
            }
        } else if (this.typeFormatters != null && this.typeFormatters.size() > 0) {
            Iterator iterator = this.typeFormatters.entrySet().iterator();
            while (iterator.hasNext()) {
                OutputFormatter outputFormatter;
                Map.Entry entry = iterator.next();
                Class clazz = (Class)entry.getKey();
                if (clazz == null || !clazz.isAssignableFrom(object.getClass()) || (outputFormatter = (OutputFormatter)entry.getValue()) == null) continue;
                return outputFormatter.format(object, locale, timeZone);
            }
        }
        if (this.generalFormatter != null) {
            return this.generalFormatter.format(object, locale, timeZone);
        }
        throw new UnformattedException();
    }
}

