/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.filter;

import java.util.Iterator;
import java.util.LinkedList;
import org.commontemplate.config.InvalidTemplateNameException;
import org.commontemplate.config.TemplateNameFilter;

public class TemplateNameRelativer
implements TemplateNameFilter {
    public static final String PROTOCOL_SEPARATOR = "://";
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    public static final String PARENT_PATH = "..";
    public static final String CURRENT_PATH = ".";

    public String filter(String string, String string2) throws InvalidTemplateNameException {
        if (string == null) {
            throw new InvalidTemplateNameException("\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (string.indexOf(PROTOCOL_SEPARATOR) > 0) {
            return string;
        }
        if (string.trim().charAt(0) == '/') {
            return this.clean(string);
        }
        return this.clean(this.cutPath(string2) + string);
    }

    private String cutPath(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(47)) >= 0) {
            return string.substring(0, n + 1);
        }
        return PATH_SEPARATOR;
    }

    String clean(String string) throws InvalidTemplateNameException {
        String[] stringArray = string.split(PATH_SEPARATOR);
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (PARENT_PATH.equals(stringArray[i])) {
                if (linkedList.isEmpty()) {
                    throw new InvalidTemplateNameException("\u975e\u6cd5\u8def\u5f84\u8bbf\u95ee\uff0c\u4e0d\u5141\u8bb8\"../\"\u8bbf\u95ee\u6839\u76ee\u5f55\"/\"\u4ee5\u4e0a\u7684\u76ee\u5f55\uff01");
                }
                linkedList.removeLast();
                continue;
            }
            if (stringArray[i] == null || stringArray[i].trim().length() <= 0 || CURRENT_PATH.equals(stringArray[i])) continue;
            linkedList.addLast(stringArray[i]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(PATH_SEPARATOR);
            stringBuffer.append((String)iterator.next());
        }
        return stringBuffer.toString();
    }
}

