/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.directive.taglib;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;

class JspWriterImpl
extends JspWriter {
    private static final char[] NEWLINE = System.getProperty("line.separator").toCharArray();
    private final Writer out;

    JspWriterImpl(Writer writer) {
        super(0, true);
        this.out = writer;
    }

    public String toString() {
        return "JspWriterImpl wrapping a " + this.out.toString();
    }

    public void clear() throws IOException {
        throw new IOException("Can't clear");
    }

    public void clearBuffer() throws IOException {
        throw new IOException("Can't clear");
    }

    public void close() throws IOException {
        throw new IOException("Close not permitted.");
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public int getRemaining() {
        return 0;
    }

    public void newLine() throws IOException {
        this.out.write(NEWLINE);
    }

    public void print(boolean bl) throws IOException {
        this.out.write(bl ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public void print(char c) throws IOException {
        this.out.write(c);
    }

    public void print(char[] cArray) throws IOException {
        this.out.write(cArray);
    }

    public void print(double d) throws IOException {
        this.out.write(Double.toString(d));
    }

    public void print(float f) throws IOException {
        this.out.write(Float.toString(f));
    }

    public void print(int n) throws IOException {
        this.out.write(Integer.toString(n));
    }

    public void print(long l) throws IOException {
        this.out.write(Long.toString(l));
    }

    public void print(Object object) throws IOException {
        this.out.write(object == null ? "null" : object.toString());
    }

    public void print(String string) throws IOException {
        this.out.write(string);
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean bl) throws IOException {
        this.print(bl);
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(char[] cArray) throws IOException {
        this.print(cArray);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.newLine();
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.newLine();
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.newLine();
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.newLine();
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.out.write(cArray, n, n2);
    }
}

