/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.directive.taglib;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;

class BodyContentImpl
extends BodyContent {
    private static final char[] NEWLINE = System.getProperty("line.separator").toCharArray();
    private CharArrayWriter buf;

    BodyContentImpl(JspWriter jspWriter, boolean bl) {
        super(jspWriter);
        if (bl) {
            this.buf = new CharArrayWriter();
        }
    }

    public void flush() throws IOException {
        if (this.buf == null) {
            this.getEnclosingWriter().flush();
        }
    }

    public void clear() throws IOException {
        if (this.buf == null) {
            throw new IOException("Can't clear");
        }
        this.buf = new CharArrayWriter();
    }

    public void clearBuffer() throws IOException {
        if (this.buf == null) {
            throw new IOException("Can't clear");
        }
        this.buf = new CharArrayWriter();
    }

    public int getRemaining() {
        return Integer.MAX_VALUE;
    }

    public void newLine() throws IOException {
        this.write(NEWLINE);
    }

    public void close() throws IOException {
    }

    public void print(boolean bl) throws IOException {
        this.write(bl ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public void print(char c) throws IOException {
        this.write(c);
    }

    public void print(char[] cArray) throws IOException {
        this.write(cArray);
    }

    public void print(double d) throws IOException {
        this.write(Double.toString(d));
    }

    public void print(float f) throws IOException {
        this.write(Float.toString(f));
    }

    public void print(int n) throws IOException {
        this.write(Integer.toString(n));
    }

    public void print(long l) throws IOException {
        this.write(Long.toString(l));
    }

    public void print(Object object) throws IOException {
        this.write(object == null ? "null" : object.toString());
    }

    public void print(String string) throws IOException {
        this.write(string);
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean bl) throws IOException {
        this.print(bl);
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(char[] cArray) throws IOException {
        this.print(cArray);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.newLine();
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.newLine();
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.newLine();
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.newLine();
    }

    public void write(int n) throws IOException {
        if (this.buf != null) {
            this.buf.write(n);
        } else {
            this.getEnclosingWriter().write(n);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.buf != null) {
            this.buf.write(cArray, n, n2);
        } else {
            this.getEnclosingWriter().write(cArray, n, n2);
        }
    }

    public String getString() {
        return this.buf.toString();
    }

    public Reader getReader() {
        return new CharArrayReader(this.buf.toCharArray());
    }

    public void writeOut(Writer writer) throws IOException {
        this.buf.writeTo(writer);
    }
}

