/*
 * Decompiled with CFR 0.152.
 */
package org.commontemplate.standard.directive.iteration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.commontemplate.config.BlockDirectiveHandler;
import org.commontemplate.core.Context;
import org.commontemplate.core.EvaluationException;
import org.commontemplate.core.InterpretationException;
import org.commontemplate.standard.directive.DirectiveUtils;
import org.commontemplate.standard.directive.iteration.BreakException;
import org.commontemplate.standard.directive.iteration.ContinueException;
import org.commontemplate.standard.directive.iteration.ForeachStatus;
import org.commontemplate.standard.operator.collection.LiteralEntry;
import org.commontemplate.standard.operator.collection.LiteralMap;
import org.commontemplate.util.Assert;

public class ForeachDirectiveHandler
extends BlockDirectiveHandler {
    private static final long serialVersionUID = 1L;
    private String statusName = "for";
    public static final String FOR_STATUS = "for.status";

    public void setStatusName(String string) {
        Assert.assertNotEmpty(string, "\u72b6\u6001\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.statusName = string;
    }

    public void doInterpret(String string, Object object, List list, Context context) throws Exception {
        boolean bl = this.doForeach(context, object, list);
        context.getSuperLocalContext().setStatus(FOR_STATUS, bl);
    }

    private boolean doForeach(Context context, Object object, List list) throws InterpretationException, EvaluationException, IOException {
        if (object instanceof LiteralEntry) {
            return this.normalForeach(context, (LiteralEntry)object, list);
        }
        if (object instanceof LiteralMap) {
            return this.parallelForeach(context, (LiteralMap)object, list);
        }
        if (object instanceof Integer) {
            return this.simpleForeach(context, (Integer)object, list);
        }
        throw new RuntimeException("for\u6307\u4ee4\u53c2\u6570\u9519\u8bef!");
    }

    private boolean simpleForeach(Context context, int n, List list) {
        if (n == 0) {
            return false;
        }
        if (n < 0) {
            n = -n;
        }
        ForeachStatus foreachStatus = new ForeachStatus(n);
        context.defineVariable(this.statusName, foreachStatus);
        for (int i = 0; i < n; ++i) {
            context.assignVariable(this.statusName, foreachStatus);
            try {
                DirectiveUtils.interpretAll(list, context);
                foreachStatus.increment();
                continue;
            }
            catch (ContinueException continueException) {
                foreachStatus.increment();
                continue;
            }
            catch (BreakException breakException) {
                break;
            }
        }
        return true;
    }

    private boolean normalForeach(Context context, LiteralEntry literalEntry, List list) {
        String string = String.valueOf(literalEntry.getKey());
        Collection collection = this.getCollection(literalEntry.getValue());
        if (collection == null || collection.size() == 0) {
            return false;
        }
        ForeachStatus foreachStatus = new ForeachStatus(collection.size());
        context.defineVariable(string);
        context.defineVariable(this.statusName, foreachStatus);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            context.assignVariable(string, e);
            context.assignVariable(this.statusName, foreachStatus);
            try {
                DirectiveUtils.interpretAll(list, context);
                foreachStatus.increment();
            }
            catch (ContinueException continueException) {
                foreachStatus.increment();
            }
            catch (BreakException breakException) {
                break;
            }
        }
        return true;
    }

    private boolean parallelForeach(Context context, Map map, List list) {
        Object object;
        Object object2;
        int n = 0;
        HashMap hashMap = new HashMap(map.size());
        Object object3 = map.entrySet().iterator();
        while (object3.hasNext()) {
            Map.Entry entry = object3.next();
            object2 = this.getCollection(entry.getValue());
            object = String.valueOf(entry.getKey());
            context.defineVariable((String)object);
            hashMap.put((String)object, object2.iterator());
            if (object2.size() <= n) continue;
            n = object2.size();
        }
        if (n == 0) {
            return false;
        }
        object3 = new ForeachStatus(n);
        context.defineVariable(this.statusName, object3);
        for (int i = 0; i < n; ++i) {
            context.assignVariable(this.statusName, object3);
            object2 = hashMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                String string = (String)object.getKey();
                Iterator iterator = (Iterator)object.getValue();
                if (iterator.hasNext()) {
                    context.assignVariable(string, iterator.next());
                    continue;
                }
                context.assignVariable(string, null);
            }
            try {
                DirectiveUtils.interpretAll(list, context);
                ((ForeachStatus)object3).increment();
                continue;
            }
            catch (ContinueException continueException) {
                ((ForeachStatus)object3).increment();
                continue;
            }
            catch (BreakException breakException) {
                break;
            }
        }
        return true;
    }

    private Collection getCollection(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        if (object instanceof Map) {
            return ((Map)object).entrySet();
        }
        HashSet<Object> hashSet = new HashSet<Object>(1);
        hashSet.add(object);
        return hashSet;
    }
}

